<?php
if ($tipo_reporte == 'excel') {
  header("Content-Type: application/vnd.ms-excel");
  header("Expires: 0");
  header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
  header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if ($tipo_reporte != 'grid') :
?>
  <style type="text/css">
    .tabla {
      width: 100%;
      margin-left: auto;
      margin-right: auto;
    }

    th {
      font-weight: bold !important;
    }

    td {
      font-family: arial;
    }

    .fuente_titulo {
      font-family: <?php echo $tipo_fuente; ?>;
    }
  </style>
  <?php if ($tipo_reporte == 'excel') {
  ?>
    <table>
      <thead>
        <tr>
          <th colspan="12">Listado detallado documentos por proyecto</th>
        </tr>
      </thead>
    </table>
  <?php
  }
  ?>

  <?php
  if (count($proyectos) > 0) :
    $num_pro = 1;
    $registro = array();
    $cantidad = 0;
    $precio = 0;
    $subtotales = 0;
    $descuentos = 0;
    $impuestos = 0;
    $totales = 0;
    $primerCliente = true;
    $nombreCompare = 0;
    $foot = false;
    foreach ($proyectos as $key) :

      $nombre_tmp = $key['pcl_id'];

      if ($nombreCompare != $nombre_tmp) {
        $primerCliente = true;
        if ($foot) {
  ?>
          </tbody>
          <tfoot>
            <tr style="border-bottom:1px solid #c4c4c4">
              <td colspan="6" style="text-align: right;">Totales</td>
              <td><?= ((float)$cantidad) ?></td>
              <td><?= number_format($precio, 2) ?></td>
              <td><?= number_format($subtotales, 2) ?></td>
              <td><?= number_format($descuentos, 2) ?></td>
              <td><?= number_format($impuestos, 2) ?></td>
              <td><?= number_format($totales, 2) ?></td>
            </tr>
          </tfoot>
          </table>
          <br>
          <br>

        <?php
          $cantidad = 0;
          $precio = 0;
          $subtotales = 0;
          $descuentos = 0;
          $impuestos = 0;
          $totales = 0;
          $num_pro = 1;
        }
        $foot = true;
      }

      $cantidad += $key['cantidad'];
      $precio += $key['precio'];
      $subtotales += $key['subtotal'];
      $descuentos += $key['descuento'];
      $impuestos += $key['impuesto'];
      $totales += $key['total'];

      if ($primerCliente) :
        $primerCliente = false;
        $nombreCompare = $nombre_tmp;
        ?>
        <table border="1" width="100%">
          <thead>
            <tr>
              <th colspan="11">Cliente: <?php echo $key['cliente']; ?></th>
            </tr>
            <tr>
              <th width="4%">No.</th>
              <th>Proyecto</th>
              <th>No. DPV</th>
              <th>Cod. producto</th>
              <th>Nombre de producto</th>
              <th>Proveedor</th>
              <th>Cantidad</th>
              <th>Precio Unitario</th>
              <th>Sub-total</th>
              <th>Descuentos</th>
              <th>Impuestos</th>
              <th>Total</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td width="4%"><?php echo $num_pro++; ?></td>
              <td><?= $key['pcl_nombre'] ?></td>
              <td><?= $key['dpv_numero_documento'] ?></td>
              <td><?= $key['art_codigo'] ?></td>
              <td><?= $key['art_nombre'] ?></td>
              <td><?= $key['proveedor'] ?></td>
              <td><?= ((float)$key['cantidad']) ?></td>
              <td><?= number_format($key['precio'], 2) ?></td>
              <td><?= number_format($key['subtotal'], 2) ?></td>
              <td><?= number_format($key['descuento'], 2) ?></td>
              <td><?= number_format($key['impuesto'], 2) ?></td>
              <td><?= number_format($key['total'], 2) ?></td>
            </tr>
          <?php else : ?>
            <tr>
              <td><?php echo $num_pro++; ?></td>
              <td><?= $key['pcl_nombre'] ?></td>
              <td><?= $key['dpv_numero_documento'] ?></td>
              <td><?= $key['art_codigo'] ?></td>
              <td><?= $key['art_nombre'] ?></td>
              <td><?= $key['proveedor'] ?></td>
              <td><?= ((float)$key['cantidad']) ?></td>
              <td><?= number_format($key['precio'], 2) ?></td>
              <td><?= number_format($key['subtotal'], 2) ?></td>
              <td><?= number_format($key['descuento'], 2) ?></td>
              <td><?= number_format($key['impuesto'], 2) ?></td>
              <td><?= number_format($key['total'], 2) ?></td>
            </tr>
          <?php endif; ?>

        <?php endforeach; ?>
          </tbody>
          <tfoot>
            <tr style="border-bottom:1px solid #c4c4c4">
              <td colspan="6" style="text-align: right;">Totales</td>
              <td><?= ((float)$cantidad) ?></td>
              <td><?= number_format($precio, 2) ?></td>
              <td><?= number_format($subtotales, 2) ?></td>
              <td><?= number_format($descuentos, 2) ?></td>
              <td><?= number_format($impuestos, 2) ?></td>
              <td><?= number_format($totales, 2) ?></td>
            </tr>
          </tfoot>
        </table>
        <br>
        <br>
      <?php endif; ?>

    <?php
  else :

    ?>
      <!--Datos de la grid-->

      <?php
      if (count($proyectos) > 0) :
        $num_pro = 1;
        $registro = array();
        $cantidad = 0;
        $precio = 0;
        $subtotales = 0;
        $descuentos = 0;
        $impuestos = 0;
        $totales = 0;
        $primerCliente = true;
        $nombreCompare = 0;
        $foot = false;
        foreach ($proyectos as $key) :

          $nombre_tmp = $key['pcl_id'];

          if ($nombreCompare != $nombre_tmp) {
            $primerCliente = true;
            if ($foot) {
      ?>
              </tbody>
              <tfoot>
                <tr style="border-bottom:1px solid #c4c4c4">
                  <td></td>
                  <td></td>
                  <td></td>
                  <td></td>
                  <td></td>
                  <td>Totales</td>
                  <td><?= ((float)$cantidad) ?></td>
                  <td><?= number_format($precio, 2) ?></td>
                  <td><?= number_format($subtotales, 2) ?></td>
                  <td><?= number_format($descuentos, 2) ?></td>
                  <td><?= number_format($impuestos, 2) ?></td>
                  <td><?= number_format($totales, 2) ?></td>
                </tr>
              </tfoot>
              </table>
              <br>
              <br>

            <?php
              $cantidad = 0;
              $precio = 0;
              $subtotales = 0;
              $descuentos = 0;
              $impuestos = 0;
              $totales = 0;
              $num_pro = 1;
            }
            $foot = true;
          }

          $cantidad += $key['cantidad'];
          $precio += $key['precio'];
          $subtotales += $key['subtotal'];
          $descuentos += $key['descuento'];
          $impuestos += $key['impuesto'];
          $totales += $key['total'];

          if ($primerCliente) :
            $primerCliente = false;
            $nombreCompare = $nombre_tmp;
            ?>
            <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
              <thead>
                <tr>
                  <th colspan="12">Cliente: <?php echo $key['cliente']; ?></th>
                </tr>
                <tr>
                  <th>No.</th>
                  <th>Proyecto</th>
                  <th>No. DPV</th>
                  <th>Cod. producto</th>
                  <th>Nombre de producto</th>
                  <th>Proveedor</th>
                  <th>Cantidad</th>
                  <th>Precio Unitario</th>
                  <th>Sub-total</th>
                  <th>Descuentos</th>
                  <th>Impuestos</th>
                  <th>Total</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><?php echo $num_pro++; ?></td>
                  <td><?= $key['pcl_nombre'] ?></td>
                  <td><?= $key['dpv_numero_documento'] ?></td>
                  <td><?= $key['art_codigo'] ?></td>
                  <td><?= $key['art_nombre'] ?></td>
                  <td><?= $key['proveedor'] ?></td>
                  <td><?= ((float)$key['cantidad']) ?></td>
                  <td><?= number_format($key['precio'], 2) ?></td>
                  <td><?= number_format($key['subtotal'], 2) ?></td>
                  <td><?= number_format($key['descuento'], 2) ?></td>
                  <td><?= number_format($key['impuesto'], 2) ?></td>
                  <td><?= number_format($key['total'], 2) ?></td>
                </tr>
              <?php else : ?>
                <tr>
                  <td><?php echo $num_pro++; ?></td>
                  <td><?= $key['pcl_nombre'] ?></td>
                  <td><?= $key['dpv_numero_documento'] ?></td>
                  <td><?= $key['art_codigo'] ?></td>
                  <td><?= $key['art_nombre'] ?></td>
                  <td><?= $key['proveedor'] ?></td>
                  <td><?= ((float)$key['cantidad']) ?></td>
                  <td><?= number_format($key['precio'], 2) ?></td>
                  <td><?= number_format($key['subtotal'], 2) ?></td>
                  <td><?= number_format($key['descuento'], 2) ?></td>
                  <td><?= number_format($key['impuesto'], 2) ?></td>
                  <td><?= number_format($key['total'], 2) ?></td>
                </tr>
              <?php endif; ?>

            <?php endforeach; ?>
              </tbody>
              <tfoot>
                <tr style="border-bottom:1px solid #c4c4c4">
                  <td></td>
                  <td></td>
                  <td></td>
                  <td></td>
                  <td></td>
                  <td>Totales</td>
                  <td><?= ((float)$cantidad) ?></td>
                  <td><?= number_format($precio, 2) ?></td>
                  <td><?= number_format($subtotales, 2) ?></td>
                  <td><?= number_format($descuentos, 2) ?></td>
                  <td><?= number_format($impuestos, 2) ?></td>
                  <td><?= number_format($totales, 2) ?></td>
                </tr>
              </tfoot>
            </table>
            <br>
            <br>
          <?php endif; ?>

        <?php endif; ?>