<?php 
    if($tipo_reporte == 'excel'){
        header("Content-Type: application/vnd.ms-excel");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("content-disposition: attachment;filename=" . $filename . ".xls");
    }
    $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
    if($tipo_reporte != 'grid'){
?>
<style type="text/css">
    .tabla
    {           
        width: 100%;
        margin-left: auto;
        margin-right: auto;
    }
    th
    {
        font-weight: bold !important;                  
    }
    td
    {   
        font-family: arial;             
    }    
    .fuente_titulo{
        font-family: <?php echo $tipo_fuente; ?>;
    }    
</style> 
    <?php if ($tipo_reporte == 'excel') {
        ?>
        <table>
            <thead>
                <tr>
                    <th colspan="11">Listado de compras por proyecto</th>
                </tr>
            </thead>
        </table>
        <?php
    } 
    ?>
<table border="1" width="100%">
    <thead>
        <tr>
            <th width="4%">No.</th>
            <th>Orc. numero</th>
            <th>Fecha</th>
            <th>Cliente</th>
            <th>Proyecto</th>
            <th>Estado</th>
            <th>Proveedor</th>
            <th>Sub-total</th>
            <th>Descuentos</th>
            <th>Impuestos</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
    <?php  
        if(count($proyectos)>0){
            $num_pro =1;
            $registro = array();
            $subtotales = 0;
            $descuentos = 0;
            $impuestos = 0;
            $totales = 0;
        foreach ($proyectos as $key) {
            $fecha = formatear_fecha('d-m-Y',$key['orc_fecha_orden']);
            $subtotales += number_format($key['subtotal'], 2);
            $descuentos += number_format($key['descuento'], 2);
            $impuestos += number_format($key['impuesto'], 2);
            $totales += number_format($key['total'], 2);
        ?>
            <tr>
                <td width="4%"><?php echo $num_pro++; ?></td>
                <td><?=$key['orc_numero']?></td>
                <td><?=$fecha?></td>
                <td><?=$key['cliente']?></td>
                <td><?=$key['proyecto']?></td>
                <td><?=$key['epr_nombre']?></td>
                <td><?=$key['prv_nombre']?></td>
                <td><?=number_format($key['subtotal'], 2)?></td>
                <td><?=number_format($key['descuento'], 2)?></td>
                <td><?=number_format($key['impuesto'], 2)?></td>
                <td><?=number_format($key['total'], 2)?></td>
            </tr>
        <?php } ?>
            <tr>
                <td colspan="7" style="text-align: right;">Totales</td>
                <td><?=number_format($subtotales,2)?></td>
                <td><?=number_format($descuentos,2)?></td>
                <td><?=number_format($impuestos,2)?></td>
                <td><?=number_format($totales,2)?></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
<?php 
    } else{ 
        
?>
<!--Datos de la grid-->
<table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
    <thead>
        <tr>
            <th>No.</th>
            <th>Orc. numero</th>
            <th>Fecha</th>
            <th>Cliente</th>
            <th>Proyecto</th>
            <th>Estado</th>
            <th>Proveedor</th>
            <th>Sub-total</th>
            <th>Descuentos</th>
            <th>Impuestos</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        if(count($proyectos)>0){
            $num_pro =1;
            $registro = array();
            $subtotales = 0;
            $descuentos = 0;
            $impuestos = 0;
            $totales = 0;
        foreach ($proyectos as $key) {
            $fecha = formatear_fecha('d-m-Y',$key['orc_fecha_orden']);
            $subtotales += number_format($key['subtotal'], 2);
            $descuentos += number_format($key['descuento'], 2);
            $impuestos += number_format($key['impuesto'], 2);
            $totales += number_format($key['total'], 2);
        ?>
            <tr>
                <td><?php echo $num_pro++; ?></td>
                <td><?=$key['orc_numero']?></td>
                <td><?=$fecha?></td>
                <td><?=$key['cliente']?></td>
                <td><?=$key['proyecto']?></td>
                <td><?=$key['epr_nombre']?></td>
                <td><?=$key['prv_nombre']?></td>
                <td><?=number_format($key['subtotal'], 2)?></td>
                <td><?=number_format($key['descuento'], 2)?></td>
                <td><?=number_format($key['impuesto'], 2)?></td>
                <td><?=number_format($key['total'], 2)?></td>
            </tr>
        <?php } ?>
            <tfoot>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td>Totales</td>
                <td><?=number_format($subtotales,2)?></td>
                <td><?=number_format($descuentos,2)?></td>
                <td><?=number_format($impuestos,2)?></td>
                <td><?=number_format($totales,2)?></td>
            </tfoot>
        <?php } ?>
    </tbody>
</table>
<?php }?>