<?php 
if($tipo_reporte == 'excel'){
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if($tipo_reporte != 'grid'){
    ?>
    <style type="text/css">
        .tabla{           
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }
        th{
            font-weight: bold !important;                  
        }
        td{   
            font-family: arial;             
        }    
        .fuente_titulo{
            font-family: <?php echo $tipo_fuente; ?>;
        }    
    </style> 
    <?php if ($tipo_reporte == 'excel') {
        ?>
        <table>
            <thead>
                <tr>
                    <th colspan="5">Reporte de retenciones por proveedor
                        <br>
                        <?=$filtro_titulo?>
                    </th>
                </tr>
            </thead>
        </table>
        <?php
    }
    ?>
    <table border="1" width="100%" class="table">
    <?php 
} else {         
    ?>
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
    <?php 
} 
$rep = ($tipo_reporte != 'grid') ? 1 : 0;
?>
    <thead>
        <tr>
            <th <?php echo ($rep > 0) ? 'width="3%"' : ''; ?>>No.</th>
            <th <?php echo ($rep > 0) ? 'width="20%"' : ''; ?>>Nombre</th>
            <th <?php echo ($rep > 0) ? 'width="11%"' : ''; ?>>NIT</th>
            <th>Calidad en que actúa</th>
            <th>Modalidad</th>
            <th>Codigo Documento</th>
            <th>Número Documento</th>
            <th>Monto Sujeto</th>
            <th>Retención</th>
            <th <?php echo ($rep > 0) ? 'width="6%"' : ''; ?>>Período</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $contador = 0;
        if(count($info) > 0){
            foreach ($info as $key) {
                $contador++;
                $calidad = 'Agente de Retención';
                if ($key['rxd_id_ret'] == $tipos_ret['ID_PERCEP']) {
                    $calidad = 'Sujeto de Percepción';
                }
                $percep = ($key['rxd_id_ret'] == $tipos_ret['ID_PERCEP']) ? 1 : 0;
                $retenc = ($key['rxd_id_ret'] == $tipos_ret['ID_RETENC']) ? 1 : 0;
                if ($percep > 0) {
                    $modalidad = 'Percepción';
                } elseif ($retenc > 0) {
                    $modalidad = 'Retención';
                } else {
                    $modalidad = 'Anticipo a Cuenta';
                }
                
                ?>
                <tr>
                    <td <?php echo ($rep > 0) ? 'width="3%"' : ''; ?>><?= $contador ?></td>
                    <td <?php echo ($rep > 0) ? 'width="20%"' : ''; ?>><?php echo $key['proveedor']; ?></td>
                    <td <?php echo ($rep > 0) ? 'width="11%"' : ''; ?> style="white-space: nowrap;"><?php echo $key['nit_prv']; ?></td>
                    <td><?= $calidad ?></td>
                    <td><?php echo $modalidad; ?></td>
                    <td><?php echo $key['code_tif'] . ' - ' . $key['name_tif']; ?></td>
                    <td><?php echo $key['numero']; ?></td>
                    <td style="text-align: right;">$<?= number_format($key['dxd_subtotal'], 2)?></td>
                    <td style="text-align: right;">$<?= number_format($key['monto_ret'], 2)?></td>
                    <td style='mso-number-format:"\@";' <?php echo ($rep > 0) ? 'width="6%"' : ''; ?>><?= $key['periodo'] ?></td>
                </tr>
            <?php } 
        }else{
            if ($tipo_reporte != 'grid') {
                ?>
                <tr>
                    <th colspan="10" style="text-align: center;"><b>No se Encontraron Resultados</b></th>
                </tr>
                <?php
            }
        } ?>
    </tbody>
</table>
