<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if ($tipo_reporte != 'grid') {
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        th {
            font-weight: bold !important;
        }

        td {
            font-family: arial;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <?php if ($tipo_reporte == 'excel') {
    ?>
        <table>
            <thead>
                <tr>
                    <th colspan="5">Reporte de impuesto por proveedor
                        <br>
                        <?= $filtro_titulo ?>
                    </th>
                </tr>
            </thead>
        </table>
    <?php
    }
    ?>
    <table border="1" width="100%" class="table">
        <thead>
            <tr>
                <th colspan="7" align="center"></th>
            </tr>
            <tr>
                <th>No.</th>
                <th>Proveedor</th>
                <th>Fecha</th>
                <th># Documento</th>
                <th>Monto base</th>
                <th>Tipo</th>
                <th>Impuesto</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $contador = 1;
            if (count($info) > 0) {
                foreach ($info as $key) {
            ?>
                    <tr>
                        <td><?= $contador++ ?></td>
                        <td><?= $key['proveedor'] ?></td>
                        <td><?= date_format(date_create($key['fecha']), 'd-m-Y') ?></td>
                        <td><?= $key['numero'] ?></td>
                        <td><?= $simbolo . number_format($key['dxd_subtotal'], $decimales, '.', '') ?></td>
                        <td><?= $key['impues'] ?></td>
                        <td><?= $simbolo . number_format($key['monto_imp'], $decimales, '.', '') ?></td>
                    </tr>
            <?php }
            } ?>
        </tbody>
    </table>
<?php
} else {

?>
    <!--Datos de la grid-->
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th colspan="7"></th>
            </tr>
            <tr>
                <th>No.</th>
                <th>Proveedor</th>
                <th>Fecha</th>
                <th># Documento</th>
                <th>Monto base</th>
                <th>Tipo</th>
                <th>Impuesto</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $contador = 1;
            if (count($info) > 0) {
                foreach ($info as $key) {
            ?>
                    <tr>
                        <td><?= $contador++ ?></td>
                        <td><?= $key['proveedor'] ?></td>
                        <td><?= date_format(date_create($key['fecha']), 'd-m-Y') ?></td>
                        <td><?= $key['numero'] ?></td>
                        <td><?= $simbolo ?><?= number_format($key['dxd_subtotal'], $decimales, '.', '') ?></td>
                        <td><?= $key['impues'] ?></td>
                        <td><?= $simbolo ?><?= number_format($key['monto_imp'], $decimales, '.', '') ?></td>
                    </tr>
            <?php }
            } ?>
        </tbody>
    </table>
<?php } ?>