<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$registros = $this->compras_model->informe_compras_proveedores($where_consulta);
if (count($registros) > 0) {
?>
    <table class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <thead id="cabezera">
            <tr style="font-weight: bold; text-align: center;">
                <th width="4%">#</th>
                <th width="10%">Mes</th>
                <th width="13%">Doc. Identificación</th>
                <th width="15%">Número Ident.</th>
                <th width="10%">Fecha</th>
                <th width="14%">Tipo Doc.</th>
                <th width="10%">Número Doc.</th>
                <th width="10%">Monto</th>
                <th width="9%">IVA</th>
                <th width="5%">A&ntilde;o</th>
            </tr>
        </thead>
        <tbody id="contenedor">
            <?php
            $i = 0;
            $total = 0;
            $area = 0;
            $suma_iva = $suma_total = 0;
            foreach ($registros as $f) {
                $suma_iva += number_format(abs($f['monto_iva']), 2, '.', '');
                $suma_total += number_format(abs($f['subtotal_proveedor']), 2, '.', '');
                $i++;
                $doc = "---";
                $ndoc = "000";
                if (trim($f['documento']) != '') {
                    $d = explode(':#', $f['documento']);
                    $doc = $d[0];
                    $ndoc = $d[1];
                }
            ?>
                <tr nobr="true">
                    <td width="4%"><?php echo $i; ?></td>
                    <td width="10%"><?php echo $meses[intval($f['mes'])]; ?></td>
                    <td width="13%"><?php echo $doc; ?></td>
                    <td width="15%" style="mso-number-format:'@'"><?php echo $ndoc; ?></td>
                    <td width="10%"><?php echo formatear_fecha("d-m-Y", $f['fecha_compra']); ?></td>
                    <td width="14%"><?php echo $f['tif_nombre']; ?></td>
                    <td width="10%" style="mso-number-format:'@'"><?php echo $f['dpv_numero_documento']; ?></td>
                    <td width="10%" align="right"><?php echo $simbolo . number_format(abs($f['subtotal_proveedor']), 2); ?></td>
                    <td width="9%" align="right"><?php echo $simbolo . number_format(abs($f['monto_iva']), 2); ?></td>
                    <td width="5%"><?php echo $f['anio']; ?></td>
                </tr>
            <?php
            }
            ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="7" style="font-weight: bold; text-align: right;">Totales:</th>
                <th width="10%" style="font-weight: bold; text-align: right;"><?php echo $simbolo . number_format($suma_total, 2); ?></th>
                <th width="9%" style="font-weight: bold; text-align: right;"><?php echo $simbolo . number_format($suma_iva, 2); ?></th>
                <th></th>
            </tr>
        </tfoot>
    </table>
<?php
} else {
?>
    <table class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <thead id="cabezera">
            <tr style="font-weight: bold; text-align: center;">
                <th width="4%">#</th>
                <th width="10%">Mes</th>
                <th width="13%">Doc. Identificación</th>
                <th width="15%">Número Ident.</th>
                <th width="10%">Fecha</th>
                <th width="14%">Tipo Doc.</th>
                <th width="10%">Número Doc.</th>
                <th width="10%">Monto</th>
                <th width="9%">IVA</th>
                <th width="5%">A&ntilde;o</th>
            </tr>
        </thead>
        <tbody id="contenedor">
            <?php echo ($es_reporte == 1) ? '<tr><td colspan="10" align="center">No se encontraron registros</td></tr>' : ''; ?>
        </tbody>
    </table>
<?php
}

if ($es_reporte != 1) {
?>
    <script>
        $(document).ready(function() {
            $('#exportar, #imprimir_pdf').show();
            $('#datagried').dataTable({
                "bAutoWidth": false,
                "aLengthMenu": [
                    [10, 25, 50, -1],
                    [10, 25, 50, "Todos"]
                ]
            });
            if ($("#datagried tr").length > 1) {
                $("#contenedorTabla").css({
                    'height': 'auto',
                    'width': 'auto',
                    'padding-bottom': '120px'
                });
                $("html, body").animate({
                    scrollTop: $(document).height() - $(window).height()
                });
            }
        });
    </script>
<?php
}
?>