<?php

/**
 * @author Elman Ortiz
 * @copyright 2019
 */
?>

<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header("content-disposition: attachment;filename=" . $filename . ".xls");
  header("Pragma: no-cache");
  header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
  <meta charset="utf-8" />
  <div class="head">
    <table>
      <tr>
        <td align="center" colspan="5">
          <h4>
            <?php
            echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
            ?> <br />
            Reporte de documentos de proveedor sin <?php echo $tipo_proceso; ?>
          </h4>
        </td>
      </tr>
    </table>
  </div>
<?php } ?>

<?php if ($tipo_reporte == 'pdf') : ?>
  <style type="text/css">
    td {
      font-family: courier;
      font-size: 9px;
    }
  </style>
<?php endif; ?>

<?php if ($tipo_reporte == 'pdf' or $tipo_reporte == 'excel') : ?>
  <table border="0" width="100%">
    <tr>
      <td><?php echo $proveedortext; ?></td>
      <td></td>
      <td></td>
      <td><?php echo $tipodocumentotext; ?></td>
      <td><?php echo $fecha_inicio_text; ?></td>
    </tr>
  </table>
<?php endif; ?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info">
  <thead>
    <tr nobr="true">
      <th width="35%">PROVEEDOR</th>
      <th width="20%">TIPO DOCUMENTO</th>
      <th width="15%">NUMERO DE DOCUMENTO</th>
      <th width="15%">FECHA DOCUMENTO</th>
      <th width="15%">TOTAL DOCUMENTO</th>
    </tr>
  </thead>
  <tbody>
    <?php if (count($reporte) > 0) { ?>
      <?php foreach ($reporte as $key => $rep) { ?>
        <tr nobr="true">
          <td width="35%"><?php echo $rep['nombre_proveedor'] ?></td>
          <td width="20%"><?php echo $rep['tipo_documento'] ?></td>
          <td width="15%"><?php echo $rep['dpv_numero_documento'] ?></td>
          <td width="15%"><?php echo formatear_fecha('d-m-Y', $rep['dpv_fecha_documento']) ?></td>
          <td width="15%"><?php echo $simbolo . number_format($rep['dpv_total'], 2) ?></td>
        </tr>
      <?php } ?>
    <?php } else { ?>
      <?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') { ?>
        <tr nobr="true">
          <td colspan="5" align="center">No se encontraron registros</td>
        </tr>
      <?php } ?>
    <?php } ?>
  </tbody>
</table>