<?php
$p = ($tipo_reporte == 'pdf') ? true : false;
$smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>Reporte de ordenes de compra pendiente</h4><?php echo $periodo ?>
                </td>
            </tr>
        </table>
    </div>
    <br>
<?php
}
if ($tipo_reporte != '') {
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        .tabla td {
            font-size: 8pt;
        }

        .tabla th {
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 8pt;
        }
    </style>
<?php }
?>
<table class="<?= ($p) ? 'tabla' : 'responsive table table-bordered'; ?>" id="tbl_orden_compra" name="tbl_orden_compra" border="<?= ($tipo_reporte != '') ? 1 : 0; ?>" style="font-size:12px;" cellpadding="1">
    <thead>
        <tr>
            <th>No.</th>
            <th>Orc. numero</th>
            <th>Fecha de la orden</th>
            <th>Proveedor</th>
            <th>Producto</th>
            <th>Ctdad Solicitada</th>
            <th>Ctdad Recibida</th>
            <th>Ctdad Pendiente</th>
            <th>Costo unitario</th>
            <th>Subtotal</th>
        </tr>
    </thead>
    <tbody id="tbl_contenedor">

        <?php if (count($ordenes_compra) > 0) { ?>
            <?php foreach ($ordenes_compra as $key => $ord) { ?>
                <tr>
                    <td style="text-align: center;" >
                        <?php echo $ord['dor_id']; ?>
                    </td>
                    <td style="text-align: center;" >
                        <?php echo $ord['orc_numero']; ?>
                    </td>
                    <td style="text-align: center;" >
                       <?php echo formatear_fecha('d-m-Y', $ord['orc_fecha_orden']);?>
                    </td>
                    <td style="text-align: center;" >
                        <?php echo $ord['prv_codigo'].' - '.$ord['prv_nombre']; ?>
                    </td>
                    <td style="text-align: center;" >
                        <?php echo $ord['codigo'].' - '.$ord['nombre']; ?>
                    </td>
                    <td style="text-align: center;" >
                        <?php echo $ord['dor_cantidad']; ?>
                    </td>
                    <td style="text-align: center;" >
                        <?php echo !isset($ord['dor_cantidad_entregada']) ? 0: $ord['dor_cantidad_entregada']; ?>
                    </td>
                    <td style="text-align: center;" >
                        <?php 
                            $cantidad_entregada = !isset($ord['dor_cantidad_entregada']) ? 0: $ord['dor_cantidad_entregada'];
                            $cantidad_pendiente = $ord['dor_cantidad'] - $cantidad_entregada;
                            echo $cantidad_pendiente; ?>
                    </td>
                    <td style="text-align: center;" >
                        <?php echo $ord['dor_precio_unitario']; ?>
                    </td>
                    <td style="text-align: center;" >
                        <?php
                            $subtotal = $cantidad_pendiente * $ord['dor_precio_unitario'];
                            echo $subtotal; 
                        ?>
                    </td>
                </tr>
            <?php } ?>
        <?php } else { ?>
            <tr>
                <td colspan="10">
                    <center>Sin registros</center>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>