<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                       Reporte de proveedores
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
      
    }
    .titulo{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
       
    }
    .tipo {
        mso-number-format: "\@";
    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td{
            vertical-align: middle;
            text-align: center;
        }
        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight:bold;
            font-size:10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
<?php } else { ?>
    <table class="responsive display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
<?php } ?>
    <thead>
        <tr>
            <th width="10%">Código</th>
            <th width="20%">Nombre</th>
            <th width="11%">NIT</th>
            <th width="11%">NRC</th>
            <th width="25%">Dirección</th>
            <th width="15%">Cuenta Bancaria</th>
            <th width="8%">Días de credito</th>
        </tr>
    </thead>
<tbody id="tbl_contenedor_clientes">
<?php
    $tabla = "";
    if (count($proveedores) > 0){
        foreach ($proveedores as $proveedor){
            $nit_prv = "";
            $nrc_prv = "";
            $codigo  = preg_replace("/\xEF\xBB\xBF/", "", $proveedor['prv_codigo']);
            if ( $proveedor['documentos'] != ""){
                $array_docs = explode(",", $proveedor['documentos']);
                if( count($array_docs) > 0) {
                    foreach ( $array_docs as $docs ) {

                        $documento_array = explode("#", $docs);
                        if ($documento_array[0] == $nit){
                            $nit_prv = $documento_array[1];
                        }

                        if ($documento_array[0] == $nrc){
                            $nrc_prv = $documento_array[1];
                        }
                        
                    }
                }
            }
            $tabla .= "<tr>";
                $tabla .= '<td width="10%" class="tipo">';
                    $tabla .= $codigo;              
                $tabla .= "</td>";
                $tabla .= '<td width="20%">';
                    $tabla .= $proveedor['nombre'];                    
                $tabla .= "</td>";             
                $tabla .= '<td width="11%">';  
                    $tabla .= $nit_prv;
                $tabla .= "</td>";                   
                $tabla .= '<td width="11%" class="tipo">';
                    $tabla .= $nrc_prv;
                $tabla .= "</td>";  
                $tabla .= '<td width="25%">';
                    $tabla .= $proveedor['prv_direccion'];
                $tabla .= "</td>";    
                $tabla .= '<td width="15%">';
                    $tabla .= $proveedor['cuentas'];
                $tabla .= "</td>";    
                $tabla .= '<td width="8%">';
                    $tabla .= ($proveedor['prv_dias_plazo'] !="" )? round($proveedor['prv_dias_plazo'],2):"";
                $tabla .= "</td>";    
            $tabla .= "</tr>";
        }
        echo $tabla;
    }
?>
</tbody> 
</table>