<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Precios de Compra
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th>Código</th>
                <th>Nombre del Producto</th>
                <th>Unidad de Medida</th>
                <th>Proveedor</th>
                <th>Cantidad</th>
                <th>Documento</th>
                <th>Fecha</th>
                <th>Precio Unitario.</th>
            </tr>
        </thead>
        <tbody id="tbl_contenedor_clientes">
            <?php
            if (count($detalles) > 0) {
                foreach ($detalles as $det) {
            ?>
                    <tr nobr="true">
                        <td><?php echo htmlentities($det['art_codigo'], ENT_QUOTES, "UTF-8"); ?></td>
                        <td><?= $det['art_nombre'] ?></td>
                        <td><?= $det['mep_nombre'] ?></td>
                        <td><?= $det['prv_nombre'] ?></td>
                        <td><?= $det['dxd_cantidad'] ?></td>
                        <td><?= $det['dpv_numero_documento'] ?></td>
                        <td><?= formatear_fecha('d-m-Y', $det['dpv_fecha_documento']) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($det['dxd_precio_unitario'], 4) ?></td>
                    </tr>
                <?php
                }
            } else {
                ?>
                <tr nobr="true">
                    <td colspan="8"><b>NO SE ENCONTRARON REGISTROS</b></td>
                </tr>
            <?php
            }
            ?>
        </tbody>
        </table>