<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Precios de Compras
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th>Código</th>
                <th>Nombre del Producto</th>
                <th>Unidad de Medida</th>
                <th>Proveedor</th>
                <th>Bodega</th>
                <th>Costo Min.</th>
                <th>Costo Max.</th>
                <!-- <th>Precio Doc. de Prov.</th> -->
                <th>Ult. Costo</th>
            </tr>
        </thead>
        <tbody id="tbl_contenedor_clientes">
            <?php
            if (count($detalles) > 0) {
                foreach ($detalles as $det) {
            ?>
                    <tr nobr="true">
                        <td><?php echo htmlentities($det['art_codigo'], ENT_QUOTES, "UTF-8"); ?></td>
                        <td><?= $det['art_nombre'] ?></td>
                        <td><?= $det['mep_nombre'] ?></td>
                        <td><?= $det['proveedor'] ?></td>
                        <td><?= $det['bod_nombre'] ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($det['precio_minino'], 4) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($det['precio_maximo'], 4) ?></td>
                        <!-- <td><?php echo ($det['dxd_precio_unitario'] != '') ? $simbolo . number_format($det['dxd_precio_unitario'], 4) : '<b>---</b>'; ?></td> -->
                        <td style="text-align: right;"><?= $simbolo . number_format($det['dee_precio'], 4) ?></td>
                    </tr>
            <?php
                }
            }
            ?>
        </tbody>
        </table>
        <?php if ($tipo_reporte == '') { ?>
            <script type="text/javascript">
                $(document).ready(function() {
                    $("#tbl_facturas").dataTable();
                });
            </script>
        <?php
        } ?>