<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { //Encabezado del Archivo Excel
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="8">
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
                        <br>Reporte de Análisis de cotización de compra
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if (/*$tipo_reporte == 'pdf' OR */$tipo_reporte == 'excel') : //Mostrar los filtros seleccionados
?>
    <table border="0" width="100%">
        <tr>
            <td><?php echo $fecha_inicio_t; ?></td>
            <td><?php echo $fecha_fin_t; ?></td>
            <td><?php echo $requix_t; ?></td>
        </tr>
    </table>
<?php endif; ?>

<?php
$i = 0;
$det_cot    = array();
$det_pro    = array();
$cotizacion = array();
$producto   = array();
$fecha      = date("d / m / Y", strtotime($info[0]['rxi_fecha']));
$conta      = $info[0]['cant_prod'];

if (count($info) > 0) {
    foreach ($info as $key => $value) {

        if ($value['dco_descuento'] != "") {
            $porcentaje   = ($value['dco_descuento'] * $value['dco_precio_unitario']) / 100;
            $p_u    = $value['dco_precio_unitario'] - $porcentaje;
        } else {
            $p_u    = $value['dco_precio_unitario'];
        }

        $num = $value['dco_id_art'] . '-' . $value['coc_numero'];
        $total = $p_u * $value['dco_cantidad'];

        if (!(in_array($value['coc_numero'], $cotizacion))) {
            $cotizacion[$value['coc_numero']] = [
                "num_cot"   => $value['coc_numero'],
                "proveedor" => $value['prv_nombre'],
                "fecha"     => $value['coc_fecha']
            ];
        }

        if (!(in_array($value['dco_id_art'], $det_pro))) {
            $det_pro[$value['dco_id_art']] = [
                "nombre"    => $value['art_nombre'],
                "cantidad"  => $value['dco_cantidad'],
                "unidad"    => $value['mep_nombre']
            ];
        }

        $producto[$num] = [
            "nombre"    => $value['art_nombre'],
            "cantidad"  => $value['dco_cantidad'],
            "unidad"    => $value['mep_nombre'],
            "precio"    => $p_u,
            "total"     => $total
        ];
    }
}
?>

<style type="text/css">
    .tabla th {
        border: 1px solid black;
        vertical-align: middle;
        text-align: center;
        font: bold;
        background-color: #DCDCDC;
    }

    .money {
        text-align: right;
    }
</style>

<?php if ($tipo_reporte != '') { //Agregar borde si se exporta
?>
    <table class="responsive display tabla table-bordered dataTable" id="tbl_cot" name="tbl_cot" border="1" style="width: 99%; text-align: center; font-size:10px;">
    <?php } else { ?>
        <table class="responsive display tabla table-bordered dataTable" id="tbl_cot" name="tbl_cot" border="0" style="width: 99%; text-align: center; font-size:12px;">
        <?php } ?>
        <thead>
            <?php if (count($info) > 0) { //Existe al menos un registro 
            ?>
                <tr>
                    <th>Requisición: #<?php echo $info[0]['rxi_numero']; ?></th>
                    <th colspan="2">Realizada en fecha: <?= $fecha ?></th>
                    <?php foreach ($cotizacion as $key => $value) { ?>
                        <th colspan="2">Proveedor: <?php echo $value['proveedor']; ?></th>
                    <?php } ?>
                </tr>
                <tr>
                    <th rowspan="2">Producto</th>
                    <th rowspan="2">Unidad de Medida</th>
                    <th rowspan="2">Cantidad</th>
                    <?php
                    foreach ($cotizacion as $key => $value) {
                        $det_cot[$i] = $value['num_cot']
                    ?>
                        <th>Cotizacion #<?php echo $value['num_cot']; ?></th>
                        <th>Fecha: <?php echo date("d-m-Y", strtotime($value['fecha'])); ?></th>
                    <?php
                        $i++;
                    } ?>
                </tr>
                <tr>
                    <?php
                    $cant_cot = count($cotizacion);
                    for ($i = 0; $i < $cant_cot; $i++) { ?>
                        <th>Precio Unitario</th>
                        <th>Total</th>
                    <?php } ?>
                </tr>
            <?php   } else { //Si no hay registros 
            ?>
                <tr>
                    <th>Producto</th>
                    <th>Unidad de Medida</th>
                    <th>Cantidad</th>
                </tr>
            <?php } ?>
        </thead>
        <tbody>
            <?php
            if (count($info) > 0) { //Existe al menos un registro
                foreach ($det_pro as $key => $value) { ?>
                    <tr>
                        <td style="text-align: left;"><?php echo $value['nombre']; ?></td>
                        <td><?php echo $value['unidad']; ?></td>
                        <td><?php echo number_format($value['cantidad'], 2, '.', ','); ?></td>
                        <?php
                        foreach ($det_cot as $cot) {
                            $det = $key . '-' . $cot;
                        ?>
                            <td class="money"><?= $simbolo ?><?php echo number_format($producto[$det]['precio'], 2, '.', ','); ?></td>
                            <td class="money"><?= $simbolo ?><?php echo number_format($producto[$det]['total'], 2, '.', ','); ?></td>
                        <?php } ?>
                    </tr>
                <?php } ?>
            <?php } else { //No existen registros
            ?>
                <tr>
                    <td colspan="3" style="text-align: center; font-weight: bold;">No se ha encontrado ninguna cotización asociada a esta requisición</td>
                </tr>
            <?php } ?>
        </tbody>
        </table>