<link href="<?= base_url() ?>stylesheets/lJson/json_style.css" rel="stylesheet">

<!-- === Estilos mínimos necesarios para la vista === -->
<style>
  /* Barra de herramientas (marcar todos | crear seleccionados) */
  .bulk-tools{margin-bottom:10px;display:flex;gap:12px;align-items:center}

  /* Tabla compacta y alineación vertical centrada */
  .table-sm th,.table-sm td{vertical-align:middle}

  /* Anchos de columnas */
  .col-num{width:52px;text-align:center}
  .col-cod{width:130px}
  .col-desc{min-width:260px}
  .col-um{width:120px;text-align:center}
  .col-pre{width:120px;text-align:right}
  .col-sel{width:80px;text-align:center}
  .col-match{min-width:360px} /* espacio para select + botón */

  /* Badge para auto-match */
  .badge-match{display:inline-block;padding:3px 8px;border-radius:12px;background:#e9f5ff;color:#0b60a9;font-weight:600}

  /* Botón compacto y utilidades */
  .btnc{padding:4px 10px;border-radius:8px}
  .muted{color:#888}
  tr.bg-success td{background:#f0fff4}
  tr.bg-danger  td{background:#fff5f5}

  /* Contenedor de acciones (select + botón) en una sola línea */
  .match-actions{display:flex;align-items:center;gap:8px;flex-wrap:nowrap}

  /* Select nativo: ancho fijo para que no crezca */
  .match-actions .sel-candidato{
    width:220px;min-width:220px;max-width:220px;flex:0 0 220px;
  }
  /* Select2: forzar el mismo ancho fijo */
  .match-actions .select2-container{
    width:220px !important;min-width:220px !important;max-width:220px !important;flex:0 0 220px;
  }
  /* Alto de select2 alineado a la fila */
  .match-actions .select2-selection--single{height:28px}
  .match-actions .select2-selection__rendered{line-height:28px}
  .match-actions .select2-selection__arrow{height:28px}

  /* Botón "Crear nuevo": que no se achique ni rompa el texto */
  .match-actions .btn-crear-producto{flex:0 0 auto;white-space:nowrap;min-width:110px}

  /* Solo "Crear nuevo" centrado cuando no hay candidatos */
  .single-create{display:flex;justify-content:center}

  /* Responsive compacto */
  @media (max-width:768px){
    .col-match{min-width:320px}
    .match-actions .sel-candidato,
    .match-actions .select2-container{
      width:200px !important;min-width:200px !important;max-width:200px !important;flex:0 0 200px;
    }
    .match-actions .btn-crear-producto{min-width:100px}
  }
</style>

<div class="zipbox-root">
  <!-- Herramientas en lote -->
  <div class="bulk-tools">
    <label class="m-0">
      <input type="checkbox" id="chk-create-all"> Marcar todos
    </label>
    <button type="button" class="btnc btn-xs btn-outline-secondary" id="btn-crear-seleccionados">
      Crear seleccionados
    </button>
  </div>

  <!-- Tabla de revisión -->
  <table class="table table-sm">
    <thead>
      <tr>
        <th class="col-num">#</th>
        <th class="col-cod">Código</th>
        <th class="col-desc">Descripción</th>
        <th class="col-um">U.Med</th>
        <th class="col-pre">Precio</th>
        <th class="col-sel">Marcar</th>
        <th class="col-match">Encontrados</th>
      </tr>
    </thead>
    <tbody>
    <?php foreach ($cuerpo as $row): ?>
      <?php
        // Flags desde el backend
        $hasAuto   = !empty($row['_auto_match']);
        $hasCands  = !empty($row['_candidates']);

        // Datos base del item
        $numItem   = (int)$row['numItem'];
        $codigo    = isset($row['codigo']) ? $row['codigo'] : '';
        $desc      = $row['descripcion'];
        $um        = getUnitMedidaByName((int)$row['uniMedida']);
        $umID      = $row['uniMedida'];
        $tipo      = $row['tipoItem'];
        $precio    = number_format($row['precioUni'], 4, '.', '');
      ?>
      <tr data-num="<?= $numItem ?>">
        <td class="col-num"><?= $numItem ?></td>
        <td class="col-cod"><?= htmlspecialchars($codigo) ?></td>
        <td class="col-desc"><?= htmlspecialchars($desc) ?></td>
        <td class="col-um"><?= $um ?></td>
        <td class="col-pre"><?= $precio ?></td>

        <!-- Checkbox solo si NO hubo auto-match único -->
        <td class="col-sel">
          <?php if (!$hasAuto): ?>
            <input type="checkbox" class="chk-to-create">
          <?php else: ?>
            <span class="muted">—</span>
          <?php endif; ?>
        </td>

        <!-- Columna de coincidencias -->
        <td class="col-match">
          <?php if ($hasAuto && !$hasCands): ?>
            <!-- A) Único match perfecto: mostrar badge -->
            <span class="badge-match" data-art-id="<?= (int)$row['_auto_match']['art_id'] ?>">
              <?= htmlspecialchars($row['_auto_match']['art_nombre']) ?>
              <?php if (!empty($row['_auto_match']['art_codigo'])): ?>
                [<?= htmlspecialchars($row['_auto_match']['art_codigo']) ?>]
              <?php endif; ?>
            </span>

          <?php elseif ($hasCands): ?>
            <!-- B) Hay candidatos: select (fixed 220px) + botón Crear nuevo -->
            <div class="match-actions">
              <select class="form-control input-sm sel-candidato" placeholder="Selecciona del listado">
                <option></option>
                <?php foreach ($row['_candidates'] as $c): ?>
                  <option value="<?= (int)$c['art_id'] ?>">
                    <?= htmlspecialchars($c['art_nombre']) ?>
                    <?= $c['art_codigo'] ? ' ['.htmlspecialchars($c['art_codigo']).']' : '' ?>
                    (<?= $c['score'] ?>)
                  </option>
                <?php endforeach; ?>
              </select>

              <button class="btnc btn-xs btn-outline-primary btn-crear-producto"
                      data-tipo-name="<?= htmlspecialchars($tipo) ?>"
                      data-def-name="<?= htmlspecialchars($desc) ?>"
                      data-def-code="<?= htmlspecialchars($codigo) ?>"
                      data-def-medida="<?= $umID ?>"
                      data-def-precio="<?= $precio ?>"
                      data-prov-id="<?= (int)$prov_id ?>">
                Crear nuevo
              </button>
            </div>

          <?php else: ?>
            <!-- C) Sin candidatos ni auto-match: solo botón Crear nuevo -->
            <div class="single-create">
              <button class="btnc btn-xs btn-outline-primary btn-crear-producto"
                      data-tipo-name="<?= htmlspecialchars($tipo) ?>"
                      data-def-name="<?= htmlspecialchars($desc) ?>"
                      data-def-code="<?= htmlspecialchars($codigo) ?>"
                      data-def-medida="<?= $umID ?>"
                      data-def-precio="<?= $precio ?>"
                      data-prov-id="<?= (int)$prov_id ?>">
                Crear nuevo
              </button>
            </div>
          <?php endif; ?>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>
