<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
        }
        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }
        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }
        .tabla{
            border:1px solid black;
        }
        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
    <?php 
}

if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Documentos de Proveedor
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php 
}

if ($tipo_reporte != '') {
    ?>
    <table class="tabla">
        <thead>
            <tr>
                <th>No. Doc.</th>
                <th>Tipo Doc.</th>
                <th>Monto Doc.</th>
                <th>Fecha Doc.</th>
                <th>Proveedor</th>
                <th>Orden de Compra</th>
                <th>Caja Chica</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            <?php
}

if (count($documentos) > 0) {
    foreach ($documentos as $key => $doc) {
        /** llamado a la funcion validar_nota_abono que evalua si hay una nota de abono actualmente y si esta esta activa y no sobrepasa la cantidad pendiente de pago en dpv **/
        // $opc = $this->compras_model->validar_nota_abono_dxp($dpv['dpv_id']);
        // NO SE UTILIZA
        $user = $this->gsatelite->get_tabla('users', array('id' => $doc['dpv_usu_creacion']));
        ?>
        <tr nobr="true">
            <td><?= $doc['dpv_numero_documento'] ?></td>
            <td><?= $doc['tif_nombre'] ?></td>
            <td><?= $doc['dpv_total'] ?></td>
            <td><?= formatear_fecha('d-m-Y', $doc['dpv_fecha_documento']) ?></td>
            <td><?= $doc['proveedor'] ?></td>
            <td><?= $doc['orc_numero'] ?></td>
            <td><?= $doc['caja_chica'] ?></td>
            <td><?= $doc['estadox'] ?></td>
        </tr>
        <?php
    }
} else {
    if ($tipo_reporte != '') { ?>
        <tr>
            <td colspan="8" style="text-align: center;font-weight: bold;">No se encontraron resultados</td>
        </tr>
        <?php
    }
}


if ($tipo_reporte != '') {
    ?>
        </tbody>
    </table>
    <?php
}
?>
