<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }
    </style>
    <?php
}

$proveedor = $documento['prv_codigo'] . ' - ';
$proveedor .= ($documento['prv_tipo_pers'] == 1) ? $documento['prv_nombre'] . ' ' . $documento['prv_apellido'] : $documento['prv_apellido'];
?>
<table class="">
    <tr><td colspan="9"></td></tr>
    <tr>
        <td style="width: 15%; text-align: left;"><b>Proveedor:</b></td>
        <td style="text-align: left;" colspan="3"><?php echo $proveedor; ?></td>
        <td style="width: 15%; text-align: left;"><b>No. Doc.:</b></td>
        <td style="text-align: left; text-align: left;"><?php echo $documento['dpv_numero_documento']; ?></td>
    </tr>
    <tr>
        <td style="width: 15%; text-align: left;"><b>Fecha Fact.:</b></td>
        <td style="text-align: left;" colspan="3"><?php echo formatear_fecha('d-m-Y', $documento['dpv_fecha_documento']); ?></td>
        <td style="width: 15%; text-align: left;"><b>Fecha Ret.:</b></td>
        <td style="text-align: left;"><?php echo formatear_fecha('d-m-Y H:i:s a', $retaceo['rtd_fecha_registro']); ?></td>
    </tr>
    <tr>
        <td style="width: 15%; text-align: left;"><b>Póliza:</b></td>
        <td style="text-align: left;" colspan="3"><?php echo $retaceo['rtd_poliza']; ?></td>
        <td style="width: 15%; text-align: left;"><b>Aduana:</b></td>
        <td style="text-align: left;"><?php echo $retaceo['rtd_aduana']; ?></td>
    </tr>
</table>
<div></div>
<table class="tabla">
    <thead>
        <tr>
            <th colspan="9" style="font-weight: bold;">Gastos</th>
        </tr>
        <tr>
            <th colspan="2" style="font-weight:bold;">Gastos</th>
            <th colspan="2" style="font-weight:bold;">Proveedores</th>
            <th colspan="3" style="font-weight:bold;">Documentos</th>
            <th colspan="2" style="font-weight:bold;">Monto</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $total_gastos = 0;
        if (count($detalle_gastos) > 0):
            foreach ($detalle_gastos as $grc):
                $proveedor_gasto = "";
                if ($grc['prv_codigo'] != null) {
                    $proveedor_gasto = $grc['prv_codigo'] . ' - ';
                    $proveedor_gasto .= ($grc['prv_tipo_pers'] == 1) ? $grc['prv_nombre'] . ' ' . $grc['prv_apellido'] : $grc['prv_apellido'];
                }
                $total_gastos += $grc['grc_monto'];
                ?>
                <tr>
                    <td colspan="2"><?php echo $grc['gst_nombre']; ?></td>
                    <td colspan="2"><?php echo $proveedor_gasto; ?></td>
                    <td colspan="3"><?php echo $grc['dpv_numero_documento']; ?></td>
                    <td colspan="2">$<?php echo number_format($grc['grc_monto'], 2); ?></td>
                </tr>
            <?php endforeach; ?>
            <tr>
                <td colspan="7" style="text-align: right;font-weight: bold;">Total:</td>
                <td colspan="2">$<?php echo number_format($total_gastos, 2); ?></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<br/><br/>
<table class="tabla">
    <thead>
        <tr>
            <th colspan="9" style="font-weight: bold;">Productos</th>
        </tr>
        <tr>
            <th style="width:10%; font-weight:bold;">Código</th>
            <th style="width:18%; font-weight:bold;">Producto/Servicio</th>
            <th style="width:8%; font-weight:bold;">UM</th>
            <th style="width:12%; font-weight:bold;">Cantidad</th>
            <th style="width:12%; font-weight:bold;">Precio Unitario</th>
            <th style="width:10%; font-weight:bold;">Sub-Total</th>
            <th style="width:10%; font-weight:bold;">Retaceo (%)</th>
            <th style="width:10%; font-weight:bold;">Precio Fin. ($)</th>
            <th style="width:10%; font-weight:bold;">Retaceo ($)</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $total_retaceo = 0;
        $total_porcentaje = 0;
        $total_subtotal = 0;
        $total_precio_final = 0;
        foreach ($detalle_retaceo as $row):
            $total_subtotal += $row['drc_subtotal'];
            $total_porcentaje += $row['drc_retaceo_porcentaje'];
            $total_retaceo += $row['drc_retaceo'];
            $total_precio_final += $row['drc_precio_final'];
            ?>
            <tr>
                <td style="width:10%"><?php echo $row['art_codigo']; ?></td>
                <td style="width:18%"><?php echo htmlentities($row['art_nombre']); ?></td>
                <td style="width:8%"><?php echo $row['mep_nombre']; ?></td>
                <td style="width:12%"><?php
                    echo number_format(round($row['drc_cantidad'], 2), 0, '', ',');
                    ?></td>  
                <td style="width:12%"><?php
                    echo number_format(round($row['drc_precio_unitario'], 2), 2, '.', ',');
                    ?></td>
                <td style="width:10%">$<?php echo number_format(round($row['drc_subtotal'], 2), 2, '.', ','); ?></td>
                <td style="width:10%"><?php echo number_format(round($row['drc_retaceo_porcentaje'], 2), 2, '.', ','); ?>%</td>
                <td style="width:10%"><?php
                    echo number_format(round($row['drc_precio_final'], 2), 2, '.', ',');
                    ?></td>
                <td style="width:10%">$<?php echo number_format(round($row['drc_retaceo'], 2), 2, '.', ','); ?></td>
            </tr>
            <?php
        endforeach;
        ?>
        <tr>
            <td style="text-align: right;font-weight: bold;" colspan="5">Total:</td>
            <td style="font-weight: bold;">$<?php echo number_format($total_subtotal, 2); ?></td>
            <td style="font-weight: bold;"><?php echo number_format($total_porcentaje, 2); ?>%</td>
            <td style="font-weight: bold;">$<?php echo number_format($total_precio_final, 2); ?></td>
            <td style="font-weight: bold;">$<?php echo number_format($total_retaceo, 2); ?></td>
        </tr>
    </tbody>
</table>