<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }
    </style>
    <?php
}
?>
<table class="" border="0" style="">
    <tr><td colspan="4"></td></tr>
    <tr>        
        <td><b>Fecha Ret.:</b></td>
        <td><?php echo formatear_fecha('d-m-Y H:i:s a', $retaceo[0]['rtd_fecha_registro']); ?></td>
        <td><b>Observaciones:</b></td>
        <td><?php echo $retaceo[0]['rtd_observacion']; ?></td>
    </tr>
    <tr>
        <td><b>Póliza:</b></td>
        <td><?php echo $retaceo[0]['rtd_poliza']; ?></td>
        <td><b>Aduana:</b></td>
        <td><?php echo $retaceo[0]['rtd_aduana']; ?></td>
    </tr>
</table>
<div></div>
<table class="tabla">
    <thead>
        <tr>
            <th colspan="4" style="font-weight: bold;">Gastos</th>
        </tr>
        <tr>
            <th width="25%" style="font-weight:bold;">Gastos</th>
            <th width="35%" style="font-weight:bold;">Proveedores</th>
            <th width="20%" style="font-weight:bold;">Documentos</th>
            <th width="20%" style="font-weight:bold;">Monto</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $total_gastos = 0;
        if (count($detalle_gastos) > 0):
            foreach ($detalle_gastos as $grc):
                $proveedor_gasto = "";
                if ($grc['prv_codigo'] != null) {
                    $proveedor_gasto = $grc['prv_codigo'] . ' - ';
                    $proveedor_gasto .= ($grc['prv_tipo_pers'] == 1) ? $grc['prv_nombre'] . ' ' . $grc['prv_apellido'] : $grc['prv_apellido'];
                }
                $total_gastos += $grc['grc_monto'];
                ?>
                <tr>
                    <td width="25%" style="text-align: left;"><?php echo $grc['gst_nombre']; ?></td>
                    <td width="35%" style="text-align: left;"><?php echo $proveedor_gasto; ?></td>
                    <td width="20%"><?php echo $grc['dpv_numero_documento']; ?></td>
                    <td width="20%" style="text-align: right;">$<?php echo number_format($grc['grc_monto'], 2); ?></td>
                </tr>
            <?php endforeach; ?>
            <tr>
                <td style="text-align: right;font-weight: bold;" colspan="3">Total:</td>
                <td style="text-align: right;">$<?php echo number_format($total_gastos, 2); ?></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
<br/><br/>
<?php
$cant_dpvs = count($documento); 
$total_retaceo = 0;
$total_porcentaje = 0;
$total_subtotal = 0;
$total_precio_final = 0;
for ($i=0; $i < $cant_dpvs; $i++) {
    $idDpv = $documento[$i]['dpv_id'];
    $proveedor = $documento[$i]['prv_codigo'] . ' - ';
    $proveedor .= ($documento[$i]['prv_tipo_pers'] == 1) ? $documento[$i]['prv_nombre'] . ' ' . $documento[$i]['prv_apellido'] : $documento[$i]['prv_apellido'];
    ?>
    <table class="tabla">
        <thead>
            <tr nobr="true">
                <td width="12%"><b>Proveedor:</b></td>
                <td width="38%" colspan="2"><?php echo $proveedor; ?></td>
                <td width="12%"><b>No. Doc.:</b></td>
                <td width="13%" colspan="2"><?php echo $documento[$i]['dpv_numero_documento']; ?></td>
                <td width="12%"><b>Fecha Fact.:</b></td>
                <td width="13%" colspan="2"><?php echo formatear_fecha('d-m-Y', $documento[$i]['dpv_fecha_documento']); ?></td>
            </tr>
            <tr nobr="true">
                <th colspan="9" style="font-weight: bold;">Productos</th>
            </tr>
            <tr nobr="true">
                <th style="width:10%; font-weight:bold;">Código</th>
                <th style="width:18%; font-weight:bold;">Producto/Servicio</th>
                <th style="width:8%; font-weight:bold;">UM</th>
                <th style="width:12%; font-weight:bold;">Cantidad</th>
                <th style="width:12%; font-weight:bold;">Precio Unitario</th>
                <th style="width:10%; font-weight:bold;">Sub-Total</th>
                <th style="width:10%; font-weight:bold;">Retaceo (%)</th>
                <th style="width:10%; font-weight:bold;">Costo Unit. ($)</th>
                <th style="width:10%; font-weight:bold;">Costo Total ($)</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sb_total_retaceo = 0;
            $sb_total_porcentaje = 0;
            $sb_total_precio_final = 0;
            $sb_total_subtotal = 0;
            foreach ($detalle_retaceo as $kr => $row) {
                if ($row['dpv_id'] == $idDpv) {
                    $sb_total_subtotal += number_format($row['drc_subtotal'], 2, '.','');
                    $sb_total_porcentaje += number_format($row['drc_retaceo_porcentaje'], 4, '.','');
                    $sb_total_precio_final += number_format($row['drc_precio_final'], 4, '.', '');
                    $sb_total_retaceo += number_format($row['drc_retaceo'], 2, '.','');
                    ?>
                    <tr nobr="true">
                        <td style="width:10%"><?php echo $row['art_codigo']; ?></td>
                        <td style="width:18%"><?php echo htmlentities($row['art_nombre']); ?></td>
                        <td style="width:8%"><?php echo $row['mep_nombre']; ?></td>
                        <td style="width:12%;text-align:right;"><?php echo number_format($row['drc_cantidad']); ?></td>  
                        <td style="width:12%;text-align:right;"><?php echo number_format($row['drc_precio_unitario'], 4); ?></td>
                        <td style="width:10%;text-align:right;">$<?php echo number_format($row['drc_subtotal'], 2); ?></td>
                        <td style="width:10%;text-align:right;"><?php echo number_format($row['drc_retaceo_porcentaje'], 2); ?>%</td>
                        <td style="width:10%;text-align:right;"><?php echo number_format($row['drc_precio_final'], 4); ?></td>
                        <td style="width:10%;text-align:right;">$<?php echo number_format($row['drc_retaceo'], 2); ?></td>
                    </tr>
                    <?php 
                }                
            }
            $total_subtotal += number_format($sb_total_subtotal, 2, '.', '');
            $total_retaceo += number_format($sb_total_retaceo, 2, '.', '');
            $total_porcentaje += number_format($sb_total_porcentaje, 4, '.', '');
            $total_precio_final += number_format($sb_total_precio_final, 2, '.', '');
            ?>
        </tbody>
        <tfoot>
            <tr nobr="true">
                <td colspan="5" style="text-align: right;">Total del Documento</td>
                <td style="text-align: right;">$<?php echo number_format($sb_total_subtotal, 2) ?></td>
                <td style="text-align: right;"><?php echo number_format($sb_total_porcentaje, 2) ?>%</td>
                <td style="text-align: right;">$<?php echo number_format($sb_total_precio_final, 2) ?></td>
                <td style="text-align: right;">$<?php echo number_format($sb_total_retaceo, 2) ?></td>
            </tr>
        </tfoot>
    </table>
    <?php
    if (($i + 1) < $cant_dpvs) {
        if ($tipo_reporte == 'pdf') {
            echo '<div class="clear"><br/></div>';
        } else {
            echo '<br/>';
        }
    }    
} ?>
<table class="tabla">
    <tr nobr="true">
        <td width="60%" style="text-align: right;font-weight: bold;" colspan="5">Total General:</td>
        <td width="10%" style="font-weight: bold;">$<?php echo number_format($total_subtotal, 2); ?></td>
        <td width="10%" style="font-weight: bold;"><?php echo number_format($total_porcentaje, 2); ?>%</td>
        <td width="10%" style="font-weight: bold;">$<?php echo number_format($total_precio_final, 2); ?></td>
        <td width="10%" style="font-weight: bold;">$<?php echo number_format($total_retaceo, 2); ?></td>
    </tr>
</table>