<?php
switch ($doc_prov['dpv_tipo']) {
    case 1:
        $dpv_tipo = "Productos y Servicios";//"Productos";
        break;
    case 2:
        $dpv_tipo = "Servicios";
        break;
    case 3:
        $dpv_tipo = "Activo Fijo";
        break;    
    default:
        $dpv_tipo = "Productos y Servicios";
        break;
}
echo $encabezado;
?>
<table width="100%" border="0" cellpadding="2">
    <tr>
        <th colspan="5" style="text-align: center;border-bottom: black 1px solid;"><b>Datos Generales</b></th>
    </tr>
    <tr>
        <td width="14%"><b>Tipo Documento:</b></td>
        <td width="35%"><?= $doc_prov['tipo_doc'] ?></td>
        <td width="2%"></td>
        <td width="14%"><b>Tipo:</b></td>
        <td width="35%"><?= $dpv_tipo ?></td>
    </tr>
    <tr>
        <td><b>Número. Doc.:</b></td>
        <td><?= $doc_prov['dpv_numero_documento'] ?></td>
        <td></td>
        <td><b>Serie Doc.:</b></td>
        <td><?= $doc_prov['dpv_serie_documento'] ?></td>
    </tr>
    <tr>
        <td><b>Proveedor:</b></td>
        <td><?= $doc_prov['proveedor'] ?></td>
        <td></td>
        <td><b>Tipo de Pago:</b></td>
        <td><?= $doc_prov['tipo_pago_nombre'] ?></td>
    </tr>
    <tr>
        <td><b>Fecha Doc.:</b></td>
        <td><?= formatear_fecha('d-m-Y', $doc_prov['dpv_fecha_documento']) ?></td>
        <td></td>
        <td><b>Fecha Vencimiento:</b></td>
        <td><?= formatear_fecha('d-m-Y', $doc_prov['dpv_fecha_vencimiento']) ?></td>
    </tr>
    <tr>
        <td><b>Afecta Inventario:</b></td>
        <td><?= ($doc_prov['dpv_afecta_inventario'] > 0) ? "Sí" : "No"; ?></td>
        <td></td>
        <td><b><?= ($doc_prov['dpv_id_orc'] != "") ? "Orden de Compra:" : ""; ?></b></td>
        <td><?= $doc_prov['orden_compra'] ?></td>
    </tr>
    <tr>
        <td><b>Condición de pago:</b></td>
        <td><?= $doc_prov['condicion_pago'] ?></td>
        <td></td>
        <td><b>Centro de Costos:</b></td>
        <td><?= $doc_prov['centro_compra'] ?></td>
    </tr>
    <?php if ($doc_prov['dpv_id_cch'] != "" || $doc_prov['dpv_id_tmt'] != "") { ?>
        <tr>
            <td><b><?= ($doc_prov['dpv_id_cch'] != "") ? "Caja Chica:" : ""; ?></b></td>
            <td><?= $doc_prov['caja_chica'] ?></td>
            <td></td>
            <td><b><?= ($doc_prov['dpv_id_tmt'] != "") ? "Tipo de monto:" : ""; ?></b></td>
            <td><?= $doc_prov['tipo_monto'] ?></td>
        </tr>
    <?php } ?>
    <tr>
        <td><b>Concepto:</b></td>
        <td><?= $doc_prov['dpv_concepto'] ?></td>
        <td></td>
        <td><b>Descripción Doc.:</b></td>
        <td><?= $doc_prov['dpv_descripcion'] ?></td>
    </tr>
    <tr>
        <td><b>Observaciones:</b></td>
        <td><?= $doc_prov['dpv_observacion'] ?></td>
        <td></td>
        <td><b><?= ($doc_prov['dpv_id_dpv_afecta'] != "") ? "Afecta a Documento:" : ""; ?></b></td>
        <td><?= $doc_prov['doc_afecta'] ?></td>
    </tr>
</table>
<table border="1" width="100%">
    <thead>
        <tr>
            <th colspan="9" style="text-align: center;border-bottom: black 1px solid;"><b>Detalle de Productos / Servicios</b></th>
        </tr>
        <tr>
            <th width="19%"><b>Producto</b></th>
            <th width="11%"><b>U. Medida</b></th>
            <th width="10%"><b>Cantidad</b></th>
            <th width="10%"><b>Precio U.</b></th>
            <th width="10%"><b>Retenciones</b></th>
            <th width="10%"><b>Descuento</b></th>
            <th width="10%"><b>Subtotal</b></th>
            <th width="10%"><b>Impuestos</b></th>
            <th width="10%"><b>Total</b></th>
        </tr>
    </thead>
    <tbody style="/*font-size: 11px !important;font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;*/"> 
        <?php
        $total_cantidad = $total_retencion = $total_descuento = $total_impuestos = $total_subtotal = $gran_total = 0;
        foreach ($detalles as $key => $value) {            
            $total_cantidad  += $value['dxd_cantidad'];
            $total_retencion += $value['dxd_retencion'];
            $total_descuento += $value['dxd_descuento'];
            $total_subtotal  += $value['dxd_subtotal'];
            $total_impuestos += $value['dxd_impuesto'];
            $gran_total      += $value['dxd_total'];
            ?>
            <tr id="tr_<?php echo $i; ?>" data-id="<?php echo $i; ?>" class="detalle_doc_proveedor">
                <td width="19%"><?php echo $value['art_codigo'].'-'.$value['art_nombre']; ?></td>
                <td width="11%"><?php echo $value['medida']; ?></td>                
                <td width="10%" style="text-align: right;"><?php echo number_format($value['dxd_cantidad'], $decimales); ?></td>
                <td width="10%" style="text-align: right;">$<?php echo number_format($value['dxd_precio_unitario'], $decimales); ?></td>
                <td width="10%" style="text-align: right;">$<?php echo number_format($value['dxd_retencion'], $decimales); ?></td>
                <td width="10%" style="text-align: right;">$<?php echo number_format($value['dxd_descuento'], $decimales); ?></td>
                <td width="10%" style="text-align: right;">$<?php echo number_format($value['dxd_subtotal'], $decimales); ?></td>
                <td width="10%" style="text-align: right;">$<?php echo number_format($value['dxd_impuesto'], $decimales); ?></td>
                <td width="10%" style="text-align: right;">$<?php echo number_format($value['dxd_total'], $decimales); ?></td>
            </tr>
            <?php            
        }
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td style="text-align: right;" colspan="2"><b>Total</b></td>
            <td style="text-align: right;"><b><?php echo number_format($total_cantidad, $decimales); ?></b></td>
            <td></td>
            <td style="text-align: right;"><b>$<?php echo number_format($total_retencion, $decimales); ?></b></td>
            <td style="text-align: right;"><b>$<?php echo number_format($total_descuento, $decimales); ?></b></td>
            <td style="text-align: right;"><b>$<?php echo number_format($total_subtotal, $decimales); ?></b></td>
            <td style="text-align: right;"><b>$<?php echo number_format($total_impuestos, $decimales); ?></b></td>
            <td style="text-align: right;"><b>$<?php echo number_format($gran_total, $decimales); ?></b></td>
        </tr>
    </tfoot>
</table>
