<?php if (isset($cerrar_modal)): ?>
    <script type="text/javascript">
        $(document).ready(function () {

            parent.crear_alerta('<?php echo $alerta['tipo_alerta']; ?>', '<?php echo $alerta['titulo_alerta']; ?>', '<?php echo $alerta['texto_alerta']; ?>');
            $("#btnConsultar", parent.document.body).trigger('click');
            var button = $("#btnConsultar", parent.document.body).text();
            if (button == "") {
                setTimeout(function () {
                    window.parent.location.reload();
                    parent.jQuery.fancybox.close();
                }, 1000);

            } else {
                parent.jQuery.fancybox.close();
            }
        });
    </script>
<?php endif; ?>
<form id="frm-req" method="post" name="frm-req" action="<?php echo base_url('modulo_compras/procesos/anular_requisicion/' . $iframe . '/' . $requisicion['rxi_id'] . '/' . $iframe); ?>">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Anular Requisición</span>
                    </h4>
                </div>
                <div class="content noPad clearfix">
                    <div class="form-row row-fluid">
                        <div class="span6" style="<?php echo ($iframe == 1) ? 'margin-left: 10px;' : ''; ?>">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3" style="margin-right: 10px;">Requisición No.:</label>
                                <div class="span7 controls">
                                    <input type="text" ReadOnly="ReadOnly" value="<?php echo $requisicion['rxi_numero']; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6" style="margin-left: 10px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3">Fecha Solicitud:</label>
                                <div class="span7 controls">
                                    <input type="text" ReadOnly="ReadOnly" value="<?php echo date('d-m-Y', strtotime($requisicion['rxi_fecha'])); ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6" style="margin-left: 10px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3" style="margin-right: 10px;">Tipo:</label>
                                <div class="span7 controls">
                                    <?php
                                    $tipo = '';
                                    switch ($requisicion['rxi_tipo']) {
                                        case 1:
                                            $tipo = "Producto";
                                            break;
                                        case 2:
                                            $tipo = "Servicio";
                                            break;
                                        case 3:
                                            $tipo = "Activo Fijo";
                                            break;
                                    }
                                    ?>
                                    <input type="text" ReadOnly="ReadOnly" value="<?php echo $tipo; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6" style="margin-left: 10px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3">Solicitante:</label>
                                <div class="span7 controls">
                                    <input type="text" ReadOnly="ReadOnly" value="<?php
                                    echo $solicitante[0]['emp_nombre'] . ' ' . $solicitante[0]['emp_apellido'];
                                    ;
                                    ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span12" style="padding: 5px;overflow-x: scroll;margin-left: 0px;">
                            <div>
                                <table id="tblDetalleRequisicion" class="responsive display table table-bordered simpleTable">
                                    <thead>
                                        <tr>
                                            <th>Código</th>
                                            <th>Producto</th>
                                            <th>UM</th>
                                            <th>Saldo Actual</th>
                                            <th>Cantidad a Solicitar</th>
                                            <th>Cantidad Despachada</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if (count($detalle_requisicion) > 0):
                                            foreach ($detalle_requisicion as $dri):

                                                $codigo_producto = "";
                                                $nombre_producto = "";
                                                $unidad_medida = "";
                                                $saldo_actual = "";
                                                $cantidad_sol = "";

                                                switch ($requisicion['rxi_tipo']) {
                                                    case 1:
                                                        $codigo_producto = $dri['art_codigo'];
                                                        $nombre_producto = $dri['art_nombre'];
                                                        $unidad_medida = $dri['mep_nombre'];
                                                        $articulos = $this->inventario_model->obt_cant_minimaYexistente($dri['art_id'], $requisicion['rxi_id_bod']);
                                                        $saldo_actual = 0;
                                                        if (count($articulos) > 0) {
                                                            foreach ($articulos as $suma) {
                                                                $saldo_actual = $suma['suma'];
                                                            }
                                                        }
                                                        $cantidad_sol = $dri['dri_cantidad'];
                                                        $cantidad_desp = $dri['dri_cantidad_despacho'];
                                                        break;
                                                    case 2:
                                                        $codigo_producto = $dri['art_codigo'];
                                                        $nombre_producto = $dri['art_nombre'];
                                                        $unidad_medida = '---';
                                                        $saldo_actual = '---';
                                                        $cantidad_sol = $dri['dri_cantidad'];
                                                        $cantidad_desp = $dri['dri_cantidad_despacho'];
                                                        break;
                                                    case 3:
                                                        $codigo_producto = $dri['act_codigo'];
                                                        $nombre_producto = $dri['act_nombre'];
                                                        $unidad_medida = '---';
                                                        $saldo_actual = '---';
                                                        $cantidad_sol = $dri['dri_cantidad'];
                                                        $cantidad_desp = $dri['dri_cantidad_despacho'];
                                                        break;
                                                }
                                                ?>
                                                <tr>
                                                    <td><?php echo $codigo_producto; ?></td>
                                                    <td><?php echo $nombre_producto; ?></td>
                                                    <td><?php echo $unidad_medida; ?></td>
                                                    <td><?php echo ($saldo_actual == 0) ? 0 : $saldo_actual; ?></td>
                                                    <td><?php echo number_format($cantidad_sol, 2); ?></td>
                                                    <td><?php echo number_format($cantidad_desp, 2); ?></td>
                                                </tr>
                                                <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="span12" style="margin-top:20px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3">
                                    Comentario:<b class="red">*</b>
                                </label>
                                <div class="span7 controls">
                                    <textarea id="txtComentario" name="txtComentario" MaxLength="1000"></textarea>
                                    <br>
                                    <div id="txtComentario_error" style="color:red;font-size:11px;margin-top: 10px;"></div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="redireccion" name="redireccion" value="<?php echo base_url('modulo_compras/procesos/documentos_proveedor/'); ?>" />
                        <input type="hidden" id="paso_actual" name="paso_actual" value="<?php echo $paso_actual['sgr_id']; ?>" />
                        <div class="form-actions" style="text-align: center;">
                            <button type="submit" class="btn btn-success" id="btnCrear" value="1"><span class="icon16 icomoon-icon-checkmark white"></span>Anular</button>
                            <?php if ($iframe == 1): ?>
                                <button type="button" class="btn btn-danger btn-close" id="" onclicks="javascript:parent.jQuery.fancybox.close();"><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</button>
                            <?php else: ?>
                                <a href="<?php echo base_url('modulo_compras/procesos/documentos_proveedor/' . $doc_proveedor['dpv_id_orc']); ?>" class="btn btn-danger btn-cancelar" id=""><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript" src="<?= base_url() ?>js/modulo_compras/procesos/anularRequisicion.js" ></script>