<?php if (isset($cerrar_modal)): ?>
    <script type="text/javascript">
        $(document).ready(function () {

            parent.crear_alerta('<?php echo $alerta['tipo_alerta']; ?>', '<?php echo $alerta['titulo_alerta']; ?>', '<?php echo $alerta['texto_alerta']; ?>');
            $("#btnConsultar", parent.document.body).trigger('click');

            parent.jQuery.fancybox.close();
        });
    </script>
<?php endif; ?>
<form id="frm-orden" method="post" name="frm-req" action="<?php echo base_url('modulo_compras/procesos/anular_orden_compra/' . $iframe . '/' . $orden_compra['orc_id'] . '/' . $tipo_flujo); ?>">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Anular Orden de compra</span>
                    </h4>
                </div>
                <div class="content noPad clearfix">
                    <div class="form-row row-fluid">
                        <div class="span6" style="<?php echo ($iframe == 1) ? 'margin-left: 10px;' : ''; ?>">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3" style="margin-right: 10px;">Orden No.:</label>
                                <div class="span7 controls">
                                    <input type="text" ReadOnly="ReadOnly" value="<?php echo $orden_compra['orc_numero']; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6" style="margin-left: 10px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3">Fecha Orden:</label>
                                <div class="span7 controls">
                                    <input type="text" ReadOnly="ReadOnly" value="<?php echo date('d-m-Y', strtotime($orden_compra['orc_fecha_orden'])); ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6" style="margin-left: 10px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3" style="margin-right: 10px;">Tipo:</label>
                                <div class="span7 controls">
                                    <?php
                                    $tipo = '';
                                    switch ($orden_compra['orc_tipo']) {
                                        case 1:
                                            $tipo = "Producto";
                                            break;
                                        case 2:
                                            $tipo = "Servicio";
                                            break;
                                        case 3:
                                            $tipo = "Activo Fijo";
                                            break;
                                    }
                                    ?>
                                    <input type="text" ReadOnly="ReadOnly" value="<?php echo $tipo; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6" style="margin-left: 10px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3">Solicitante:</label>
                                <div class="span7 controls">
                                    <input type="text" ReadOnly="ReadOnly" value="<?php
                                    echo $solicitante[0]['emp_nombre'] . ' ' . $solicitante[0]['emp_apellido'];
                                    ;
                                    ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span12" style="padding: 5px;overflow-x: scroll;margin-left: 0px;">
                            <div style="width:125%;">
                                <table id="tblDetalleRequisicion" class="responsive display table table-bordered simpleTable">
                                    <thead>
                                        <tr>
                                            <th>
                                                Código
                                            </th>
                                            <th>
                                                Producto
                                            </th>
                                            <th>
                                                UM
                                            </th>
                                            <th>
                                                Cantidad
                                            </th>
                                            <th>
                                                Precio
                                            </th>
                                            <th>
                                                Impuesto
                                            </th>
                                            <th>
                                                Descuento (%)
                                            </th>
                                            <th>
                                                Subtotal
                                            </th>
                                            <th>
                                                Total
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if (count($detalle_orden) > 0):
                                            $i = 1;
                                            foreach ($detalle_orden as $dor):
                                                $id_detalle = $dor['dor_id'];
                                                $codigo_producto = "";
                                                $nombre_producto = "";
                                                $unidad_medida = "";
                                                $conversion_id = null;
                                                $cantidad_productos = $dor['dor_cantidad'];
                                                $precio_producto = number_format($dor['dor_precio_unitario'], 2);
                                                $totalImpuestos = number_format($dor['dor_impuesto'], 2);
                                                $descuento = number_format($dor['dor_descuento'], 2);
                                                $subtotal = number_format($dor['dor_subtotal'], 2);
                                                $total = number_format($dor['dor_total'], 2);

                                                switch ($orden_compra['orc_tipo']) {
                                                    case 1:
                                                        $codigo_producto = $dor['art_codigo'];
                                                        $nombre_producto = $dor['art_nombre'];
                                                        $unidad_medida = $dor['mep_nombre'];
                                                        $conversion_id = $dor['cva_id'];
                                                        break;
                                                    case 2:
                                                        $codigo_producto = $dor['art_codigo'];
                                                        $nombre_producto = $dor['art_nombre'];
                                                        $unidad_medida = '';
                                                        break;
                                                    case 3:
                                                        $codigo_producto = $dor['act_codigo'];
                                                        $nombre_producto = $dor['act_nombre'];
                                                        $unidad_medida = '';
                                                        break;
                                                }
                                                ?>
                                                <tr id="<?php echo $codigo_producto; ?>" data-id="<?php echo $id_detalle; ?>">
                                                    <td><?php echo $codigo_producto; ?></td>
                                                    <td><?php echo $nombre_producto; ?></td>
                                                    <td><?php echo $unidad_medida; ?></td>
                                                    <td><?php echo number_format($cantidad_productos, 0, '',','); ?></td>
                                                    <td><?php echo number_format($precio_producto, 2,'.',','); ?></td>
                                                    <td><?php echo $totalImpuestos; ?></td>
                                                    <td><?php echo $descuento; ?></td>
                                                    <td><?php echo $subtotal; ?></td>
                                                    <td><?php echo $total; ?></td>
                                                </tr>
                                                <?php
                                                $i++;
                                            endforeach;
                                        endif;
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="span12" style="margin-top:20px;">
                            <div class="row-fluid">
                                <label runat="server" class="form-label span3">
                                    Comentario:<b class="red">*</b>
                                </label>
                                <div class="span7 controls">
                                    <textarea id="txtComentario" name="txtComentario" MaxLength="1000"></textarea>
                                    <br>
                                    <div id="txtComentario_error" style="color:red;font-size:11px;margin-top: 10px;"></div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="redireccion" name="redireccion" value="<?php echo base_url('modulo_compras/procesos/documentos_proveedor/'); ?>" />
                        <input type="hidden" id="paso_actual" name="paso_actual" value="<?php echo $paso_actual['sgo_id']; ?>" />
                        <div class="clear"></div>
                        <div class="form-actions" style="text-align: center;">
                            <button type="submit" class="btn btn-success" id="btnCrear" value="1"><span class="icon16 icomoon-icon-checkmark white"></span>Anular</button>
                            <?php if ($iframe == 1): ?>
                                <button type="button" class="btn btn-danger btn-close" id="" onclicks="javascript:parent.jQuery.fancybox.close();"><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</button>
                            <?php else: ?>
                                <a href="<?php echo base_url('modulo_compras/procesos/documentos_proveedor/' . $doc_proveedor['dpv_id_orc']); ?>" class="btn btn-danger btn-cancelar" id=""><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript" src="<?= base_url() ?>js/modulo_compras/procesos/anularOrden.js" ></script>