<?php
$day = array("Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado");
$dd = formatear_fecha('w', $dato_dpv['dpv_fecha_documento']); 
$dv = formatear_fecha('w', $dato_dpv['dpv_fecha_vencimiento']); 
?>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Documento Proveedor #<?= $dato_dpv['dpv_numero_documento'] ?> <?= (count($quedan) > 0) ? ', Quedan #' . $quedan[0]['qda_correlativo'] : ""; ?></span>
                </h4>
            </div>
            <div class="content">
                <form id="frm_quedan_form" method="POST" name="frm_quedan_form" action="<?php echo base_url('modulo_compras/procesos/agregar_quedan/' . $dato_dpv['dpv_id']); ?>">
                    <div class="row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Proveedor:</label>
                                    <div class="span7 controls">
                                        <?php $proveedor = ($dato_dpv['prv_tipo_pers'] > 1) ? $dato_dpv['prv_apellido'] : $dato_dpv['prv_nombre'] . ' ' . $dato_dpv['prv_apellido']; ?>
                                        <input type="text" id="prv_name" readonly value="<?php echo $dato_dpv['prv_codigo'] . ' - ' . $proveedor; ?>">
                                        <input type="hidden" id="solo_ver" value="<?php echo $ver; ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Fecha Documento:</label>
                                    <div class="span7 controls">
                                        <input type="text" id="f_doc" name="f_doc" readonly value="<?= $day[$dd] . ' ' . formatear_fecha('d-m-Y', $dato_dpv['dpv_fecha_documento']) ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Observaciones:<b style="color: red;">*</b></label>
                                    <div class="span7 controls">
                                        <textarea name="txtObservacion" id="txtObservacion" style="width: 100%;"><?php echo (count($quedan) > 0) ? $quedan[0]['qda_observacion'] : ""; ?></textarea>
                                        <label id="txtObservacion_error" style="margin-right: 10px; color: red"></label>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Fecha Vencimiento:</label>
                                    <div class="span7 controls">
                                        <input type="text" id="f_ven" name="f_ven" readonly value="<?= $day[$dv] . ' ' . formatear_fecha('d-m-Y', $dato_dpv['dpv_fecha_vencimiento']) ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if (count($quedan) > 0 && $ver > 0) {?>
                        <div class="row-fluid">
                            <div class="span12">
                                <div class="span6">
                                    <div class="row-fluid">
                                        <label class="span4">Estado:</label>
                                        <div class="span7 controls">
                                            <input type="text" id="estado_qda" readonly value="<?php echo ($quedan[0]['qda_estado'] > 0) ? 'Activo' : 'Anulado'; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="span6">
                                    <div class="row-fluid">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row-fluid">
                        <div class="span12">
                            <div class="form-actions" style="text-align:center;">
                                <?php
                                if ($ver > 0 && count($quedan) > 0) {
                                    ?>
                                    <a class="btn btn-info" href="<?= base_url('modulo_compras/procesos/grid_quedan_form/' . $dato_dpv['dpv_id']) ?>">
                                        <span class="icomoon-icon-undo-2 white"> Volver</span>
                                    </a>
                                    <?php
                                } else {
                                    ?>
                                    <button type="submit" class="btn btn-success" id="guardar_detalle">
                                        <span class="icon16 icomoon-icon-checkmark white"> Guardar</span>
                                    </button>
                                    <a class="btn btn-danger btn-close" href="<?= base_url('modulo_compras/procesos/grid_quedan_form/' . $dato_dpv['dpv_id']) ?>">
                                        <span class="icon16 icomoon-icon-cancel-2 white"> Cancelar</span>
                                    </a>
                                    <?php
                                }
                                ?>                                
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div> 
<script type="text/javascript">
    $(document).ready(function () {

        $("#frm_quedan_form").validate({
            ignore:"",
            rules: {
                txtObservacion:{required:true},
            },
            ignore: ".select2-container",
            errorPlacement: function (error, element) {
                var nombre=$(element).attr("id");
                $('#'+nombre+'_error').text('Campo requerido');
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

        $("#txtObservacion").live('keyup', function (event) {
            $("#txtObservacion_error").text('');
        });

        if ($("#solo_ver").val() > 0) {
            $("#txtObservacion").attr("disabled", "disabled");
        } else {
             $("#txtObservacion").removeAttr("disabled");
        }

    });
</script>