<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title"><h4>Filtrar</h4></div>
            <div class="content">
                <form method="post" id="frmConsultaform" name="frmConsultaform">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span8">
                                <div class="row-fluid">
                                
                                    <label class="form-label span4" for="normal" style="margin-right: 5px;">Estado:</label>
                                    <div class="span4">
                                        <select id="slcEstado" name="slcEstado" required placeholder="Seleccione" style="width: 100%" class="nostyle">
                                            <option value=""></option>
                                            <option value="1" >Activos</option>
                                            <option value="0" >Inactivos</option>
                                        </select>
                                        <span id="error_slcEstado"></span>
                                    </div>
                                
                                    <div class="span1"></div>
                                    <div class="span3">
                                        <button class="btn btn-info" id="btnConsultar" name="btnConsultar" type="submit">
                                            <span class="icon16 icomoon-icon-search-3 white">Consultar</span> 
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="span4">&nbsp;</div>
                        </div>
                    </div>
                </form><!-- Fin formulario filtrar --> 
            </div> <!-- Fin content -->
        </div><!-- End .box -->
    </div>
</div>
<div class="row-fluid">
    <div class="span12">
        <?php if ($permisos['permite_agregar']) {
            ?>
            <a type="button" class="btn btn-large" href="<?php echo base_url("marcacion/procesos/asignacion_turno");?>">Agregar Asignacion de turno</a>      
            <?php 
        } ?>
        <div class="box">
            <div class="title">
                <h4><span></span></h4>
            </div>
            <div style="height: 100%;overflow-y: auto;" class="content noPad clearfix" id="contenedor_consulta">
                <table id="tabla1" class="table table-bordered" width="100%">
                    <thead>
                        <tr>
                            <th>Turno</th>
                            <th>Empleada/o</th>   
                            <th>Fecha desde</th>                        
                            <th>Fecha hasta</th>
                            <th>Tipo Turno</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {

        $("select").select2({placeholder: "Seleccione"});

        aplidarDataTable("tabla1");

        $('body').on('click', '.anulacion', function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            alerta_confirm_ajax(anular_turno, url, "Alerta confirmación", '¿Seguro que desea inactivar este Turno?'); 
        });

        $(".ver_modal").fancybox({
            'width' : '100%',
            'height' : '500',
            'autoSize' : false,
            'autoScale' : true,
            'transitionIn' : 'none',
            'transitionOut' : 'none',
            'title' : false,
            'type' : 'iframe'
        });

        $('#frmConsultaform').validate({
            errorPlacement: function (error, element) {
                var nombre=$(element).attr("id");
                $('#'+nombre+'_error').html(error);
            },
            submitHandler: function(form){
                wait.start();
                $("#contenedor_consulta").hide("slide", { 
                    direction: 'right'
                }, 400, function() {
                    $.ajax({
                        type: 'POST',
                        dataType: 'json',
                        url:  window.gSateliteWhite.baseUrl('marcacion/procesos/grid_asignacion_turno'),
                        data: $(form).serialize(),
                        success: function (data) {            
                            $("#contenedor_consulta").html(data.resultado);
                            wait.close();                            
                            $("#contenedor_consulta").show("slide", {
                                direction: 'left'
                            }, 500);
                            aplidarDataTable("tabla1");
                        }
                    });
                });
            } 
        }); 

    });
    
    function aplidarDataTable(idTabla) {
        $('#' + idTabla).dataTable();
    }

    function anular_turno(url = "") {
        if (url != "") {
            window.open(url, '_self');
        }
    }

</script>