<?php 
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
$dia = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
$hora = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
$smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$pdf = false;
if ($reporte != "") { 
    $pdf = ($reporte == 'pdf') ? true : false;
    if ($reporte == 'excel'){
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=Reporte_resumen_marcaciones.xls");
        header("Pragma: no-cache");
        header("Expires: 0");
        ?>
        <meta charset="utf-8" />
        <div class="head">
            <table>
                <tr>
                    <td align="center" colspan="7" >
                        <h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h4>
                    </td>
                </tr>
                <tr>
                    <td align="center" colspan="7" >
                        <h4>Reporte De Llegadas Tardías <?php echo $periodo ?></h4></td>
                </tr>
            </table>
        </div>
    <?php } else { ?>
        <table border="0" width="100%">
            <tr>
                <td style="text-align: center;"><h4><?php echo $periodo; ?></h4></td>
            </tr>
        </table>
    <?php } 
} ?>
<table border="1" id="detalles" class="responsive table table-striped table-bordered table-condensed">
    <thead>
        <tr style="font-weight:bold;" nobr="true">
            <th <?=($pdf)? 'width="5%"':''?> >#</th>
            <th <?=($pdf)? 'width="10%"':''?> >CÓDIGO</th>
            <th <?=($pdf)? 'width="25%"':''?> >NOMBRE DEL EMPLEADA/O</th>
            <th <?=($pdf)? 'width="10%"':''?> >CANTIDAD</th>
            <th <?=($pdf)? 'width="10%"':''?> >MINUTOS LLEGADA TARDE</th>
            <th <?=($pdf)? 'width="10%"':''?> >MINUTOS SALIDA TEMPRANO</th>
            <th <?=($pdf)? 'width="10%"':''?> >MINUTOS DESCUENTO SIMPLE</th>
            <th <?=($pdf)? 'width="10%"':''?> >MINUTOS DESCUENTO DOBLE</th>
            <th <?=($pdf)? 'width="10%"':''?> >CALCULO <?=(trim($smb) != "")?"($smb)":"";?></th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $nl = 0;
        if (count($marcaciones) > 0) {
            $total_cantidad = 0;
            $total_llegada_tarde = 0;
            $total_salida_temprano = 0;
            $total_descuento = 0;
            $total_min_simple = 0;
            $total_min_doble = 0;
            foreach ($marcaciones as $mar) {
                $eventos = (is_numeric($mar['eventos_doble_entradas'])) ? $mar['eventos_doble_entradas'] : 3;
                    $n_cantidad = ($mar['n_llegada_tarde'] + $mar['n_salida_temprano']);
                    $n_minutos = ($mar['entrada_tarde'] + $mar['salida_temprano']);
                    $min_doble = $min_simple = $calulo_descuento = 0;
                    // SI HAY INJUSTIFICADOS SACAR EL CALCULO QUE SE SUMARA
                    $calulo_inhustifi = ($mar['emp_salario'] / $dias_mes /  $hora / 60) * $mar['injustificado'];
                    if($n_cantidad > $eventos) {
                        $calulo_descuento = ($mar['emp_salario'] / $dias_mes /  $hora / 60) * ($n_minutos * 2);
                        $total_min_doble += ($n_minutos * 2);
                        $min_doble = ($n_minutos * 2);
                    } else {
                        $calulo_descuento = ($mar['emp_salario'] / $dias_mes /  $hora / 60) * $n_minutos;
                        $total_min_simple += $n_minutos;
                        $min_simple = $n_minutos;
                    }
                    $calulo_descuento += $calulo_inhustifi;
                    $total_descuento += round($calulo_descuento,2);
                    $total_cantidad += $n_cantidad;
                    $total_llegada_tarde += $mar['entrada_tarde'];
                    $total_salida_temprano += $mar['salida_temprano'];
                    ?>
                    <tr>
                        <td <?=($pdf)? 'width="5%"':''?>  style="text-align: center;"><?php echo ($nl+1); ?></td>
                        <td <?=($pdf)? 'width="10%"':''?>  style='mso-number-format:"\@";'><?php echo $mar['emp_codigo']; ?></td>
                        <td <?=($pdf)? 'width="25%"':''?> ><?php echo $mar['emp_nombre'] . ' ' . $mar['emp_apellido']; ?></td>
                        <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><?php echo $n_cantidad; ?></td>
                        <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><?php echo $mar['entrada_tarde']; ?></td>
                        <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><?php echo $mar['salida_temprano']; ?></td>
                        <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><?php echo $min_simple; ?></td>
                        <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><?php echo $min_doble; ?></td>
                        <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;">$<?php echo number_format($calulo_descuento, 2); ?></td>
                    </tr>
                    <?php
                    $nl++;
                                
            }
        }
        if ($nl == 0 && $reporte != "") {
                ?>
                <tr>
                    <td colspan="9" style="text-align: center;"><b>No se encontraron registros</b></td>
                </tr>
                <?php
            } 
        ?>
    </tbody>
    <?php if ($nl > 0) {
        ?>
        <tfoot>
        <tr>
            <td <?=($pdf)? 'width="40%"':''?>  colspan="3" style="text-align: right;"><b>TOTALES</b></td>
            <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><b><?php echo $total_cantidad; ?></b></td>
            <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><b><?php echo $total_llegada_tarde; ?></b></td>
            <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><b><?php echo $total_salida_temprano; ?></b></td>
            <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><b><?php echo $total_min_simple; ?></b></td>
            <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><b><?php echo $total_min_doble; ?></b></td>
            <td <?=($pdf)? 'width="10%"':''?>  style="text-align: right;"><b>$<?php echo number_format($total_descuento, 2); ?></b></td>
        </tr>
    </tfoot>
    <?php } ?>
</table>
