<?php 
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
$dia = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
$hora = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
$smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$pdf = false;
if ($reporte != "") { 
    $pdf = ($reporte == 'pdf') ? true : false;
    if ($reporte == 'excel'){
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=Reporte Llegadas Tardias.xls");
        header("Pragma: no-cache");
        header("Expires: 0");
        ?>
        <meta charset="utf-8" />
        <div class="head">
            <table>
                <tr>
                    <td align="center" colspan="7" >
                        <h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h4>
                    </td>
                </tr>
                <tr>
                    <td align="center" colspan="7" >
                        <h4>Reporte De Llegadas Tardías <?php echo $periodo ?></h4></td>
                </tr>
            </table>
        </div>
    <?php } else { ?>
        <table border="0" width="100%">
            <tr>
                <td style="text-align: center;"><h4><?php echo $periodo; ?></h4></td>
            </tr>
        </table>
    <?php } 
} ?>
<table border="1" id="detalles" class="responsive table table-striped table-bordered table-condensed">
    <thead>
        <tr style="font-weight:bold;">
            <th <?= ($pdf) ? 'width="12%"' : ''; ?>>Código</th>
            <th <?= ($pdf) ? 'width="40%"' : ''; ?>>Empleada/o</th>
            <th <?= ($pdf) ? 'width="12%"' : ''; ?>>Cantidad</th>
            <th <?= ($pdf) ? 'width="12%"' : ''; ?>>Llegadas Tardías</th>
            <th <?= ($pdf) ? 'width="12%"' : ''; ?>>Salidas Temprano</th>
            <th <?= ($pdf) ? 'width="12%"' : ''; ?>>Cálculo <?=(trim($smb) != "")?"($smb)":"";?></th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $lineas = 0;
        if (count($empleados) > 0) {
            $total_horas_inn = $total_horas_out = $total_veces = $total_monto = 0;
            foreach ($empleados as $key => $val) {
                if (count($retraso_entrada[$val['emp_id']]) > 0 || count($retraso_salidas[$val['emp_id']]) > 0) {
                    $min_inn = $min_out = $min_inj = $veces = 0;
                    $sal_min = $val['emp_salario'] / ($dia * $hora * 60);
                    foreach ($retraso_entrada as $k0 => $v0) {
                        if ($k0 == $val['emp_id']) {
                            $veces += count($v0);
                            foreach ($v0 as $ke0 => $val0) {
                                $min_inn += $val0;
                            }
                            
                        }
                    }
                    foreach ($retraso_salidas as $k1 => $v1) {
                        if ($k1 == $val['emp_id']) {
                            $veces += count($v1);
                            foreach ($v1 as $ke1 => $val1) {
                                $min_out += $val1;
                            }
                            
                        } 
                    }
                    $min_inj = 0;
                    if (count($injustificados[$val['emp_id']]) > 0) {
                        foreach ($injustificados[$val['emp_id']] as $k2 => $v2) {
                            $min_inj += $v2;///////////////////////dias sin marcacion = ausencia injustificada que es al doble
                        }
                    }
                    $factor = ($veces > 3) ? 2 : 1;//////////////3+ veces cobraria al doble
                    $calculo = $sal_min * ($min_inn + $min_out) * $factor;
                    $calculo += ($sal_min * $min_inj);
                    ?>
                    <tr>
                        <td <?= ($pdf) ? 'width="12%"' : ''; ?> style='mso-number-format:"\@";'><?php echo $val['emp_codigo']; ?></td>
                        <td <?= ($pdf) ? 'width="40%"' : ''; ?>><?php echo $val['emp_nombre'] . ' ' . $val['emp_apellido']; ?></td>
                        <td <?= ($pdf) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($veces); ?></td>
                        <td <?= ($pdf) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($min_inn, $dec); ?></td>
                        <td <?= ($pdf) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($min_out, $dec); ?></td>
                        <td <?= ($pdf) ? 'width="12%"' : ''; ?> style="text-align: right;">$<?php echo number_format($calculo, 2); ?></td>
                    </tr>
                    <?php
                    $total_veces += $veces;
                    $total_horas_inn += number_format($min_inn, $dec, '.', '');
                    $total_horas_out += number_format($min_out, $dec, '.', '');
                    $total_monto += number_format($calculo, 2, '.', '');
                    $lineas++;
                }                
            }
        }
        if ($lineas == 0 && $reporte != "") {
                ?>
                <tr>
                    <td colspan="6" style="text-align: center;"><b>No se encontraron registros</b></td>
                </tr>
                <?php
            } 
        ?>
    </tbody>
    <?php if (count($empleados) > 0) {
        ?>
        <tfoot>
        <tr>
            <td colspan="2" style="text-align: right;"><b>TOTALES</b></td>
            <td style="text-align: right;"><b><?php echo number_format($total_veces); ?></b></td>
            <td style="text-align: right;"><b><?php echo number_format($total_horas_inn, $dec); ?></b></td>
            <td style="text-align: right;"><b><?php echo number_format($total_horas_out, $dec); ?></b></td>
            <td style="text-align: right;"><b>$<?php echo number_format($total_monto, 2); ?></b></td>
        </tr>
    </tfoot>
    <?php } ?>
</table>
