<?php
$pdf = ($reporte == 'pdf') ? true : false;
if ($reporte == 'excel'){
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=Reporte Eventos Llegadas Tardias.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h4>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="7" >
                    <h4>Reporte De Eventos de Llegadas Tardías <?php echo $periodo ?></h4>
                </td>
            </tr>
        </table>
    </div>
    <?php
}
?>
<table border="1" id="detalles" class="responsive table table-bordered table-condensed">
    <thead>
        <tr style="font-weight:bold;">
            <th <?= ($pdf) ? 'width="16%"' : ''; ?>>Código</th>
            <th <?= ($pdf) ? 'width="50%"' : ''; ?>>Empleada/o</th>
            <th <?= ($pdf) ? 'width="17%"' : ''; ?>>Cantidad de Veces</th>
            <th <?= ($pdf) ? 'width="17%"' : ''; ?>>Minutos Tarde</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $total_veces = $total_minutos = 0;
        if (count($registros) > 0) {            
            foreach ($registros as $key => $val) {
                $total_minutos += $val['min_tarde'];
                $total_veces += $val['eventos'];
                $color = (is_numeric($pasables) && ($val['eventos'] > $pasables)) ? 'style="background: #F2A1A1 !important;"': 'style="background: #FAFAFA !important;"';
                ?>
                <tr nobr="true" <?= $color ?>>
                    <td <?= ($pdf) ? 'width="16%"' : ''; ?> style='mso-number-format:"\@";'><?php echo $val['emp_codigo']; ?></td>
                    <td <?= ($pdf) ? 'width="50%"' : ''; ?>><?php echo $val['emp_nombre'] . ' ' . $val['emp_apellido']; ?></td>
                    <td <?= ($pdf) ? 'width="17%"' : ''; ?> style="text-align: right;"><?php echo number_format($val['eventos']); ?></td>
                    <td <?= ($pdf) ? 'width="17%"' : ''; ?> style="text-align: right;"><?php echo number_format($val['min_tarde']); ?></td>
                </tr>
                <?php
            }
        } else {
            if ($reporte != "") {
                ?>
                <tr>
                    <td colspan="4" style="text-align: center;"><b>No se encontraron registros</b></td>
                </tr>
                <?php
            } 
        }?>
    </tbody>
    <?php if (count($registros) > 0) {
        ?>
        <tfoot>
            <tr>
                <td colspan="2" style="text-align: right;"><b>TOTALES</b></td>
                <td style="text-align: right;"><b><?php echo number_format($total_veces); ?></b></td>
                <td style="text-align: right;"><b><?php echo number_format($total_minutos); ?></b></td>
            </tr>
        </tfoot>
    <?php } ?>
</table>
