<?php
// Configuración de la ruta base
$directorioBase = FCPATH . '/uploads/documentos_intranet';

// Verificar si el directorio existe
if (!is_dir($directorioBase)) {
    die("El directorio no existe o no es accesible.");
}

// Función para obtener carpetas y archivos
function obtenerCarpetasYArchivos($ruta) {
    $elementos = array_diff(scandir($ruta), array('.', '..'));
    $estructura = [];

    foreach ($elementos as $elemento) {
        $rutaCompleta = $ruta . '/' . $elemento;
        if (is_dir($rutaCompleta)) {
            $estructura[] = htmlspecialchars($elemento); // Sanitizar nombres de carpetas
        }
    }

    return $estructura;
}

// Obtener las carpetas principales
$carpetasPrincipales = obtenerCarpetasYArchivos($directorioBase);
?>


    <style>
        .menu-lateral {
            height: 100%;
            background-color: #f8f9fa;
            padding-top: 20px;
            border-right: 1px solid #ddd;
        }
        .menu-lateral a {
            display: block;
            padding: 10px 15px;
            text-decoration: none;
            color: #333;
        }
        .menu-lateral a:hover {
            background-color: #e9ecef;
            color: #007bff;
        }
    </style>
</head>
<body>
    <!-- Menú lateral -->
    

    <!-- Contenido principal -->
    <div style="width:95%">
        <div class="row">
            <div class="col-md-2">
                <div class="menu-lateral mb-5">
                    <h4 class="text-center">Documentos</h4>
                    <?php if (!empty($carpetasPrincipales)): ?>
                        <?php foreach ($carpetasPrincipales as $carpeta): ?>
                            <a href="#" class="carpeta" data-carpeta="<?= $carpeta; ?>">
                                📁 <?= $carpeta; ?>
                            </a>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="text-center">No se encontraron carpetas disponibles.</p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-10">
                <div class="card mt-4 mb-5">
                    <div class="card-body">
                        <h6 class="h6 mb-4">Documentos de la carpeta seleccionada</h6>
                            <table style="width:100%" class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Nombre del Documento</th>
                                        <th>Acción</th>
                                    </tr>
                                </thead>
                                <tbody id="documentosTabla">
                                    <tr>
                                        <td colspan="3" class="text-center">Selecciona una carpeta.</td>
                                    </tr>
                                </tbody>
                            </table>
                    </div>
                </div>
            </div>
        </div>
        
        
    </div>
<script type="text/javascript" src="<?php echo base_url()?>scripts/jquery.library.1.7.2.js"></script> 
<script src="<?= base_url() ?>public/source/libraries/custom/document.js"></script>

