<?php 
$p = ($tipo == 'pdf') ? true : false;
$s = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
if($tipo == 'exc'){ ?>
	<meta charset="utf-8">
	<?php
	header("Content-Type: application/vnd.ms-excel");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("content-disposition: attachment;filename=" . $filename . ".xls");
	?>
	<style type="text/css">
		.text{
			mso-number-format:"\@";/*force text*/
		}
	</style>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="5">
					<h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />Reporte de Requisiciones</h4>
				</td>
			</tr>
		</table>
	</div>
	<?php 
} 
?>
<table class="responsive table table-bordered dataTable" id="tblReporte" style="font-size:<?=($p)?7:12;?>px;" border="<?= ($tipo != '')?1:0; ?>">
	<thead>
		<tr style="text-align:center;font-weight: bold;">
			<th <?= ($p)?'width="10%"':''; ?>>Área o Unidad</th>
			<th <?= ($p)?'width="10%"':''; ?>>Producto</th>
			<th <?= ($p)?'width="10%"':''; ?>>Categoría</th>
			<th <?= ($p)?'width="7%"':''; ?>>Requisición</th>
			<th <?= ($p)?'width="8%"':''; ?>>Fecha Req.</th>
			<th <?= ($p)?'width="8%"':''; ?>>Cantidad</th>
			<th <?= ($p)?'width="7%"':''; ?>>Bodega</th>
			<th <?= ($p)?'width="7%"':''; ?>>Estado</th>
			<th <?= ($p)?'width="8%"':''; ?>>Fecha Mov.</th>
			<th <?= ($p)?'width="8%"':''; ?>>Entregado</th>
			<th <?= ($p)?'width="8%"':''; ?>>Costo Unit.</th>
			<th <?= ($p)?'width="9%"':''; ?>>Total</th>
		</tr>
	</thead>
	<tbody>
		<?php 
		$suma_pedido = 0;
		$suma_montos = 0;
		$suma_entrega = 0;
		if (count($filas) > 0) {
			foreach ($filas as $k => $val) {
				$suma_pedido += $val['total'];
				$suma_entrega += ($val['despachado'] > 0) ? $val['despachado'] : 0;
				$suma_montos += number_format($val['dee_subtotal'], 2, '.', '');
				switch ($val['rxi_estado']) {
					case '1':
						$estado_rxi = "Creada";
						break;
					case '2':
						$estado_rxi = "Pendiente de Autorización";
						break;
					case '3':
						$estado_rxi = "Autorizada";
						break;
					case '4':
						$estado_rxi = "Rechazada";
						break;
					case '5':
						$estado_rxi = "Anulada";
						break;
					case '6':
						$estado_rxi = "Entregado Parcial";
						break;
					default:
						$estado_rxi = "Entregado";
						break;
				}
				?>
				<tr nobr="true">
					<td <?= ($p)?'width="10%"':''; ?>><?= $val['are_nombre'] ?></td>
					<td <?= ($p)?'width="10%"':''; ?>><?= $val['art_nombre'] ?></td>
					<td <?= ($p)?'width="10%"':''; ?>><?= $val['tia_codigo'] . ' ' . $val['tia_nombre'] ?></td>
					<td <?= ($p)?'width="7%"':''; ?>class="text"><?= $val['rxi_numero'] ?></td>
					<td <?= ($p)?'width="8%"':''; ?>><span style="display:none;"><?= ($tipo != '')?'':formatear_fecha('Ymd', $val['rxi_fecha']); ?></span><?= formatear_fecha('d-m-Y', $val['rxi_fecha']) ?></td>
					<td <?= ($p)?'width="8%"':''; ?> style="text-align: right;"><?= number_format($val['total'], 2) ?></td>
					<td <?= ($p)?'width="7%"':''; ?>><?= $val['bod_nombre'] ?></td>
					<td <?= ($p)?'width="7%"':''; ?>><?= $estado_rxi ?></td>
					<td <?= ($p)?'width="8%"':''; ?>><span style="display:none;"><?= ($tipo != '')?'':formatear_fecha('Ymd',$val['moi_fecha_mov']);?></span><?= formatear_fecha('d-m-Y',$val['moi_fecha_mov']) ?></td>
					<td <?= ($p)?'width="8%"':''; ?> style="text-align: right;"><?= ($val['despachado'] > 0) ? number_format($val['despachado'], 2) : ''; ?></td>
					<td <?= ($p)?'width="8%"':''; ?> style="text-align: right;"><?= $s . number_format($val['dee_precio'], 2) ?></td>
					<td <?= ($p)?'width="9%"':''; ?> style="text-align: right;"><?= $s . number_format($val['dee_subtotal'], 2) ?></td>
				</tr>
				<?php 
			}
		} else {
			if ($tipo != '') {
				?>
				<tr nobr="true">
					<td colspan="12">No se encontraron registros</td>
				</tr>
				<?php 
			}
		}
		?>
	</tbody>
	<?php if (count($filas) > 0): ?>
		<tfoot>
			<tr>
				<td colspan="5" style="text-align: right;"><b>Totales</b></td>
				<td style="text-align: right;"><?= number_format($suma_pedido, 2) ?></td>
				<td colspan="3"></td>
				<td style="text-align: right;"><?= number_format($suma_entrega, 2) ?></td>
				<td></td>
				<td style="text-align: right;"><?= $s . number_format($suma_montos, 2) ?></td>
			</tr>
		</tfoot>
	<?php endif ?>
</table>
<?php if ($tipo == ''): ?>
	<script type="text/javascript">
		$(document).ready(function(){
			$('#tblReporte').dataTable();
		});
	</script>
<?php endif ?>
