<?php if($tipo == 'excel'){ ?>
	<meta charset="utf-8">
	<?php
	header("Content-Type: application/vnd.ms-excel");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("content-disposition: attachment;filename=" . $filename . ".xls");
	?>
	<style type="text/css">
		.text{
			mso-number-format:"\@";/*force text*/
		}
	</style>
	<table>
		<thead>
			<th colspan="6">Balance de bodega</th>
		</thead>
		<tbody>
			<tr>
				<td><?php echo ($bodega_nombre != "") ? 'Bodega o Turicentro' : ''; ?></td>
				<td><?php echo $bodega_nombre; ?></td>
				<td colspan="4">Periodo del <?php echo $dia_inicio; ?> al <?php echo $dia_fin; ?> de <?php echo $mes_nombre; ?> de <?php echo date('Y');?></td>
			</tr>
		</tbody>
	</table>
	<br>
	<table  class="responsive dynamicTable display table table-bordered dataTable" id="tblReporte" style="font-size:12.5px;color:black;" <?php echo ($tipo == 'excel')?'border=1':''; ?>>
		<?php 
} 
?>
<thead>
	<th>N° CTA</th>
	<th>Titulo de la cuenta</th>
	<th>Saldo anterior</th>
	<th>Debe</th>
	<th>Haber</th>
	<th>Saldo</th>
</thead>
<tbody>
	<?php 
	$saldo_anterior_total = 0;
	$debe_total = 0;
	$haber_total = 0;
	$saldos_total = 0;
	foreach ($reporte_reg as $key => $value) {
		$saldo_anterior_total += $value['saldo_anterior'];
		$debe_total += $value['entradas'];
		$haber_total += $value['salidas'];
		$saldo_fila = $value['saldo_anterior'] + $value['entradas'] - $value['salidas'];
		$saldos_total += $saldo_fila;
		?>
		<tr class="tblReporte_tr">
			<td class="text"><label style="padding: 6px 4px;"><?php echo $value['tia_codigo']; ?></label></td>
			<td class="text"><label style="padding: 6px 4px;"><?php echo $value['tia_nombre']; ?></label></td>
			<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($value['saldo_anterior'], 2); ?></label></td>
			<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($value['entradas'], 2); ?></label></td>
			<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($value['salidas'], 2); ?></label></td>
			<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($saldo_fila, 2); ?></label></td>
		</tr>
		<?php 
	} 
	?>
</tbody>
<tfoot>
	<tr>
		<td colspan="2" style="text-align: right;"><b>Totales</b></td>
		<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($saldo_anterior_total, 2); ?></label></td>
		<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($debe_total, 2); ?></label></td>
		<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($haber_total, 2); ?></label></td>
		<td style="text-align: right;"><label style="padding: 6px 4px;"><?php echo number_format($saldos_total, 2); ?></label></td>
	</tr>
</tfoot>
<?php if($tipo == 'excel'){ ?>
</table>
<?php } ?>