<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
$decimal = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') != '') ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
$input = "0\.";
$total_unidades = $total_costo = 0;
$valor =  str_pad($input, ($decimal + 3), 0, STR_PAD_RIGHT);
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
        .decimales {
            mso-number-format: <?= $valor ?>;
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                         Reporte de inventario factura
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$registros = 1;
$pagina = null;
$i = 1;
//Si la variable tipo reporte existe se declara la tabla
?>

<?php
$suma_exis = 0;
$suma_costo = 0;
$suma_total = 0;
if ($tipo_reporte != '') { ?>
    <table class="tabla"><?php
    }
    if(count($reporte) != 0){
        if (isset($categoria)) {//SI SELECCIONO UNA CATEGORIA EN ESPECIFICO SE ENVIA $categoria
            if ($prod_in) {//SI SELECCIONO UNO O VARIOS PRODUCTOS DE ESA CATEGORIA
                $in = explode(',', $prod_in);
                $vacio = 0;
                foreach ($reporte as $row){
                    $total_cantidad = 0;
                    $total_precio = 0;
                    $total = 0;            
                    $tipo  = "";
                    if($row['moi_id_dpv'] != null){
                        $tipo = "(Documento por proveedor)";
                    }            
                    if($row['moi_id_rtd'] != null){
                        $tipo = "(Retaceo)";
                    }
                    if($row['moi_id_orc'] != null){
                        $tipo = "(Orden de compra)";
                    }            
                    $where['dee_id_moi'] = $row['moi_id'];
                    $colspan = (isset($where['tip_entrada'])) ? 5 : 5;// 3;
                    $detalles = $this->inventario_model->get_movimientos_detalles($where);
                    $artids = array_column($detalles, 'id');
                    $found = false;
                    foreach ($in as $key => $value) {
                        $existe = array_search($value, $artids);
                        if ($existe != false) {
                            $found = true;
                            break;
                        }
                    }
                    /*
                    $found = array_search($detalles[0]['id'], $in);
                    */
                    $descripcion = '';
                    $descripcion = $row['tip_nombre'];
                    $descripcion .= (trim($row['moi_descripcion'] != '')) ? ' (' . $row['moi_descripcion'] . ')' : '';
                    if ($found !== false) {
                        ?>
                        <tr style="background-color: black; color: white">
                            <td><b>Fecha:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><b><?php echo date('d-m-Y', strtotime($row['moi_fecha_mov'])); ?></b></td>
                        </tr>
                        <tr>
                            <td><b>Documento:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><?php echo $row['moi_documento'].' '.$tipo; ?></td>
                        </tr>
                        <tr>
                            <td><b>Descripción:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><?php echo $descripcion; ?></td>
                        </tr>
                        <tr>
                            <td><b>Bodega:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><?php echo $row['bod_nombre']; ?></td>
                        </tr>
                        <?php if (isset($where['tip_entrada'])) { ?>
                            <tr>
                                <td><b>Proveedor:</b></td>
                                <?php
                                $proveedor = '';
                                if($row['prv_tipo_pers'] == 1){
                                    $proveedor = (trim($row['prv_codigo']).' - '.trim($row['prv_apellido']));
                                } else{
                                    $proveedor = (trim($row['prv_codigo']).' - '.trim($row['prv_nombre'].' '.$row['prv_apellido']));                    
                                }
                                ?>
                                <td colspan="<?php echo $colspan; ?>"><?php echo $proveedor; ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td colspan="<?php echo $colspan + 1; ?>"></td>
                        </tr>
                        <tr>
                            <th>Código</th>
                            <th>Producto</th>
                            <th>Marca</th>
                            <th>Cantidad</th>
                            <?php //Solo en caso de ser entrada se muestra el precio y total
                            if (true || isset($where['tip_entrada'])) {
                                ?>
                                <th>Costo Unitario</th>
                                <th>Sub - Total</th>
                            <?php } ?>
                        </tr>
                        <?php 
                        foreach ($detalles as $dee) {
                            $total_cantidad += $dee['cant_art'];
                            $total_precio += $dee['precio'];
                            $total += $dee['subtotal'];
                            ?>
                            <tr>
                                <td style="text-align:center;"><?php echo $dee['codigo']; ?></td>
                                <td style="text-align:center;"><?php echo $dee['nombre']; ?></td>
                                <td style="text-align:center;"><?php echo $dee['marca']; ?></td>
                                <td style="text-align:center;"><?php echo number_format($dee['cant_art'], $decimal); ?></td>
                                <?php if (true || isset($where['tip_entrada'])): ?>
                                    <td class="decimales" style="text-align:center;">$<?php echo number_format($dee['precio'], $decimal); ?></td>
                                    <td style="text-align:center;">$<?php echo number_format($dee['subtotal'], $decimal); ?></td>
                                <?php endif ?>
                            </tr>
                            <?php
                        }
                        ?>
                        <tr>
                            <td colspan="3" style="text-align:right;"><b>Totales</b></td>
                            <td style="text-align:center;"><?php echo number_format($total_cantidad, $decimal); ?></td>
                            <?php if (true || isset($where['tip_entrada'])): ?>
                                <td class="decimales" style="text-align:center;"><?php// echo number_format($total_precio, $decimal); ?></td>
                                <td style="text-align:center;">$<?php echo number_format($total, $decimal); ?></td>                                
                            <?php endif ?>
                        </tr>
                        <?php
                        $total_unidades += $total_cantidad;
                        $total_costo += $total;
                        $registros++;
                        $vacio++;
                    }                   
                }
                if ($vacio == 0) {
                    echo '<tr><td style="text-align: center" colspan="'.($colspan+1).'">No se encontraron registros</td></tr>';
                }
            } else { //TODOS LOS ARTICULOS DE ESA CATEGORIA
                $vacio = 0;
                foreach ($reporte as $row){
                    $total_cantidad = 0;
                    $total_precio = 0;
                    $total = 0;            
                    $tipo  = "";
                    if($row['moi_id_dpv'] != null){
                        $tipo = "(Documento por proveedor)";
                    }            
                    if($row['moi_id_rtd'] != null){
                        $tipo = "(Retaceo)";
                    }
                    if($row['moi_id_orc'] != null){
                        $tipo = "(Orden de compra)";
                    }            
                    $where['dee_id_moi'] = $row['moi_id'];
                    $colspan = (isset($where['tip_entrada'])) ? 5 : 5;//;
                    $detalles = $this->inventario_model->get_movimientos_detalles($where);
                    $descripcion = '';
                    $descripcion = $row['tip_nombre'];
                    $descripcion .= (trim($row['moi_descripcion'] != '')) ? ' (' . $row['moi_descripcion'] . ')' : '';
                    // if ($detalles[0]['tia_padre'] == $categoria || $detalles[0]['tia_id'] == $categoria) {
                    if (in_array($detalles[0]['tia_id'], $categoria)) {
                        ?>
                        <tr style="background-color: black; color: white">
                            <td><b>Fecha:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><b><?php echo date('d-m-Y', strtotime($row['moi_fecha_mov'])); ?></b></td>
                        </tr>
                        <tr>
                            <td><b>Documento:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><?php echo $row['moi_documento'].' '.$tipo; ?></td>
                        </tr>
                        <tr>
                            <td><b>Descripción:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><?php echo $descripcion; ?></td>
                        </tr>
                        <tr>
                            <td><b>Bodega:</b></td>
                            <td colspan="<?php echo $colspan; ?>"><?php echo $row['bod_nombre']; ?></td>
                        </tr>
                        <?php if (isset($where['tip_entrada'])) { ?>
                            <tr>
                                <td><b>Proveedor:</b></td>
                                <?php
                                $proveedor = '';
                                if($row['prv_tipo_pers'] == 1){
                                    $proveedor = (trim($row['prv_codigo']).' - '.trim($row['prv_apellido']));
                                } else{
                                    $proveedor = (trim($row['prv_codigo']).' - '.trim($row['prv_nombre'].' '.$row['prv_apellido']));                    
                                }
                                ?>
                                <td colspan="<?php echo $colspan; ?>"><?php echo $proveedor; ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td colspan="<?php echo $colspan + 1; ?>"></td>
                        </tr>
                        <tr>
                            <th>Código</th>
                            <th>Producto</th>
                            <th>Marca</th>
                            <th>Cantidad</th>
                            <?php //Solo en caso de ser entrada se muestra el precio y total
                            if (true || isset($where['tip_entrada'])) {
                                ?>
                                <th>Costo Unitario</th>
                                <th>Sub - Total</th>
                            <?php } ?>
                        </tr>
                        <?php 
                        $decimal = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') != '')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
                        foreach ($detalles as $dee) {
                            $total_cantidad += $dee['cant_art'];
                            $total_precio += $dee['precio'];
                            $total += $dee['subtotal'];
                            ?>
                            <tr>
                                <td style="text-align:center;"><?php echo $dee['codigo']; ?></td>
                                <td style="text-align:center;"><?php echo $dee['nombre']; ?></td>
                                <td style="text-align:center;"><?php echo $dee['marca']; ?></td>
                                <td style="text-align:right;"><?php echo number_format($dee['cant_art'], $decimal); ?></td>
                                <?php if (true || isset($where['tip_entrada'])): ?>
                                    <td class="decimales" style="text-align:right;">$<?php echo number_format($dee['precio'], $decimal); ?></td>
                                    <td style="text-align:right;">$<?php echo number_format($dee['subtotal'], $decimal); ?></td>
                                <?php endif ?>
                            </tr>
                            <?php
                        }
                        ?>
                        <tr>
                            <td colspan="3" style="text-align:right;"><b>Totales</b></td>
                            <td style="text-align:right;"><?php echo number_format($total_cantidad, $decimal); ?></td>
                            <?php if (true || isset($where['tip_entrada'])): ?>
                                <td class="decimales" style="text-align:right;"><?php// echo number_format($total_precio, $decimal); ?></td>
                                <td style="text-align:right;">$<?php echo number_format($total, $decimal); ?></td>                                
                            <?php endif ?>
                        </tr>
                        <?php
                        $total_unidades += $total_cantidad;
                        $total_costo += $total;
                        $registros++;
                        $vacio ++; 
                    }                    
                }
                if ($vacio == 0) {
                    echo '<tr><td style="text-align: center">No se encontraron registros</td></tr>';
                }
            }
        } else {//SI NO SELECCIONO CATEGORIA SE MUESTRAN TODOS
            foreach ($reporte as $row){
                $total_cantidad = 0;
                $total_precio = 0;
                $total = 0;            
                $tipo  = "";
                if($row['moi_id_dpv']!=null){
                    $tipo = "(Documento por proveedor)";
                }            
                if($row['moi_id_rtd']!=null){
                    $tipo = "(Retaceo)";
                }
                if($row['moi_id_orc']!=null){
                    $tipo = "(Orden de compra)";
                }            
                $where['dee_id_moi'] = $row['moi_id'];
                $colspan = (isset($where['tip_entrada'])) ? 5 : 5;//3;
                $detalles = $this->inventario_model->get_movimientos_detalles($where);
                $descripcion = '';
                $descripcion = $row['tip_nombre'];
                $descripcion .= (trim($row['moi_descripcion']) != '') ? ' (' . $row['moi_descripcion'] . ')' : '';
                ?>  
                <tr style="background-color: black; color: white">
                    <td><b>Fecha:</b></td>
                    <td colspan="<?php echo $colspan; ?>"><b><?php echo date('d-m-Y', strtotime($row['moi_fecha_mov'])); ?></b></td>
                </tr>
                <tr>
                    <td><b>Documento:</b></td>
                    <td colspan="<?php echo $colspan; ?>"><?php echo $row['moi_documento'].' '.$tipo; ?></td>
                </tr>
                <tr>
                    <td><b>Descripción:</b></td>
                    <td colspan="<?php echo $colspan; ?>"><?php echo $descripcion; ?></td>
                </tr>
                <tr>
                    <td><b>Bodega:</b></td>
                    <td colspan="<?php echo $colspan; ?>"><?php echo $row['bod_nombre']; ?></td>
                </tr>
                <?php if (isset($where['tip_entrada'])) { ?>
                <tr>
                    <td><b>Proveedor:</b></td>
                    <?php
                    $proveedor = '';
                    if($row['prv_tipo_pers'] == 1){
                        $proveedor = (trim($row['prv_codigo']).' - '.trim($row['prv_apellido']));
                    } else{
                        $proveedor = (trim($row['prv_codigo']).' - '.trim($row['prv_nombre'].' '.$row['prv_apellido']));                    
                    }
                    ?>
                    <td colspan="<?php echo $colspan; ?>"><?php echo $proveedor; ?></td>
                </tr>
                <?php } ?>
                <?php if ($row['moi_id_rxi'] > 0) {
                    $solicito = $this->inventario_model->solicitante_rxi($row['moi_id_rxi']);
                    ?>
                    <tr>
                        <td><b>Solicitante:</b></td>
                        <td colspan="<?php echo $colspan; ?>"><?= $solicito[0]['are_nombre'] . ' (' . $solicito[0]['emp_nombre'] . ' ' . $solicito[0]['emp_apellido'] .')'; ?></td>
                    </tr>
                    <?php
                }  ?>
                <tr>
                    <td colspan="<?php echo $colspan + 1; ?>"></td>
                </tr>
                <tr>
                    <th>Código</th>
                    <th>Producto</th>
                    <th>Marca</th>
                    <th>Cantidad</th>
                    <?php 
                    if (true || isset($where['tip_entrada'])) {
                    ?>
                    <th>Costo Unitario</th>
                    <th>Sub - Total</th>
                    <?php } ?>
                </tr>
                <?php
                $decimal = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') != '')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
                foreach ($detalles as $dee) {
                    $total_cantidad += $dee['cant_art'];
                    $total_precio += $dee['precio'];
                    $total += $dee['subtotal'];
                ?>
                    <tr>
                        <td style="text-align:center;"><?php echo $dee['codigo']; ?></td>
                        <td style="text-align:center;"><?php echo $dee['nombre']; ?></td>
                        <td style="text-align:center;"><?php echo $dee['marca']; ?></td>
                        <td style="text-align:right;"><?php echo number_format($dee['cant_art'], $decimal); ?></td>
                        <?php
                        if (true || isset($where['tip_entrada'])) {
                            ?>
                            <td class="decimales" style="text-align:right;">$<?php echo number_format($dee['precio'], $decimal); ?></td>
                            <td style="text-align:right;">$<?php echo number_format($dee['subtotal'], $decimal); ?></td>
                        <?php } ?>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="3" style="text-align:right;"><b>Totales</b></td>
                    <td style="text-align:right;"><?php echo number_format($total_cantidad, $decimal); ?></td>
                    <?php if (true || isset($where['tip_entrada'])) { ?>
                    <td class="decimales" style="text-align:right;"><?php// echo number_format($total_precio, $decimal); ?></td>
                    <td style="text-align:right;">$<?php echo number_format($total, $decimal); ?></td>
                    <?php } ?>
                </tr>
                <?php
                $total_unidades += $total_cantidad;
                $total_costo += $total;
                $registros++;
            }
        }
        ?>
        <tr>
            <td colspan="<?php echo $colspan + 1; ?>"></td>
        </tr>
        <tr style="background: #B9B9B9;">
            <td colspan="3" style="text-align: right;"><b>Total General</b></td>
            <td style="text-align: right;"><?php echo number_format($total_unidades, $decimal); ?></td>
            <td></td>
            <td style="text-align: right;">$<?php echo number_format($total_costo, $decimal); ?></td>
        </tr>
        <?php
    } else{
        ?>
        <tr><td style="text-align: center">No se encontraron registros</td></tr>
        <?php
    }    
    ?>


    <?php
    //Si la variable tipo reporte existe se declara la tabla
    if ($tipo_reporte != '') {
        ?>
    </table>
<?php } ?>