<?php
$ver_sectores = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
        }
        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }
        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }
        .tabla{
            border:1px solid black;
        }
        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
    <?php 
}

if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="9" >
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?><br />
                        Reporte de existencias
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php 
} 
$suma_exis = 0;
if ($tipo_reporte != '') {
    ?>
    <table class="tabla">
        <thead>
            <tr> 
                <th>Bodega</th>
                <th>Categoría</th>
                <th>Código</th>
                <th>Producto</th>
                <th>Marca</th>
                <?php if ($ver_sectores > 0 ) { ?>
                    <th>Sector</th>
                    <th>Códigos Adicionales</th>
                <?php } ?>
                <th>UM</th>
                <th>Saldo Actual</th>
            </tr>
        </thead>
        <tbody>
            <?php 
}

if (count($reporte) > 0) {
    $i = 1;
    foreach ($reporte as $row) {
        $suma_exis += $row['cantidad'];
        ?>
        <tr nobr="true">
            <?php if ($tipo_reporte == ''){ ?>
                <td style="display:none;"><?= $i; ?></td>
            <?php }; ?>
            <td ><?php echo $row['bodega']; ?></td>
            <td ><?php echo $row['linea']; ?></td>
            <td class="text"><?php echo $row['codigo']; ?></td>
            <td ><?php echo $row['nombre']; ?></td>
            <td ><?php echo $row['marca']; ?></td>
            <?php if ($ver_sectores > 0 ) { ?>
                <td ><?php echo $row['sector']; ?></td>
                <td class="text"><?php echo $row['codigo_secundario']; ?></td>
            <?php } ?>
            <td ><?php echo $row['UM']; ?></td>
            <td style="text-align: right;"><?php echo number_format($row['cantidad'], $decimales); ?></td>
        </tr>
        <?php
        $i++;
    }
    if ($tipo_reporte == '') {
        ?>
        <tr>
            <td style="display:none;"><?php echo $i; ?></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"><?php //marca ?></td>
            <?php if ($ver_sectores > 0 ) { ?>
                <td class="noborder-right"></td>
                <td class="noborder-right"></td>
            <?php } ?>
            <td style="text-align: right;font-weight: bold;">Total</td>
            <td style="text-align: right;font-weight: bold;"><?php echo number_format($suma_exis, $decimales); ?></td>        
        </tr>
        <?php
    }
} else {
    if ($tipo_reporte != '') {
        ?>
        <tr>
            <td colspan="<?= ($ver_sectores>0) ? 9 : 7;?>" style="text-align: center;font-weight: bold;"><br><br><span>No se encontraron registros</span><br></td>
        </tr>
        <?php
    }
}

if ($tipo_reporte != '') {
    ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="<?= ($ver_sectores>0) ? 8 : 6;?>" style="text-align: right;font-weight: bold;">Total</td>
                <td style="text-align: right;font-weight: bold;"><?php echo number_format($suma_exis, $decimales); ?></td>
            </tr>
        </tfoot>
    </table>
    <?php 
} ?>
