<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="9" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de existencias
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$registros = 1;
$pagina = null;
$i = 1;
//Si la variable tipo reporte existe se declara la tabla
?>

<?php
$suma_exis = 0;
$suma_costo = 0;
$suma_total = 0;
foreach ($reporte as $row):
    if ($tipo_reporte != '') {
        if ($i == 1) {
            ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th>Bodega</th>
                        <th>Categoría</th>
                        <th>Código</th>
                        <th>Producto</th>
                        <th>Cód. Lote</th>
                        <th>Fecha Venc.</th>
                        <th>Marca</th>
                        <th>UM</th>
                        <th>Proveedor</th>
                        <th>Saldo Actual</th>
                        <th>Costo</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
        }
    }
    $suma_exis += $row['cantidad'];
    $suma_costo += $row['precio'];
    $suma_total += $row['total'];
    ?>
                    <tr style="white-space: nowrap;">
                        <?php if ($tipo_reporte == ''): ?>
                            <td style="display:none;"><?php echo $registros; ?></td>
                        <?php endif; ?>
                        <td style="text-align:left;"><?php echo $row['bodega']; ?></td>
                        <td style="text-align:left;"><?php echo $row['linea']; ?></td>
                        <td style="text-align:left;"><?php echo $row['codigo']; ?></td>
                        <td style="text-align:left;"><?php echo $row['nombre']; ?></td>
                        <td style="text-align:left;"><?php echo $row['lote']; ?></td>
                        <td style="text-align:left;"><?php echo formatear_fecha('d-m-Y', $row['dee_fecha_caducidad']); ?></td>
                        <td style="text-align:left;"><?php echo $row['marca']; ?></td>
                        <td style="text-align:left;"><?php echo $row['UM']; ?></td>
                        <td style="text-align:left;"><?php echo $row['proveedor']; ?></td>
                        <td style="text-align:right;"><?php echo number_format($row['cantidad'], $decimales); ?></td>                        
                        <td style="text-align:right;">$<?php echo number_format($row['precio'], $decimales); ?></td>
                        <td style="text-align:right;">$<?php echo number_format($row['total'], $decimales); ?></td>
                    </tr>
    <?php 
    $i++; 
    //Si la variable tipo reporte existe se declara la tabla
    if ($tipo_reporte != '' && $tipo_reporte == 'pdf') {
        if ($i == 42 && $pagina == null) {
            $pagina = 1;
            ?>
                </tbody> 
            </table>
            <br style="page-break-after: always;" />
            <?php
            $i = 1;
        } else if ($i == 45 && $pagina != null) {
            ?>
                </tbody> 
            </table>
            <br style="page-break-after: always;" />
            <?php
            $i = 1;
        } else if ($registros == count($reporte)) {
            ?>
                    <tr>
                        <td colspan="9" style="text-align: right;font-weight: bold;">Totales</td>
                        <td style="text-align: right;font-weight: bold;"><?php echo number_format($suma_exis, $decimales); ?></td>
                        <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_costo, $decimales); ?></td>
                        <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_total, $decimales); ?></td>
                    </tr>
                </tbody> 
            </table>
            <?php
        }
    }
    $registros++;
endforeach;
?>

<?php if ($tipo_reporte == '') { 
    if($registros != 1){
        ?>
                    <tr>
                        <td style="display:none;"><?php echo $registros; ?></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="" style="text-align: center;font-weight: bold;">Total</td>
                        <td style="text-align: right;font-weight: bold;"><?php echo number_format($suma_exis, $decimales); ?></td>
                        <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_costo, $decimales); ?></td>
                        <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_total, $decimales); ?></td>
                    </tr>
                    <?php
    }
}

//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '' && $tipo_reporte == 'excel') {
    ?>
    <tr>
        <td colspan="9" style="text-align: right;font-weight: bold;">Total</td>
        <td style="text-align: right;font-weight: bold;"><?php echo number_format($suma_exis, $decimales); ?></td>
        <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_costo, $decimales); ?></td>
        <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_total, $decimales); ?></td>
    </tr>
    </tbody>
    </table>
<?php } ?>

