<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }

        <?php if ($tipo_reporte == 'pdf'): ?>
            .tabla{
                font-size: 6px;
            }
        <?php endif ?>
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="10" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de existencias
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
    ?>
    <table class="tabla">
        <thead>
            <tr>
                <th>Bodega</th>
                <th>Categoría</th>
                <th>Código</th>
                <th>Producto</th>
                <th>Marca</th>
                <th>Sector</th>
                <th>Código Secundario</th>
                <th>UM</th>
                <th>Saldo Actual</th>
                <th>Costo</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
    <?php
}

$i = 0;
$suma_exis = 0;
$suma_costo = 0;
$suma_total = 0;
if (count($reporte) > 0) {
    foreach ($reporte as $key => $row) {
        $suma_exis += $row['cantidad'];
        $suma_costo += $row['precio'];
        $suma_total += $row['total'];
        ?>
        <tr nobr="true">
            <?php if ($tipo_reporte == ''): ?>
                <td style="display: none;"><?php echo $i; ?></td>    
            <?php endif ?>
            <td style="text-align:center;"><?php echo $row['bodega']; ?></td>
            <td style="text-align:center;"><?php echo $row['linea']; ?></td>
            <td style="text-align:center;" class="text"><?php echo $row['codigo']; ?></td>
            <td style="text-align:center;"><?php echo $row['nombre']; ?></td>
            <td style="text-align:center;"><?php echo $row['marca']; ?></td>
            <td style="text-align:center;"><?php echo $row['sector']; ?></td>
            <td style="text-align:center;"><?php echo $row['codigo_secundario']; ?></td>
            <td style="text-align:center;"><?php echo $row['UM']; ?></td>
            <td style="text-align:right;"><?php echo number_format($row['cantidad'], $decimales); ?></td>
            <td style="text-align:right;">$<?php echo number_format($row['precio'], $decimales); ?></td>
            <td style="text-align:right;">$<?php echo number_format($row['total'], $decimales); ?></td>
        </tr>
        <?php
        $i++;
    }
} else {
    if ($tipo_reporte != '') {
        ?>
        <tr>
            <td colspan="11" style="text-align: center;font-weight: bold;">No se encontraron resultados</td>
        </tr>
        <?php
    }
}

if (count($reporte)>0) {
    if ($tipo_reporte != '') {
        ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="8" style="text-align: right;font-weight: bold;">Total</td>
                    <td style="text-align: right;font-weight: bold;"><?php echo number_format($suma_exis, $decimales); ?></td>
                    <td style="text-align: right;font-weight: bold;"><!-- $<?php// echo number_format($suma_costo, $decimales); ?> --></td>
                    <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_total, $decimales); ?></td>
                </tr>
            </tfoot>
        </table>
        <?php
    } else {
        ?>
        <tr>
            <td style="display: none;" class="noborder-right"><?=$i?></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="noborder-right"></td>
            <td class="" style="text-align: center;font-weight: bold;">Total</td>
            <td style="text-align: right;font-weight: bold;"><?php echo number_format($suma_exis, $decimales); ?></td>
            <td style="text-align: right;font-weight: bold;"><!-- $<?php //echo number_format($suma_costo, $decimales); ?> --></td>
            <td style="text-align: right;font-weight: bold;">$<?php echo number_format($suma_total, $decimales); ?></td>
        </tr>
        <?php
    }        
} else {
    if ($tipo_reporte != '') {
        ?>
            </tbody>
        </table>
        <?php
    }
}
?>

