<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de existencias
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$registros = 1;
$pagina = null;
$i = 1;
//Si la variable tipo reporte existe se declara la tabla
?>

<?php
$suma_exis = 0;
$suma_costo = 0;
$suma_total = 0;
if ($tipo_reporte != '') {
    ?>
    <table class="">
        <tr><td></td></tr>
        <tr>
            <td style="text-align: left;"><b>Reporte de documentos con número: <?php echo $num_documento; ?></b></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <?php
    }
    foreach ($reporte as $row):
        $total_cantidad = 0;
        $total_precio = 0;
        $total = 0;

        $tipo = "";

        if ($row['moi_id_dpv'] != null) {
            $tipo = "(Documento por proveedor)";
        }

        if ($row['moi_id_rtd'] != null) {
            $tipo = "(Retaceo)";
        }

        if ($row['moi_id_orc'] != null) {
            $tipo = "(Orden de compra)";
        }

        $where['dee_id_moi'] = $row['moi_id'];
        $colspan = (isset($where['tip_entrada'])) ? 4 : 2;
        $detalles = $this->inventario_model->get_movimientos_detalles($where);
        ?>
        <tr>
            <td><b>Fecha:</b></td>
            <td colspan="<?php echo $colspan; ?>"><b><?php echo date('d-m-Y', strtotime($row['moi_fecha_mov'])); ?></b></td>
        </tr>
        <tr>
            <td><b>Documento:</b></td>
            <td colspan="<?php echo $colspan; ?>"><?php echo $row['moi_documento'] . ' ' . $tipo; ?></td>
        </tr>
        <tr>
            <td><b>Descripción:</b></td>
            <td colspan="<?php echo $colspan; ?>"><?php echo $row['moi_descripcion']; ?></td>
        </tr>
        <tr>
            <td><b>Bodega:</b></td>
            <td colspan="<?php echo $colspan; ?>"><?php echo $row['bod_nombre']; ?></td>
        </tr>
        <tr>
            <td colspan="<?php echo $colspan + 1; ?>"></td>
        </tr>
        <tr>
            <th>Código</th>
            <th>Producto</th>
            <th>Cantidad</th>
            <?php
            //Solo en caso de ser entrada se muestra el precio y total
            if (isset($where['tip_entrada'])) {
                ?>
                <th>Precio</th>
                <th>Sub - Total</th>
            <?php } ?>
        </tr>
        <?php
        foreach ($detalles as $dee) {
            $total_cantidad += $dee['cant_art'];
            $total_precio += $dee['precio'];
            $total += $dee['subtotal'];
            ?>
            <tr>
                <td style="text-align:center;"><?php echo $dee['codigo']; ?></td>
                <td style="text-align:center;"><?php echo $dee['nombre']; ?></td>
                <td style="text-align:center;"><?php echo number_format($dee['cant_art'], 2); ?></td>
                <?php
                //Solo en caso de ser entrada se muestra el precio y total
                if (isset($where['tip_entrada'])) {
                    ?>
                    <td style="text-align:center;">$<?php echo number_format($dee['precio'], 2); ?></td>
                    <td style="text-align:center;">$<?php echo number_format($dee['subtotal'], 2); ?></td>
                <?php } ?>
            </tr>
            <?php
        }
        //$i++;
        ?>
        <tr>
            <td colspan="2" style="text-align:right;"><b>Totales</b></td>
            <td style="text-align:center;"><?php echo number_format($total_cantidad, 2); ?></td>
            <?php if (isset($where['tip_entrada'])) {
                ?>
                <td style="text-align:center;">$<?php echo number_format($total_precio, 2); ?></td>
                <td style="text-align:center;">$<?php echo number_format($total, 2); ?></td>
            <?php } ?>

        </tr>
        <?php
        $registros++;
    endforeach;
    ?>


    <?php
    //Si la variable tipo reporte existe se declara la tabla
    if ($tipo_reporte != '') {
        ?>
    </table>
<?php } ?>