<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Saldos Cero
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
    ?>
    <table class="tabla">
        <thead>
            <tr>
                <th>Producto</th>
                <th>Marca</th>
                <th>Características</th>
                <th>Descripción</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        if ($reporte):

            foreach ($reporte as $art) :

                $caracteristicas = explode(',', $art['caracteristicas']);
                $valor_caracteristica = explode(',', $art['carac_valores']);
                ?>
                <tr class="odd gradeX">
                    <td style="text-align:center;"><?php echo $art['art_nombre']; ?></td>
                    <td style="text-align:center;"><?php echo $art['marca']; ?></td>

                    <td style="text-align:center;padding: 0px;">
                        <table class="responsive table table-bordered" style="margin: 0px;">
                            <?php
                            if (count($caracteristicas) > 0):
                                for ($i = 0; $i < count($caracteristicas); $i++):
                                    ?>
                                    <tr>
                                        <td><?php echo ($caracteristicas[$i] != '') ? $caracteristicas[$i] : '--'; ?></td>
                                    </tr>
                                    <?php
                                endfor;
                            endif;
                            ?>
                        </table>
                    </td>
                    <td style="text-align:center;padding: 0px;">
                        <table class="responsive table table-bordered" style="margin: 0px;">
                            <?php
                            if (count($caracteristicas) > 0):
                                for ($i = 0; $i < count($caracteristicas); $i++):
                                    ?>
                                    <tr>
                                        <td><?php echo ($valor_caracteristica[$i] != '') ? $valor_caracteristica[$i] : '--'; ?></td>
                                    </tr>
                                    <?php
                                endfor;
                            endif;
                            ?>
                        </table>
                    </td>
                </tr>
                <?php
            endforeach;
        else:
            ?>
            <tr class="odd gradeX">
                <td>0</td>
                <td>Cero Registros Encontrados</td>
                <td class="center"></td>
            </tr>
        <?php endif; ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
            ?>
        </tbody>
    </table>
<?php } ?>