<?php 
    if($tipo_reporte == 'excel'){
        header("Content-Type: application/vnd.ms-excel");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("content-disposition: attachment;filename=" . $filename . ".xls");
    }
    $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
    if($tipo_reporte != 'grid'){
?>
<style type="text/css">
    .tabla
    {			
        width: 100%;
        margin-left: auto;
        margin-right: auto;
    }
    th
    {
        /*color: #FFFFFF;
        text-align: center;		
        background-color: #AAA;*/	 		
    }
    td
    {	
        text-align: center;
        font-family: arial;				
    }
    .impar
    {
        background-color: #D7E5F7;
    }
    .par
    {
        background-color: #B9D5F7;	
    }
    .fuente_titulo{
        font-family: <?php echo $tipo_fuente; ?>;
    }

    table#quedan {
        width: 90%;    
        margin: auto;
    }
    td#firma {
        background-color: black;   
        color: white;
    }
</style>
    <?php if($tipo_reporte == 'pdf'){ ?>
    <!--    MUESTRA LOS DATOS PARA EL REPORTE DE REQUICISION                        -->
    <table width="100%">
        <tr>
            <th>
                <table>
                    <thead>
                        <?php
                            if ($rxi_id) {
                        ?>
                                <tr>
                                    <th style="font-weight: bold;">No. Correlativo:</th>
                                    <th><?=$requisiciones[0]['rxi_numero']?></th>
                                    <?php if($modulo==2): ?>
                                        <th style="font-weight: bold;">Orden de Compra:</th>
                                        <th><?=$requisiciones[0]['orc_id']?></th>
                                        <?php else: ?>
                                        <th colspan="2"></th>
                                    <?php endif; ?>
                                </tr>
                                <tr>
                                    <th style="font-weight: bold;">Solicitante:</th>
                                    <th><?=$requisiciones[0]['nombre']?></th>
                                    <th style="font-weight: bold;">Departamento:</th>
                                    <th><?=$requisiciones[0]['are_nombre']?></th>
                                </tr>
                                <?php if($modulo == 1){ ?>
                                <tr>
                                    <th style="font-weight: bold;">Fecha de solicitud:</th>
                                    <th><?=formatear_fecha('Y-m-d', $requisiciones[0]['rxi_fecha'])?></th>
                                    <th style="font-weight: bold;">Bodega:</th>
                                    <th><?=$requisiciones[0]['bod_nombre']?></th>
                                </tr>
                                <tr>
                                    <th style="font-weight: bold;">Descripción:</th>
                                    <th><?=$requisiciones[0]['rxi_descripcion']?></th>
                                    <?php if( trim($requisiciones[0]['ord_codigo']) != ''){?>
                                        <th style="font-weight: bold;">Referencia:</th>
                                        <th><?=$requisiciones[0]['ord_codigo']?></th>
                                    <?php } ?>
                                </tr>
                                <?php } else{ ?>
                                <tr>
                                    <th style="font-weight: bold;">Fecha de solicitud:</th>
                                    <th><?=formatear_fecha('Y-m-d', $requisiciones[0]['rxi_fecha'])?></th>
                                    <th style="font-weight: bold;">Descripción:</th>
                                    <th><?=$requisiciones[0]['rxi_descripcion']?></th>
                                </tr>
                                    <?php if( trim($requisiciones[0]['ord_codigo']) != ''){?>
                                    <tr>
                                        <th style="font-weight: bold;">Referencia:</th>
                                        <th><?=$requisiciones[0]['ord_codigo']?></th>
                                    </tr>
                                <?php } } ?>
                        <?php
                            } else {
                        ?>
                            <tr>
                                <th style="font-weight: bold;"><h3 style="text-align: center;">Todas las requisiciones:</h3>
                                </th>
                            </tr>      
                        <?php
                            }
                        ?>
                        
                    </thead>
                </table>
            </th>
        </tr>
    </table>
    <?php } ?>
    <br>
    <br>
    <table border="1" width="100%">
        <thead>
            <?php
                if ($tipo_reporte == 'excel') {
            ?>
                <tr>
                    <th colspan="6" style="font-weight: bold;"><h3 style="text-align: center;">
                        <h3>Todas las requisiciones:</h3>
                    </th>
                </tr> 
            <?php
                }
            ?>
            <tr nobr="true" style="font-weight: bold;">
                <th>Código</th>
                <th>Producto</th>
                <th>Marca</th>
                <th>UM</th>
                <th>Saldo actual</th>
                <th>Cantidad a solicitar</th>
            </tr>
        </thead>
        <tbody>
        <?php 
            foreach ($requisiciones as $key) {
                $cantidad_actual_array = explode(" ", $key['cantidad_actual']);
                $cantidad_actual = $cantidad_actual_array[0] - $cantidad_actual_array[1] + $key['dri_cantidad_despacho'];
        ?>
            <tr nobr="true">
                <td style="text-align: left;"><?=$key['art_codigo']?></td>
                <td style="text-align: left;"><?=$key['art_nombre']?></td>
                <td style="text-align: left;"><?=$key['marca']?></td>
                <td style="text-align: left;"><?=$key['mep_nombre']?></td>
                <td style="text-align: left;"><?=number_format($cantidad_actual,$decimales)?></td>
                <td style="text-align: left;"><?=number_format($key['dri_cantidad'],$decimales)?></td>
            </tr>
        <?php } ?>
        </tbody>
    </table>
<?php } else{ ?>
<!--    MUESTRA LOS DATOS EN LA GRID DE REQUISICIONES PARA IMPRIMIR EL PDF                          -->
<table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
    <thead>
        <tr nobr="true">
            <th>No. Correlativo</th>
            <?php if($modulo == 2){?><th>Orden de Compra</th><?php } ?>
            <th>Solicitante</th>
            <?php if($modulo == 1){?><th>Bodega</th><?php } ?>
            <th>Departamento</th>
            <th>Estado</th>
            <th>Generar pdf</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($requisiciones as $key) { ?>
            <tr nobr="true">
                <td><?=$key['rxi_numero']?></td>
                <?php if($modulo == 2){?><td><?=$key['orc_id']?></td><?php } ?>
                <td><?=$key['nombre']?></td>
                <?php if($modulo == 1){?><td><?=$key['bod_nombre']?></td><?php } ?>                
                <td><?=$key['are_nombre']?></td>
                <td><?=$key['estado']?></td>
                <td>
                    <a href="#" target="_blank" class="generar_pdf" requisicion="<?=$key['rxi_id'];?>" >
                        <img src="<?php echo base_url();?>media/images/reporte/PDF.png" width="40px" heigth="40px;"/>
                    </a>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>
<?php }?>