<?php 
    if($tipo_reporte == 'excel'){
        header("Content-Type: application/vnd.ms-excel");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("content-disposition: attachment;filename=" . $filename . ".xls");
    }
    $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
    if($tipo_reporte != 'grid'){
?>
<style type="text/css">
    .tabla
    {			
        width: 100%;
        margin-left: auto;
        margin-right: auto;
    }
    th
    {
        font-weight: bold !important;
        /*color: #FFFFFF;
        text-align: center;		
        background-color: #AAA;*/	 		
    }
    td
    {	
        text-align: center;
        font-family: arial;				
    }
    .impar
    {
        background-color: #D7E5F7;
    }
    .par
    {
        background-color: #B9D5F7;	
    }
    .fuente_titulo{
        font-family: <?php echo $tipo_fuente; ?>;
    }

    table#quedan {
        width: 90%;    
        margin: auto;
    }

    td#firma {
        background-color: black;   
        color: white;
    }
</style>
    <?php if($tipo_reporte == 'pdf'){ ?>
    <!--    MUESTRA LOS DATOS PARA EL REPORTE HISTORICO                    -->
    <table>
        <thead>     
            <tr>
                <th colspan="2" width="12%">Fecha hasta:</th>
                <th colspan="5" width="38%"><?=$fecha_fin?></th>
            </tr>
        </thead>
    </table>
    <br>
    <?php } else{ ?>
    <table>
        <thead>
            <tr>
                <th colspan="9">Reporte histórico de existencias</th>
            </tr>
            <tr>
                <th colspan="9"></th>
            </tr>
            <tr>
                <th>Fecha hasta:</th>
                <th><?=$fecha_fin?></th>
            </tr>
        </thead>
    </table>
    <?php } ?>
    <br>
    
    <table border="1" width="100%">
        <tr>
            <th>Bodega</th>
            <th>Categoría</th>
            <th>Código</th>
            <th>Producto</th>
            <th>Cód. Lote</th>
            <th>UM</th>
            <th>Tipo</th>
            <th>Fecha</th>
            <th>Cantidad</th>
            <th>Existencias</th>
        </tr>
    <tbody>
        <?php 
        $registro = array();
        $suma_entrada = 0;
        $producto_temp = -1;
        $parametro = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $ndecimales = ($parametro != null)?$parametro:2;
        foreach ($existencias as $key) {
            $fecha = formatear_fecha('d-m-Y',$key['fecha_movimiento']);
            //$fecha_indice = formatear_fecha('dmY',$key['moi_fecha_mov']);

            if($producto_temp != $key['art_id']){
                $suma_entrada = 0;
                //$suma_entrada = $key['saldo_in'];
                $producto_temp = $key['art_id'];
            }

            if($key['tipo'] == 1){
                $suma_entrada += $key['entradas'];
                $precio_temp = $key['entradas'];
                $tipo_temp = 'Entrada';
            } else{
                $suma_entrada -= $key['salidas'];
                $precio_temp = $key['salidas'];
                $tipo_temp = 'Salida';
            }
        ?>
            <tr>
                <td><?=$key['bod_nombre']?></td>
                <td><?=$key['tia_nombre']?></td>
                <td><?=$key['art_codigo']?></td>
                <td><?=$key['art_nombre']?></td>
                <td><?=$key['dee_codigo_lote']?></td>
                <td><?=$key['mep_nombre']?></td>
                <td><?=$tipo_temp?></td>
                <td><?=$fecha?></td>
                <td><?=number_format($precio_temp, $ndecimales)?></td>
                <td><?=number_format($suma_entrada, $ndecimales)?></td>
            </tr>
        <?php 
            }
        ?>
    </tbody>
    </table>
<?php 
    } else{ 
        
?>
<!--    MUESTRA LOS DATOS EN LA GRID DE REQUISICIONES PARA IMPRIMIR EL PDF                          -->
<table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
    <thead>
        <tr>
            <th style="display: none;">N</th>
            <th>Bodega</th>
            <th>Categoría</th>
            <th>Código</th>
            <th>Producto</th>
            <th>Cód. Lote</th>
            <th>UM</th>
            <th>Tipo</th>
            <th>Fecha</th>
            <th>Cantidad</th>
            <th>Existencias</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $registro = array();
        $suma_entrada = 0;
        $numerador = 1;
        $producto_temp = -1;
        $precio_temp = 0;
        $tipo_temp = '';
        $parametro = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $ndecimales = ($parametro != null)?$parametro:2;
        //$suma_entrada = ($existencias[0]['saldo_in'] != null)?($existencias[0]['saldo_in'] != null):0;
        foreach ($existencias as $key) {
            $fecha = formatear_fecha('d-m-Y',$key['fecha_movimiento']);
            //$fecha_indice = formatear_fecha('dmY',$key['moi_fecha_mov']);

            if($producto_temp != $key['art_id']){
                $suma_entrada = 0;
                //$suma_entrada = $key['saldo_in'];
                $producto_temp = $key['art_id'];
            }

            if($key['tipo'] == 1){
                $suma_entrada += $key['entradas'];
                $precio_temp = $key['entradas'];
                $tipo_temp = 'Entrada';
            } else{
                $suma_entrada -= $key['salidas'];
                $precio_temp = $key['salidas'];
                $tipo_temp = 'Salida';
            }
        ?>
            <tr>
                <td style="display: none;"><?=$numerador++?></td>
                <td><?=$key['bod_nombre']?></td>
                <td><?=$key['tia_nombre']?></td>
                <td><?=$key['art_codigo']?></td>
                <td><?=$key['art_nombre']?></td>
                <td><?=$key['dee_codigo_lote']?></td>
                <td><?=$key['mep_nombre']?></td>
                <td><?=$tipo_temp?></td>
                <td><?=$fecha?></td>
                <td><?=number_format($precio_temp, $ndecimales)?></td>
                <td><?=number_format($suma_entrada, $ndecimales)?></td>
            </tr>
        <?php 
            }
        ?>
    </tbody>
</table>
<?php }?>