<table border="1" id="tabla_respuesta" class="table responsive table-bordered">
    <thead>
        <tr style="font-weight: bold;text-align: center;">
            <th width="7%">Código Producto</th>
            <th width="18%">Nombre del Producto</th>
            <th width="12%">Unidad de Medida</th>
            <th width="10%">Total Unidades</th> 
            <th width="10%">Costo Unitario</th>
            <th width="11%">Costo Total</th>
            <th width="13%">Categoría del Bien</th> 
            <th width="13%">Referencia en Libros</th>
            <th width="6%">Periodo</th> 
        </tr>
    </thead>
    <tbody>
        <?php if (count($articulos) > 0): ?>
            <?php
            foreach ($articulos as $key => $value) { 
                $ctdad_art = number_format($value['cantidad'], 10, '.', '');
                $costo_art = number_format($value['costo'], 10, '.', '');
                $total_art = $ctdad_art * $costo_art;
                switch ($value['art_referencia_del_bien']) {
                    case 1:
                        $category = 'Producto Terminado';
                        break;
                    case 2:
                        $category = 'Productos en Proceso';
                        break;
                    case 3:
                        $category = 'Materia Prima';
                        break;
                    case 4:
                        $category = 'Bien para la Construcción';
                        break;                
                    default:
                        $category = '---';
                        break;
                }
                switch ($value['art_referencia_en_libro']) {
                    case 1:
                        $referency = 'Costos';
                        break;
                    case 2:
                        $referency = 'Retaceos';
                        break;
                    case 3:
                        $referency = 'Compras Locales';
                        break;
                    default:
                        $referency = '---';
                        break;
                } 
                ?>
                <tr nobr="true">
                    <td width="7%" style='mso-number-format:"\@";'><?= $value['art_codigo'] ?></td>
                    <td width="18%"><?php echo mb_strtoupper($value['art_nombre'], 'UTF-8'); ?></td>
                    <td width="12%"><?php echo mb_strtoupper($value['medida'], 'UTF-8'); ?></td>
                    <td width="10%" style="text-align: right;"><?php echo number_format($value['cantidad'], $decimales); ?></td>
                    <td width="10%" style="text-align: right;"><?php echo '$' . number_format($value['costo'], $decimales); ?></td>
                    <td width="11%" style="text-align: right;"><?php echo '$' . number_format($total_art, $decimales); ?></td>
                    <td width="13%"><?php echo $category; ?></td>
                    <td width="13%"><?php echo $referency; ?></td>
                    <td width="6%"><?php echo $anio; ?></td>
                </tr>
                <?php 
            } 
            ?>            
        <?php endif ?>
    </tbody>        
</table>