<?php
if ($tipo_reporte == 'pdf') { 
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>REPORTE KARDEX DETALLADO</title>
    </head>
    <body>
        <script type="text/javascript">
            document.title = "<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> - REPORTE KARDEX DETALLADO";
            window.print();
        </script>
        <?php 
}

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
$input = "0\.";
$valor = str_pad($input, ($decimales + 3), 0, STR_PAD_RIGHT);

if ($tipo_reporte == 'excel') { ?>
    <style type="text/css">
        .decimales {
            mso-number-format: <?= $valor ?>;
        }
    </style>
    <meta charset="utf-8"/>
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="15">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br/>
                        Reporte de Kardex Detallado
                        <?php if (trim($subtitulo) != '') {
                            echo '<br>' . $subtitulo;
                        } ?>
                    </h4>
                </td>
            </tr>
            <?php if (trim($nrc) != '' && trim($nit) != ''){ ?>
                <tr>
                    <td align="left" colspan="5"><b><?php echo 'NIT: ' . $nit; ?></b></td>
                    <td align="center" colspan="5"><b><?php echo 'BODEGA: ' . $detalles[0]['bod_nombre']; ?></b></td>
                    <td align="right" colspan="5"><b><?php echo 'NRC: ' . $nrc; ?></b></td>
                </tr>
            <?php } ?>
        </table>
        <tr>
            <td colspan="15">&nbsp;</td>
        </tr>
    </div>
    <?php 
} ?>

<?php
$letra = ($tipo_reporte == 'pdf') ? 'style="font-size:11px;" width="100%" cellpadding="0" cellspacing="0"' : '';
$borde = ($tipo_reporte != '') ? 'style="border: solid 1px black;"' : '';
$bt_br = ($tipo_reporte != 'excel') ? 'style="border-bottom: solid 1px black;"' : '';
$exist_ini = 0;
$exist_fin = 0;
$tot_entra = 0;
$tot_salid = 0;
$sal_ext_ini = 0;
$sal_ext_fin = 0;
?>

<?php if ($tipo_reporte != '') { ?>
    <table <?= $letra ?> border="<?php echo ($tipo_reporte == 'pdf') ? 1 : 0; ?>">
        <thead>
            <tr style="font-weight: bold;text-align: center;">
                <th <?= $borde ?>>Código de<br>Artículo</th>
                <th <?= $borde ?>>Descripción</th>
                <th <?= $borde ?>>Fecha</th>
                <th <?= $borde ?>>Documento</th>
                <th <?= $borde ?>>Nombre</th>
                <th <?= $borde ?>>Nacionalidad</th>
                <th <?= $borde ?>>Tipo de<br>Movimiento</th>
                <th <?= $borde ?>>Existencias<br>Iniciales</th>
                <th <?= $borde ?>>Saldos<br>Iniciales</th>
                <th <?= $borde ?>>Entradas</th>
                <th <?= $borde ?>>Salidas</th>
                <th <?= $borde ?>>Costo<br>Unitario</th>
                <th <?= $borde ?>>Costo del<br>Movimiento</th>
                <th <?= $borde ?>>Existencias</th>
                <th <?= $borde ?>>Saldo</th>
            </tr>
        </thead>
        <tbody>
            <?php 
} ?>

<?php
if (count($detalles) > 0) {
    $i = 0;
    $print_cat = true;
    $print_art = true;
    $categoria = $detalles[0]['tia_id'];
    $articulo = $detalles[0]['art_id'];
    $ctdad_ini = $detalles[0]['inv_ini_uni'];
    $saldo_ini = $detalles[0]['inv_ini_tot'];
    $sum_entrada = $sum_salida = 0;
    foreach ($detalles as $key => $value) {
        if ($value['tia_id'] == $categoria) {
            if ($print_cat) {
                $cat_nom = ($value['padre_nombre'] != '') ? $value['padre_nombre'] : $value['tia_nombre'];
                $cat_cod = ($value['padre_codigo'] != '') ? $value['padre_codigo'] : $value['tia_codigo'];
                ?>
                <tr style="font-weight: bold;">
                    <td colspan="15" <?= $bt_br ?>><?php echo $cat_cod . ' - ' . $cat_nom; ?></td>
                </tr>
                <?php
                $print_cat = false;
            }
            if ($value['art_id'] == $articulo) {
                if ($print_art) {
                    ?>
                    <tr style="font-weight: bold;">
                        <td colspan="15" <?= $bt_br ?>><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre'] . '     (' . $value['mep_nombre'] . ')'; ?></td>
                    </tr>
                    <?php
                    $print_art = false;
                }
                $ctdad_row = $saldo_row = 0;
                $cantidad = $ctdad_ini;
                $saldo = $saldo_ini;
                if (($value['entradas'] > 0 || $value['salidas'] > 0) && isset($value['movimientos'])) {
                    foreach ($value['movimientos'] as $k => $val) {
                        if ($i == 0) {
                            $exist_ini += $ctdad_ini;
                            $sal_ext_ini += $saldo_ini;
                        }
                        $cantidad = $ctdad_ini;
                        $saldo = $saldo_ini;
                        $ctdad_row = $cantidad;
                        $saldo_row = $saldo;
                        $entrada = ($val['tip_entrada'] > 0) ? $val['dee_cantidad'] : '';
                        $compras = ($val['tip_entrada'] > 0) ? ($entrada * $val['dee_precio']) : 0;
                        $salida = ($val['tip_salida'] > 0) ? $val['dee_cantidad'] : '';
                        $ventas = ($val['tip_salida'] > 0) ? ($salida * $val['dee_precio']) : 0;
                        $ctdad_row += ($entrada != '') ? $entrada : 0;
                        $ctdad_row -= ($salida != '') ? $salida : 0;
                        $saldo_row += $compras;
                        $saldo_row -= $ventas;
                        $sum_entrada += ($entrada != '') ? $entrada : 0;
                        $sum_salida += ($salida != '') ? $salida : 0;
                        $doc_entrada = (trim($val['doc_entrada']) != "") ? $val['doc_entrada'] : $val['moi_documento'];
                        $doc_salida = (trim($val['doc_salida']) != "") ? $val['doc_salida'] : $val['moi_documento'];
                        ?>
                        <tr>
                            <td><?php echo ($i > 0) ? "" : $val['art_codigo']; ?></td>
                            <td><?php echo ($i > 0) ? "" : $val['art_nombre']; ?></td>
                            <td><?= formatear_fecha('d-m-Y', $val['moi_fecha_mov']) ?></td>
                            <td><?php echo ($val['tip_entrada'] == 1) ? $doc_entrada : $doc_salida; ?></td>
                            <td><?php echo ($val['prv_nombre'] != '') ? $val['prv_nombre'] : $val['cli_nombre']; ?></td>
                            <td><?php echo ($val['pais_prv'] != '') ? $val['pais_prv'] : $val['pais_cli']; ?></td>
                            <td><?= $val['tip_nombre'] ?></td>
                            <td style="text-align: right;"><?= number_format($cantidad, $decimales) ?></td>
                            <td class="decimales" style="text-align: right;">$<?= number_format($saldo, $decimales) ?></td>
                            <td style="text-align: right;"><?php echo ($entrada != '') ? number_format($entrada, $decimales) : ''; ?></td>
                            <td style="text-align: right;"><?php echo ($salida != '') ? number_format($salida, $decimales) : ''; ?></td>
                            <td class="decimales" style="text-align: right;">$<?= number_format($val['dee_precio'], $decimales) ?></td>
                            <td class="decimales" style="text-align: right;">$<?php echo ($val['tip_entrada'] == 1) ? number_format(($entrada * $val['dee_precio']), $decimales) : '(' . number_format(($salida * $val['dee_precio']), $decimales) . ')'; ?></td>
                            <td style="text-align: right;"><?= number_format($ctdad_row, $decimales) ?></td>
                            <td class="decimales" style="text-align: right;">$<?= number_format($saldo_row, $decimales) ?></td>
                        </tr>
                        <?php
                        $ctdad_ini = $ctdad_row;
                        $saldo_ini = $saldo_row;
                        $i++;
                    }
                } else {
                    if ($i == 0) {
                        $exist_ini += $ctdad_ini;
                        $sal_ext_ini += $saldo_ini;
                    }
                    $sum_entrada = 0;
                    $sum_salida = 0;
                    $ctdad_row += $value['inv_fin_uni'];
                    $saldo_row += $value['inv_fin_tot'];
                    ?>
                    <tr>
                        <td><?php echo ($i > 0) ? "" : $value['art_codigo']; ?></td>
                        <td><?php echo ($i > 0) ? "" : $value['art_nombre']; ?></td>
                        <td><!-- fecha moi --></td>
                        <td><!-- doc_entrada o doc_salida'] --></td>
                        <td><!-- prv_nombre o cli_nombre --></td>
                        <td><!-- pais_prv o pais_cli --></td>
                        <td><!-- tip_nombre --></td>
                        <td style="text-align: right;"><?= number_format($cantidad, $decimales) ?></td>
                        <td class="decimales" style="text-align: right;">$<?= number_format($saldo, $decimales) ?></td>
                        <td style="text-align: right;"><?php echo number_format(0, $decimales); ?><!-- entradas --></td>
                        <td style="text-align: right;"><?php echo number_format(0, $decimales); ?><!-- salidas --></td>
                        <td class="decimales" style="text-align: right;">$<?php echo number_format(0, $decimales); ?><!-- costo uni --></td>
                        <td class="decimales" style="text-align: right;">$<?php echo number_format(0, $decimales); ?><!-- costo tot --></td>
                        <td style="text-align: right;"><?= number_format($value['inv_fin_uni'], $decimales) ?></td>
                        <td class="decimales" style="text-align: right;">$<?= number_format($value['inv_fin_tot'], $decimales) ?></td>
                    </tr>
                    <?php
                }
            } else {
                $tot_entra += $sum_entrada;
                $tot_salid += $sum_salida;
                $exist_fin += $ctdad_row;
                $sal_ext_fin += $saldo_row;
                ?>
                <tr>
                    <td colspan="6"></td>
                    <td colspan="3" style="border-top: solid 1px black;"></td>
                    <td style="border-top: solid 1px black;text-align: right;"><?= number_format($sum_entrada, $decimales) ?></td>
                    <td style="border-top: solid 1px black;text-align: right;"><?= number_format($sum_salida, $decimales) ?></td>
                    <td colspan="4" style="border-top: solid 1px black;"></td>
                </tr>
                <?php
                $print_art = true;
                $articulo = $value['art_id'];
                $i = 0;
                $ctdad_ini = $value['inv_ini_uni'];
                $saldo_ini = $value['inv_ini_tot'];
                $sum_entrada = $sum_salida = 0;
                if ($print_art) {
                    ?>
                    <tr style="font-weight: bold;">
                        <td colspan="15" <?= $bt_br ?>><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre'] . '     (' . $value['mep_nombre'] . ')'; ?></td>
                    </tr>
                    <?php
                    $print_art = false;
                }
                $ctdad_row = $saldo_row = 0;
                $cantidad = $ctdad_ini;
                $saldo = $saldo_ini;
                if (($value['entradas'] > 0 || $value['salidas'] > 0) && isset($value['movimientos'])) {
                    foreach ($value['movimientos'] as $k => $val) {
                        if ($i == 0) {
                            $exist_ini += $ctdad_ini;
                            $sal_ext_ini += $saldo_ini;
                        }
                        $cantidad = $ctdad_ini;
                        $saldo = $saldo_ini;
                        $ctdad_row = $cantidad;
                        $saldo_row = $saldo;
                        $entrada = ($val['tip_entrada'] > 0) ? $val['dee_cantidad'] : '';
                        $compras = ($val['tip_entrada'] > 0) ? ($entrada * $val['dee_precio']) : 0;
                        $salida = ($val['tip_salida'] > 0) ? $val['dee_cantidad'] : '';
                        $ventas = ($val['tip_salida'] > 0) ? ($salida * $val['dee_precio']) : 0;
                        $ctdad_row += ($entrada != '') ? $entrada : 0;
                        $ctdad_row -= ($salida != '') ? $salida : 0;
                        $saldo_row += $compras;
                        $saldo_row -= $ventas;
                        $sum_entrada += ($entrada != '') ? $entrada : 0;
                        $sum_salida += ($salida != '') ? $salida : 0;
                        $doc_entrada = (trim($val['doc_entrada']) != "") ? $val['doc_entrada'] : $val['moi_documento'];
                        $doc_salida = (trim($val['doc_salida']) != "") ? $val['doc_salida'] : $val['moi_documento'];
                        ?>
                        <tr>
                            <td><?php echo ($i > 0) ? "" : $val['art_codigo']; ?></td>
                            <td><?php echo ($i > 0) ? "" : $val['art_nombre']; ?></td>
                            <td><?= formatear_fecha('d-m-Y', $val['moi_fecha_mov']) ?></td>
                            <td><?php echo ($val['tip_entrada'] == 1) ? $doc_entrada : $doc_salida; ?></td>
                            <td><?php echo ($val['prv_nombre'] != '') ? $val['prv_nombre'] : $val['cli_nombre']; ?></td>
                            <td><?php echo ($val['pais_prv'] != '') ? $val['pais_prv'] : $val['pais_cli']; ?></td>
                            <td><?= $val['tip_nombre'] ?></td>
                            <td style="text-align: right;"><?= number_format($cantidad, $decimales) ?></td>
                            <td class="decimales" style="text-align: right;">$<?= number_format($saldo, $decimales) ?></td>
                            <td style="text-align: right;"><?php echo ($entrada != '') ? number_format($entrada, $decimales) : ''; ?></td>
                            <td style="text-align: right;"><?php echo ($salida != '') ? number_format($salida, $decimales) : ''; ?></td>
                            <td class="decimales" style="text-align: right;">$<?= number_format($val['dee_precio'], $decimales) ?></td>
                            <td class="decimales" style="text-align: right;">$<?php echo ($val['tip_entrada'] == 1) ? number_format(($entrada * $val['dee_precio']), $decimales) : '(' . number_format(($salida * $val['dee_precio']), $decimales) . ')'; ?></td>
                            <td style="text-align: right;"><?= number_format($ctdad_row, $decimales) ?></td>
                            <td class="decimales" style="text-align: right;">$<?= number_format($saldo_row, $decimales) ?></td>
                        </tr>
                        <?php
                        $ctdad_ini = $ctdad_row;
                        $saldo_ini = $saldo_row;
                        $i++;
                    }
                } else {
                    if ($i == 0) {
                        $exist_ini += $ctdad_ini;
                        $sal_ext_ini += $saldo_ini;
                    }
                    $sum_entrada = 0;
                    $sum_salida = 0;
                    $ctdad_row += $value['inv_fin_uni'];
                    $saldo_row += $value['inv_fin_tot'];
                    ?>
                    <tr>
                        <td><?php echo ($i > 0) ? "" : $value['art_codigo']; ?></td>
                        <td><?php echo ($i > 0) ? "" : $value['art_nombre']; ?></td>
                        <td><!-- fecha moi --></td>
                        <td><!-- doc_entrada o doc_salida'] --></td>
                        <td><!-- prv_nombre o cli_nombre --></td>
                        <td><!-- pais_prv o pais_cli --></td>
                        <td><!-- tip_nombre --></td>
                        <td style="text-align: right;"><?= number_format($cantidad, $decimales) ?></td>
                        <td class="decimales" style="text-align: right;">$<?= number_format($saldo, $decimales) ?></td>
                        <td style="text-align: right;"><?php echo number_format(0, $decimales); ?><!-- entradas --></td>
                        <td style="text-align: right;"><?php echo number_format(0, $decimales); ?><!-- salidas --></td>
                        <td class="decimales" style="text-align: right;">$<?php echo number_format(0, $decimales); ?><!-- costo uni --></td>
                        <td class="decimales" style="text-align: right;">$<?php echo number_format(0, $decimales); ?><!-- costo tot --></td>
                        <td style="text-align: right;"><?= number_format($value['inv_fin_uni'], $decimales) ?></td>
                        <td class="decimales" style="text-align: right;">$<?= number_format($value['inv_fin_tot'], $decimales) ?></td>
                    </tr>
                    <?php
                }
            }
        } else {
            $tot_entra += $sum_entrada;
            $tot_salid += $sum_salida;
            $exist_fin += $ctdad_row;
            $sal_ext_fin += $saldo_row;
            ?>
            <tr>
                <td colspan="6"></td>
                <td colspan="3" style="border-top: solid 1px black;"></td>
                <td style="border-top: solid 1px black;text-align: right;"><?= number_format($sum_entrada, $decimales) ?></td>
                <td style="border-top: solid 1px black;text-align: right;"><?= number_format($sum_salida, $decimales) ?></td>
                <td colspan="4" style="border-top: solid 1px black;"></td>
            </tr>
            <?php
            $print_cat = true;
            $print_art = true;
            $categoria = $value['tia_id'];
            $articulo = $value['art_id'];
            $i = 0;
            $ctdad_ini = $value['inv_ini_uni'];
            $saldo_ini = $value['inv_ini_tot'];
            $sum_entrada = $sum_salida = 0;
            if ($print_cat) {
                $cat_nom = ($value['padre_nombre'] != '') ? $value['padre_nombre'] : $value['tia_nombre'];
                $cat_cod = ($value['padre_codigo'] != '') ? $value['padre_codigo'] : $value['tia_codigo'];
                ?>
                <tr style="font-weight: bold;">
                    <td colspan="15" <?= $bt_br ?>><?php echo $cat_cod . ' - ' . $cat_nom; ?></td>
                </tr>
                <?php
                $print_cat = false;
            }
            if ($print_art) {
                ?>
                <tr style="font-weight: bold;">
                    <td colspan="15" <?= $bt_br ?>><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre'] . '     (' . $value['mep_nombre'] . ')'; ?></td>
                </tr>
                <?php
                $print_art = false;
            }
            $ctdad_row = $saldo_row = 0;
            $cantidad = $ctdad_ini;
            $saldo = $saldo_ini;
            if (($value['entradas'] > 0 || $value['salidas'] > 0) && isset($value['movimientos'])) {
                foreach ($value['movimientos'] as $k => $val) {
                    if ($i == 0) {
                        $exist_ini += $ctdad_ini;
                        $sal_ext_ini += $saldo_ini;
                    }
                    $cantidad = $ctdad_ini;
                    $saldo = $saldo_ini;
                    $ctdad_row = $cantidad;
                    $saldo_row = $saldo;
                    $entrada = ($val['tip_entrada'] > 0) ? $val['dee_cantidad'] : '';
                    $compras = ($val['tip_entrada'] > 0) ? ($entrada * $val['dee_precio']) : 0;
                    $salida = ($val['tip_salida'] > 0) ? $val['dee_cantidad'] : '';
                    $ventas = ($val['tip_salida'] > 0) ? ($salida * $val['dee_precio']) : 0;
                    $ctdad_row += ($entrada != '') ? $entrada : 0;
                    $ctdad_row -= ($salida != '') ? $salida : 0;
                    $saldo_row += $compras;
                    $saldo_row -= $ventas;
                    $sum_entrada += ($entrada != '') ? $entrada : 0;
                    $sum_salida += ($salida != '') ? $salida : 0;
                    $doc_entrada = (trim($val['doc_entrada']) != "") ? $val['doc_entrada'] : $val['moi_documento'];
                    $doc_salida = (trim($val['doc_salida']) != "") ? $val['doc_salida'] : $val['moi_documento'];
                    ?>
                    <tr>
                        <td><?php echo ($i > 0) ? "" : $val['art_codigo']; ?></td>
                        <td><?php echo ($i > 0) ? "" : $val['art_nombre']; ?></td>
                        <td><?= formatear_fecha('d-m-Y', $val['moi_fecha_mov']) ?></td>
                        <td><?php echo ($val['tip_entrada'] == 1) ? $doc_entrada : $doc_salida; ?></td>
                        <td><?php echo ($val['prv_nombre'] != '') ? $val['prv_nombre'] : $val['cli_nombre']; ?></td>
                        <td><?php echo ($val['pais_prv'] != '') ? $val['pais_prv'] : $val['pais_cli']; ?></td>
                        <td><?= $val['tip_nombre'] ?></td>
                        <td style="text-align: right;"><?= number_format($cantidad, $decimales) ?></td>
                        <td class="decimales" style="text-align: right;">$<?= number_format($saldo, $decimales) ?></td>
                        <td style="text-align: right;"><?php echo ($entrada != '') ? number_format($entrada, $decimales) : ''; ?></td>
                        <td style="text-align: right;"><?php echo ($salida != '') ? number_format($salida, $decimales) : ''; ?></td>
                        <td class="decimales" style="text-align: right;">$<?= number_format($val['dee_precio'], $decimales) ?></td>
                        <td class="decimales" style="text-align: right;">$<?php echo ($val['tip_entrada'] == 1) ? number_format(($entrada * $val['dee_precio']), $decimales) : '(' . number_format(($salida * $val['dee_precio']), $decimales) . ')'; ?></td>
                        <td style="text-align: right;"><?= number_format($ctdad_row, $decimales) ?></td>
                        <td class="decimales" style="text-align: right;">$<?= number_format($saldo_row, $decimales) ?></td>
                    </tr>
                    <?php
                    $ctdad_ini = $ctdad_row;
                    $saldo_ini = $saldo_row;
                    $i++;
                }
            } else {
                if ($i == 0) {
                    $exist_ini += $ctdad_ini;
                    $sal_ext_ini += $saldo_ini;
                }
                $sum_entrada = 0;
                $sum_salida = 0;
                $ctdad_row += $value['inv_fin_uni'];
                $saldo_row += $value['inv_fin_tot'];
                ?>
                <tr>
                    <td><?php echo ($i > 0) ? "" : $value['art_codigo']; ?></td>
                    <td><?php echo ($i > 0) ? "" : $value['art_nombre']; ?></td>
                    <td><!-- fecha moi --></td>
                    <td><!-- doc_entrada o doc_salida'] --></td>
                    <td><!-- prv_nombre o cli_nombre --></td>
                    <td><!-- pais_prv o pais_cli --></td>
                    <td><!-- tip_nombre --></td>
                    <td style="text-align: right;"><?= number_format($cantidad, $decimales) ?></td>
                    <td class="decimales" style="text-align: right;">$<?= number_format($saldo, $decimales) ?></td>
                    <td style="text-align: right;"><?php echo number_format(0, $decimales); ?><!-- entradas --></td>
                    <td style="text-align: right;"><?php echo number_format(0, $decimales); ?><!-- salidas --></td>
                    <td class="decimales" style="text-align: right;">$<?php echo number_format(0, $decimales); ?><!-- costo uni --></td>
                    <td class="decimales" style="text-align: right;">$<?php echo number_format(0, $decimales); ?><!-- costo tot --></td>
                    <td style="text-align: right;"><?= number_format($value['inv_fin_uni'], $decimales) ?></td>
                    <td class="decimales" style="text-align: right;">$<?= number_format($value['inv_fin_tot'], $decimales) ?></td>
                </tr>
                <?php
            }
        }
    }//end foreach $detalles
    $tot_entra += $sum_entrada;
    $tot_salid += $sum_salida;
    $exist_fin += $ctdad_row;
    $sal_ext_fin += $saldo_row;
    ?>
    <tr>
        <td colspan="6"></td>
        <td colspan="3" style="border-top: solid 1px black;"></td>
        <td style="border-top: solid 1px black;text-align: right;"><?= number_format($sum_entrada, $decimales) ?></td>
        <td style="border-top: solid 1px black;text-align: right;"><?= number_format($sum_salida, $decimales) ?></td>
        <td colspan="4" style="border-top: solid 1px black;"></td>
    </tr>
    <tr>
        <td colspan="15"></td>
    </tr>
    <tr>
        <td colspan="7" style="border-top: solid 1px black;text-align: right;font-weight: bold;">TOTALES</td>
        <td style="font-weight: bold;text-align: right;border-top: solid 1px black"><?php echo number_format($exist_ini, $decimales); ?></td>
        <td style="font-weight: bold;text-align: right;border-top: solid 1px black"><?php echo '$' . number_format($sal_ext_ini, $decimales); ?></td>
        <td style="font-weight: bold;text-align: right;border-top: solid 1px black"><?php echo number_format($tot_entra, $decimales); ?></td>
        <td style="font-weight: bold;text-align: right;border-top: solid 1px black"><?php echo number_format($tot_salid, $decimales); ?></td>
        <td colspan="2" style="border-top: solid 1px black"></td>
        <td style="font-weight: bold;text-align: right;border-top: solid 1px black"><?php echo number_format($exist_fin, $decimales); ?></td>
        <td style="font-weight: bold;text-align: right;border-top: solid 1px black"><?php echo '$' . number_format($sal_ext_fin, $decimales); ?></td>
    </tr>
    <?php
} else {
    ?>
    <tr>
        <td colspan="15" style="text-align: center;"><b>NO SE HAN ENCONTRADO REGISTROS</b></td>
    </tr>
    <?php
}
?>

<?php 
if ($tipo_reporte != '') { 
    ?>
        </tbody>
    </table>
    <?php
    if (isset($tbl_rsum)) {
        echo $tbl_rsum;
    }
}
?>

<?php
if ($tipo_reporte == 'pdf') { 
    ?>
        </body>
    </html>
    <?php 
} ?>
