<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

$meses = array(
    '01' => 'Enero', 
    '02' => 'Febrero', 
    '03' => 'Marzo', 
    '04' => 'Abril', 
    '05' => 'Mayo', 
    '06' => 'Junio', 
    '07' => 'Julio',
    '08' => 'Agosto',
    '09' => 'Septiembre',
    '10' => 'Octubre', 
    '11' => 'Noviembre', 
    '12' => 'Diciembre'
);
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="3" >
                    <h3><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h3>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="3" >
                    <h4>REPORTE DE SALDO DE EXISTENCIAS EN BODEGA CORRESPONDIENTE AL MES DE <?php echo mb_strtoupper($meses[$mes]); ?> DE <?php echo $anio; ?></h4>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="3">
                    <h5>SECCION INVENTARIO</h5>
                </td>
            </tr>
        </table>
        <tr><td colspan="3">&nbsp;</td></tr>
    </div>
<?php } ?>

<?php 
$borde = ($tipo_reporte != '') ? 'border="1"' : 'border="0"';
$bt_br = ($tipo_reporte == 'excel') ? 'style="border-top: solid 1px black;"' : ''; 
?>

<table class="table" <?= $borde ?> >
    <thead>
        <tr style="font-weight: bold;text-align: center;">
            <th>N°</th>
            <?php foreach ($bodegas_reg as $key => $value): ?>
                <th><?php echo $value['bod_nombre']; ?></th>
            <?php endforeach ?>
            <th>Saldo</th> 
        </tr>
    </thead>
    <tbody>
        <?php 
        $saldo_total = 0;
        $saldo_temporal = 0;
        $total_bodega = array();
        $contador = 0;
        foreach ($reporte_reg as $key => $value) {            
            $saldo_temporal = 0;
            ?>
            <tr>
                <td>
                    <label style="padding: 6px 4px;"><?php echo $value['codigo']; ?></label>
                </td>
                <?php 
                foreach ($value['bodega'] as $key2 => $value2) { 
                    if(!isset($total_bodega[$contador])){
                        $total_bodega[$contador] = ($value2['monto']);
                    } else{
                        $total_bodega[$contador] += $value2['monto'];
                    }
                    $saldo_temporal += $value2['monto'];
                    $saldo_total += $value2['monto'];
                    ?>
                    <td>
                        <label style="padding: 6px 4px;"><?php echo number_format($value2['monto'], 2); ?></label>
                    </td>
                    <?php 
                    $contador++; 
                } 
                ?>
                <td>
                    <label style="padding: 6px 4px;"><?php echo $saldo_temporal; ?></label>
                </td>
            </tr>
            <?php 
            $contador = 0; 
        }         
        if(!(count($reporte_reg) > 0)){ 

        } 
        $contador = 0;
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td <?php echo $bt_br; ?>>
                <label style="padding: 6px 4px;">Totales</label>
            </td>
            <?php foreach ($bodegas_reg as $key => $value) { ?>
                <td <?php echo $bt_br; ?>>
                    <label style="padding: 6px 4px;"><?php echo number_format(((!isset($total_bodega[$contador])) ? 0 : $total_bodega[$contador]),2) ; ?></label>
                </td>
                <?php 
                $contador++; 
            } 
            ?>
            <td <?php echo $bt_br; ?>>
                <label style="padding: 6px 4px;"><?php echo number_format($saldo_total, 2); ?></label>
            </td>
        </tr>
    </tfoot>
</table>
    