<?php
$clases = ($tipo_reporte != "") ? "tabla" : "responsive display table table-bordered dataTable";
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=reporte_ajustes_inv.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <img src="<?= base_url() . 'media/imagenes/sistema/' . $this->gsatelite->get_parametro('SYS_LOGOTIPO') . '.png'; ?>" width="108px" height="48">
    <table border='0'>
        <tr><th colspan="9" style="text-align: center;"><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') ?></th></tr>
        <tr><th colspan="9" style="text-align: center;">Detalle de Ajustes de Invetario</th></tr>
        <?php if ($subtitulo != "") { ?>
            <tr><th colspan="9" style="text-align: center;"><?= $subtitulo ?></th></tr>
        <?php } ?>
    </table>
    <?php 
}
?>
 
<table class="<?= $clases ?>" id="datagried" border="<?= ($tipo_reporte != "") ? 1 : 0; ?>">
    <thead>
        <tr style="font-weight: bold;text-align: center;">
            <th>Ajuste</th>
            <th>Creado por</th>
            <th>Bodega</th>
            <th>Fecha</th>
            <th>Producto</th>
            <th>Tipo Movimiento</th>
            <th>Cantidad Física</th>
            <th>Cantidad Sistema</th>
            <th>Diferencia</th> 
        </tr>
    </thead>
    <tbody>
        <?php 
        if (count($registros) > 0) {
            foreach ($registros as $key => $value) {
                
                ?>
                <tr nobr="true">
                    <td><?php echo $value['aju_correlativo']; ?></td>
                    <td><?php echo $value['usuario_crea'] ?></td>
                    <td><?php echo $value['bodega']; ?></td>
                    <td>
                        <?php if ($tipo_reporte == "") { ?>
                            <span style="display: none;"><?php echo formatear_fecha('Ymd', $value['aju_fecha_ajuste']); ?></span>
                        <?php } ?>
                        <span><?php echo formatear_fecha('d-m-Y', $value['aju_fecha_ajuste']); ?></span>
                    </td>
                    <td><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre']; ?></td>
                    <td><?php echo $value['tipo_proc']; ?></td>
                    <td style="text-align: right;"><?php echo number_format($value['dea_cantidad_fisica'], $dec); ?></td>
                    <td style="text-align: right;"><?php echo number_format($value['dea_existencia'], $dec); ?></td>
                    <td style="text-align: right;"><?php echo number_format($value['diferencia'], $dec); ?></td>
                </tr>
                <?php 
            } 
        }
        ?>            
    </tbody>        
</table>

<?php if ($tipo_reporte == "") {
    ?>
    <script type="text/javascript">
        $(document).ready(function(){
            $('#datagried').dataTable({
                "bAutoWidth": false,
                "scrollX": true,
                "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]]
            });
            if($("#datagried tr").length > 1){
                $("#contenido").css({'height':'auto','width':'auto'});
            } 
        });
    </script>
    <?php 
} ?>