<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                       Reporte Existencia de Empaque
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
      
    }
    .titulo{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
       
    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td{
            vertical-align: middle;
            text-align: center;
        }
        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight:bold;
            font-size:10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
<?php } else { ?>
    <table class="responsive display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
<?php } ?>
    <thead>
        <tr>
            <th>Código</th>
            <th>Producto</th>
            <th>Lote</th>
            <th>Calidad</th>
            <th>Fecha Empaque</th>
            <th>Empaque</th>
            <th>Unidades</th>
            <th>Peso Neto</th>
            <th>Peso Bruto</th>
            <th>Torsión</th>
            <th>Entrelazado</th>
            <th>Origen</th>
        </tr>
    </thead>
<tbody id="tbl_contenedor">
<?php 
    if (count($existencias)>0) { 
        // Variables
        $total_neto       = 0;
        $total_bruto      = 0;
        $total_dmp_       = 0;

        $total_disponible = 0;
        $total_id_neto    = 0;
        $total_id_bruto   = 0;

        $contador         = 0;
        $contador_neto    = 0;
        $primera_vuelta   = true;

        $grado_evaluado = (isset($existencias[0]['grado_id']))?$existencias[0]['grado_id']:0;
        foreach ($existencias as $key => $value) { 
           ?>
            <!-- Condicional para imprimir los subtotales en cada una de las caracteristicas de calidad -->
            <?php if ($value['grado_id'] != $grado_evaluado) { ?>
                <!-- ******************************************************** -->
                  <tr nobr="true" style="font-weight: bold;">
                    <td colspan="5" style="text-align: center;font-weight: bold;">Sub-Total Disponible</td>
                    <td><?=$contador?></td>
                    <td><?=number_format($total_disponible, 2)?></td>
                    <td><?=number_format($total_id_neto, 2)?></td>
                    <td><?=number_format($total_id_bruto, 2)?></td>
                    <td colspan="3"></td>
                </tr>
            
                <?php 
                    $contador_neto += $contador;
                    $total_disponible = 0;
                    $total_id_neto    = 0;
                    $total_id_bruto   = 0; 
                    $contador         = 0;
                ?>
            <?php } ?>
                <!-- ******************************************************** -->
                <tr nobr="true">
                    <td><?=$value['art_codigo']?></td>
                    <td><?=$value['art_nombre']?></td>
                    <td><?=$value['dee_codigo_lote']?></td>
                    <td><?=$value['grado_valor']?></td>
                    <td><?=formatear_fecha('d-m-Y', $value['dee_fecha_creacion'])?></td>
                    <td><?=$value['dmp_codigo_empaque']?></td>
                    <td><?=number_format($value['dmp_cantidad'], 2)?></td>
                    <td><?=number_format($value['dmp_peso_neto'], 2)?></td>
                    <td><?=number_format($value['dmp_peso_bruto'], 2)?></td>
                    <td><?=$value['torsion_valor']?></td>
                    <td><?=$value['entre_valor']?></td>
                    <td><?=$value['origen_valor']?></td>
                </tr>
                <!-- ******************************************************** -->
            <?php 
                // Sumatoria totales
                $total_neto       += $value['dmp_peso_neto'];
                $total_bruto      += $value['dmp_peso_bruto'];
                $total_dmp_       += $value['dmp_cantidad'];

                $total_disponible += $value['dmp_cantidad'];
                $total_id_neto    += $value['dmp_peso_neto'];
                $total_id_bruto   += $value['dmp_peso_bruto'];
                $contador++;
            ?>

            <?php
                $grado_evaluado = (isset($value['grado_id']) && $value['grado_id'] != "")?trim($value['grado_id']):0;
            ?>

            <!-- Imprimir el ultimo subtotal -->
            <?php if (end($existencias)['dmp_id'] == $value['dmp_id']) { ?>
                <!-- ******************************************************** -->
                  <tr nobr="true" style="font-weight: bold;">
                    <td colspan="5" style="text-align: center;font-weight: bold;">Sub-Total Disponible</td>
                    <td><?=$contador?></td>
                    <td><?=number_format($total_disponible, 2)?></td>
                    <td><?=number_format($total_id_neto, 2)?></td>
                    <td><?=number_format($total_id_bruto, 2)?></td>
                    <td colspan="3"></td>
                </tr>
                <!-- ******************************************************** -->
                <?php 
                    $contador_neto += $contador;
                    $total_disponible = 0;
                    $total_id_neto    = 0;
                    $total_id_bruto   = 0; 
                    $contador         = 0;
                ?>

            <?php } ?>
            <!-- ******************************************************** -->
<?php   } ?>
            <tr style="font-weight: bold;text-align: center;" nobr="true">
                <td colspan="5">Total Disponible</td>
                <td><?=$contador_neto?></td>
                <td><?=number_format($total_dmp_, 2)?></td>
                <td><?=number_format($total_neto, 2)?></td>
                <td><?=number_format($total_bruto, 2)?></td>
                <td colspan="3"></td>
            </tr>
<?php   } else { ?>
        <tr>
            <td colspan="12" style="text-align: center;">
                No se encontraron registros
            </td>
        </tr>
<?php   }
?>
        <!-- ******************************************************** -->
</tbody> 
</table>