<meta http-equiv="content-type" content="text/html; charset=utf-8">
<?php 
//$tipo=1 (excel), $tipo=2 (pdf)
$pdf = ($t_rpt == 2) ? true : false;
if ($t_rpt == 1) {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
if ($t_rpt != "") {
    echo '<h4>' . $table_header . '</h4>';
}
?>
<h3>
<table cellpadding="1" cellspacing="0" id="checkAll" class="responsive table table-bordered" width="100%" <?= ($pdf) ? 'style="font-size: 9pt;"':''; ?> border="<?= ($t_rpt != "") ? 1 : 0; ?>">
    <thead>
        <tr>
            <th>Fecha</th>
            <th># de Documento</th>
            <th>Proveedor</th>
            <th>Categoría</th>
            <th>Producto</th>
            <th>Marca</th>
            <th>UM</th>
            <th>Entradas</th>
            <th>Salidas</th>
            <th>Saldo Actual</th>
            <?php if ($rpt == 'costo') { ?>
                <th>Costo ($)</th>
            <?php } ?>
        </tr>
    </thead>
    <tbody id="datagried">
        <?php
        $entradas = $salidas = $saldo = 0;
        if (count($datos) > 0) {
            $decimales=($this->gsatelite->get_parametro('NUMERO_DECIMALES')!=null)?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $cadena = "";
            foreach ($datos as $key => $sld) {
                $numero = explode(',', $sld['precios_costos']);
                $dos = "";
                for ($i = 0; $i < count($numero); $i++) {
                    $dos .= number_format($numero[$i], $decimales) . "<br>";
                }
                $fecha = ($sld['dpv_fecha'] != "") ? $sld['dpv_fecha'] : $sld['moi_fecha_mov'];
                $entradas += number_format($sld['Entradas'], $decimales, '.', '');
                $salidas += number_format($sld['Salidas'], $decimales, '.', '');
                $saldo += number_format($sld['Saldo'], $decimales, '.', '');
                ?>                
                <tr nobr="true">
                    <td><?= formatear_fecha('d-m-Y', $fecha) ?></td>
                    <td><?= ($sld['dpv_numero'] != "") ? $sld['dpv_numero'] : "--"; ?></td>
                    <td><?= $sld['proveedor'] ?></td>
                    <td><?= $sld['linea'] ?></td>
                    <td><?= $sld['nombre'] ?></td>
                    <td><?= $sld['marca'] ?></td>
                    <td><?= $sld['UM'] ?></td>
                    <td style='text-align: right'><?= number_format($sld['Entradas'], $decimales) ?></td>
                    <td style='text-align: right'><?= number_format($sld['Salidas'], $decimales) ?></td>
                    <td style='text-align: right'><?= number_format($sld['Saldo'], $decimales) ?></td>
                    <?php if ($rpt == 'costo') { ?>
                        <td style="text-align: right;"><?= $dos ?></td>
                    <?php } ?>
                </tr>
                <?php
            }
        } else {
            if ($t_rpt != "") {
                ?>
                <tr><td colspan="<?= ($rpt == 'costo') ? 11 : 10; ?>"><b>No se encontraron registros</b></td></tr>
                <?php
            }
        }
        ?>
    </tbody>
    <?php if (count($datos) > 0) { ?>
        <tfoot>
            <tr>
                <td colspan="7" style="text-align: right;"><b>Totales:</b></td>
                <td style="text-align: right;"><?= number_format($entradas, $decimales) ?></td>
                <td style="text-align: right;"><?= number_format($salidas, $decimales) ?></td>
                <td style="text-align: right;"><?= number_format($saldo, $decimales) ?></td>
                <?php if ($rpt == 'costo') {  ?>
                    <td></td>
                <?php } ?>                
            </tr>
        </tfoot>
    <?php } ?>
</table>