<?php 
switch ($detalles[0]['pkl_estado_picking_list']) {
    case 0:
        $estado = 'Anulado';
        break;
    case 1:
        $estado = 'Pendiente';
        break;    
    case 2:
        $estado = 'Completo';
        break;    
    default:
        # code...
        break;
}
 ?>
<form id="frm-picking" method="post" name="frm-picking" action="<?php echo base_url('inventario/gestion_productos/editar_picking_list/' . $id); ?>">
    <div class="row-fluid">
        <?php if (!$ver): ?>
            <div class="span12" style="text-align: right;">
                <?php $url = base_url('inventario/gestion_productos/picking_list'); ?>
                <button url="<?php echo $url; ?>" type="button" onclick="url = $('#regresarlistado').attr('url'); location.href = url;" class="btn" id="regresarlistado">
                    <span class="icon16 icomoon-icon-undo-2">Regresar</span>
                </button>
            </div>
        <?php endif ?>
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span class="icon16 icomoon-icon-equalizer-2"></span>
                        <span>Datos del Picking List</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>                
                <div class="content">
                    <?php if ($ver): ?>
                        <div class="form-row row-fluid">
                            <div class="span6">
                                <label class="form-label span3"><b>Estado:</b></label>
                                <div class="span7 controls">
                                    <input id="estado" type="text" class="tables-input" readonly="readonly" value="<?php echo $estado; ?>" />
                                </div>
                            </div>
                        </div>                        
                    <?php endif ?>
                    <div class="row-fluid">
                        <div class="span6">
                            <label class="form-label span3">Código:</label>
                            <div class="span7 controls">
                                <input id="code_pick" name="code_pick" type="text" class="tables-input" readonly="readonly" value="<?php echo $detalles[0]['pkl_codigo']; ?>" />
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Fecha:</label>
                                <div class="span7 controls">
                                    <input type="text" name="txtFecha" id="txtFecha" class="datePicker" readonly="readonly" value="<?php echo formatear_fecha('d-m-Y', $detalles[0]['pkl_fecha']) ?>"/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Cliente: </label>
                                <div class="span7 controls">
                                    <select id="slcCliente" name="slcCliente" class="nostyle">
                                        <option value=""></option>
                                        <?php echo $clientes; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <label class="form-label span3">Sucursal:</label>
                            <div class="span7 controls">
                                <input id="txtSucursal" name="txtSucursal" type="text" class="tables-input" value="<?php echo $info_usuario['suc_nombre']; ?>" readonly="readonly" />
                                <input name="idSucursal" type="hidden" value="<?php echo $info_usuario['suc_id']; ?>" />
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Vendedor:</label>
                                <div class="span7 controls">
                                    <select id="slcVendedor" name="slcVendedor" class="nostyle">
                                        <option value=""></option>
                                        <?php echo $vendedores; ?>
                                    </select>
                                </div>
                            </div>
                        </div>                        
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Comentario:</label>
                                <div class="span7 controls">
                                    <textarea id="txtComentario" name="txtComentario" style="width:100%;" maxlength="450"><?php echo $detalles[0]['pkl_descripcion']; ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- end content -->
            </div><!-- End .box -->
        </div><!-- End .span12 -->
    </div><!-- End .row-fluid -->
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span class="icon16 icomoon-icon-equalizer-2"></span>
                        <span>Datos de Ordenes de Venta</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Orden de Venta:</label>
                                <div class="span7 controls" id="contenedor_orden">
                                    <select id="slcOrden" name="slcOrden" class="nostyle">
                                        <option value=""></option>
                                        <?php echo $orden; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Bodega:</label>
                                <div class="span7 controls">
                                    <select id="slcBodega" name="slcBodega" class="nostyle">
                                        <option value=""></option>
                                        <?php echo $bodegas; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="title">
                    <h4><span>Listado de Artículos</span></h4>
                </div>
                <div class="content">
                    <table class="responsive table table-bordered contenedor" id="datagried" name="datagried">
                        <thead id="cabecera">
                            <tr>
                                <th>Código</th>
                                <th>Número Orden</th>
                                <th>Artículo</th>
                                <th>U/M</th>
                                <th>Número de Lote</th>
                                <th>Cantidad a solicitar</th>
                            </tr>
                        </thead>
                        <tbody id="contenedor">
                            <?php foreach ($detalles as $key => $value): ?>
                                <tr>
                                    <td><?= $value['pkl_codigo'] ?></td>
                                    <td><?= $value['orv_numero_orden'] ?></td>
                                    <td><?= $value['art_nombre'] ?></td>
                                    <td><?= $value['medida'] ?></td>
                                    <?php if ($value['ldp_id_lop'] != ''): ?>
                                        <td><?= $value['lotes'] ?></td>                                        
                                    <?php else: ?>
                                        <td>Sin Existencias</td>
                                    <?php endif ?>
                                    <td><?= $value['dxk_cantidad_solicita'] ?></td>
                                </tr>                                
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div><!-- end box -->
        </div><!-- end span 12 -->
        <br>
        <br>
        <div class="form-actions" style="text-align: center;">
            <?php if ($ver): ?>
                <button type="button" class="btn btn-danger icomoon-icon-undo-2 white" id="btn_cancelar"> Cerrar</button>                
            <?php else: ?>
                <button type="submit" class="btn btn-success enviar_formulario" name="btnCrear" value="1">
                    <span class="icon16 icomoon-icon-checkmark white">Actualizar</span>
                </button>
                <button type="submit" class="btn btn-success enviar_formulario" name="btnCrear" value="2">
                    <span class="icon16 icomoon-icon-checkmark white">Actualizar y volver a la lista</span>
                </button>                
                <a href="<?php echo base_url('inventario/gestion_productos/picking_list'); ?>" class="btn btn-danger btn-cancelar">
                    <span class="icon16 icomoon-icon-cancel-2 white">Cancelar</span>
                </a>
            <?php endif ?>
        </div>
    </div>
</form>

<script type="text/javascript">
    $(document).ready(function () {
        $('select').select2();
        $('#slcCliente').select2('disable');
        $('#slcOrden').select2('disable');
        $('#slcBodega').select2('disable');
        $('#slcVendedor').select2('disable');

        $("body").on("click", "#btn_cancelar", function() {
            parent.jQuery.fancybox.close();
        });
    });
</script>

