<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4><span>Detalle Requisición</span></h4>
            </div>
            <div class="content noPad clearfix">
                <div class="form-row row-fluid">
                    <div class="span6" style="<?php echo ($iframe == 1) ? 'margin-left: 10px;' : ''; ?>">
                        <div class="row-fluid">
                            <label runat="server" class="form-label span3" style="margin-right: 10px;">Requisición No.:</label>
                            <div class="span7 controls">
                                <input type="text" ReadOnly="ReadOnly" value="<?php echo $requisicion['rxi_numero']; ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="span6" style="margin-left: 10px;">
                        <div class="row-fluid">
                            <label runat="server" class="form-label span3">Fecha Solicitud:</label>
                            <div class="span7 controls">
                                <input type="text" ReadOnly="ReadOnly" value="<?php echo date('d-m-Y', strtotime($requisicion['rxi_fecha'])); ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="span6" style="margin-left: 10px;">
                        <div class="row-fluid">
                            <label runat="server" class="form-label span3" style="margin-right: 10px;">Tipo:</label>
                            <div class="span7 controls">
                                <?php
                                $tipo = '';
                                switch ($requisicion['rxi_tipo']) {
                                    case 1:
                                        $tipo = "Producto";
                                        break;
                                    case 2:
                                        $tipo = "Servicio";
                                        break;
                                    case 3:
                                        $tipo = "Activo Fijo";
                                        break;
                                }
                                ?>
                                <input type="text" ReadOnly="ReadOnly" value="<?php echo $tipo; ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="span6" style="margin-left: 10px;">
                        <div class="row-fluid">
                            <label runat="server" class="form-label span3">Solicitante:</label>
                            <div class="span7 controls">
                                <input type="text" ReadOnly="ReadOnly" value="<?php
                                echo (count($solicitante)>0)?$solicitante[0]['emp_nombre'] . ' ' . $solicitante[0]['emp_apellido']:'';
                                ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="span6" style="margin-left: 10px;">
                        <div class="row-fluid">
                            <label runat="server" class="form-label span3" style="margin-right: 10px;">Bodega:</label>
                            <div class="span7 controls">
                                <input type="text" ReadOnly="ReadOnly" value="<?php echo $bodega; ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="clear"><hr></div>
                    <div class="span6" style="margin-left: 10px;">
                        <div class="row-fluid">
                            <label class="form-label span3" style="margin-right: 10px;">Orden Producción:</label>
                            <div class="span7 controls">
                                <input type="text" readonly="readonly" value="<?= (count($orden) > 0) ? $orden[0]['ord_codigo'] : ""; ?>">
                            </div>
                        </div>
                    </div>
                    <?php
                    $articulos = array();
                    foreach ($orden as $key => $value) {
                        array_push($articulos, ($value['art_codigo'] . ' - ' . $value['art_nombre']));
                    }
                    ?>
                    <div class="span6" style="margin-left: 10px;">
                        <div class="row-fluid">
                            <label class="form-label span3">Productos por Orden:</label>
                            <div class="span7 controls">
                                <textarea readonly="readonly"><?php echo implode(',', $articulos); ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="span12" style="padding: 5px;overflow-x: scroll;margin-left: 0px;">
                        <div>
                            <table id="tblDetalleRequisicion" class="responsive table table-bordered simpleTable">
                                <thead>
                                    <tr>
                                        <th>Código</th>
                                        <th>Producto</th>
                                        <th>UM</th>
                                        <th>Saldo Actual</th>
                                        <th>Cantidad a Solicitar</th>
                                        <th>Cantidad Despachada</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (count($detalle_requisicion) > 0):
                                        foreach ($detalle_requisicion as $dri):

                                            $codigo_producto = "";
                                            $nombre_producto = "";
                                            $unidad_medida = "";
                                            $saldo_actual = "";
                                            $cantidad_sol = "";

                                            switch ($requisicion['rxi_tipo']) {
                                                case 1:
                                                    $codigo_producto = $dri['art_codigo'];
                                                    $nombre_producto = $dri['art_nombre'];
                                                    $unidad_medida = $dri['mep_nombre'];
                                                    $articulos = $this->inventario_model->obt_cant_minimaYexistente($dri['art_id'], $requisicion['rxi_id_bod']);
                                                    
                                                    $saldo_actual = 0;
                                                    if (count($articulos) > 0){
                                                        foreach ($articulos as $suma) {
                                                            $saldo_actual = $suma['suma'];
                                                        }
                                                        $saldo_actual = ($saldo_actual == null)?0:$saldo_actual;
                                                    }
                                                    $cantidad_sol = $dri['dri_cantidad'];
                                                    $cantidad_desp = $dri['dri_cantidad_despacho'];
                                                    break;
                                                case 2:
                                                    $codigo_producto = $dri['art_codigo'];
                                                    $nombre_producto = $dri['art_nombre'];
                                                    $unidad_medida = '---';
                                                    $saldo_actual = '---';
                                                    $cantidad_sol = $dri['dri_cantidad'];
                                                    $cantidad_desp = $dri['dri_cantidad_despacho'];
                                                    break;
                                                case 3:
                                                    $codigo_producto = $dri['act_codigo'];
                                                    $nombre_producto = $dri['act_nombre'];
                                                    $unidad_medida = '---';
                                                    $saldo_actual = '---';
                                                    $cantidad_sol = $dri['dri_cantidad'];
                                                    $cantidad_desp = $dri['dri_cantidad_despacho'];
                                                    break;
                                            }
                                            ?>
                                            <tr>
                                                <td><?php echo $codigo_producto; ?></td>
                                                <td><?php echo $nombre_producto; ?></td>
                                                <td><?php echo $unidad_medida; ?></td>
                                                <td><?php echo number_format($saldo_actual, $decimales); ?></td>
                                                <td><?php echo number_format($cantidad_sol, $decimales); ?></td>
                                                <td><?php echo number_format($cantidad_desp, $decimales); ?></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Opcion solamente cuando la requisicon este en parcial -->
<div class="row-fluid form-row">
    <div class="span12">
        <div class="span6">
            <form method="POST" action="<?php echo base_url('inventario/gestion_productos/imprimir_rxi'); ?>" target="_blank" id="frm_rxi" >
                <input type="hidden" name="num_rxi" value="<?php echo $requisicion['rxi_numero']; ?>"/>
                <input type="hidden" name="fecha_rxi" value="<?php echo date('d-m-Y', strtotime($requisicion['rxi_fecha'])); ?>"/>    
                <input type="hidden" name="tipo_rxi" value="<?php echo $requisicion['rxi_tipo']; ?>"/>
                <input type="hidden" name="stdo_rxi" value="<?php echo $requisicion['rxi_estado']; ?>"/>
                <input type="hidden" name="solic_rxi" value="<?php echo (count($solicitante)>0) ? $solicitante[0]['emp_nombre'] . ' ' . $solicitante[0]['emp_apellido'] : ''; ?>"/>
                <input type="hidden" name="bod_rxi" value="<?php echo $requisicion['rxi_id_bod']; ?>"/>
                <input type="hidden" name="id_rxi" value="<?php echo $requisicion['rxi_id']; ?>"/>            
                <button type="submit" class="btn btn-info icomoon-icon-file-pdf white btn-large">Imprimir</button>
            </form>
        </div>
    <?php if ($requisicion['rxi_estado'] == 6) { ?>
        <div class="span5" style="text-align: right;">
            <input type="hidden" id="txtValorCondicional" value="1">
            <button type="submit" class="btn btn-danger btn-large" id="btnFinalizar">Finalizar</button>
        </div>
        <script type="text/javascript">
            $(document).ready(function() {
                $(document).on('click', '#btnFinalizar', function(event) {            
                    event.preventDefault();
                    $.ajax({
                        url: urlj + 'inventario/gestion_productos/finalizar_requisicion',
                        type: 'POST',
                        dataType: 'json',
                        data: { requisicion:  <?php echo $requisicion['rxi_id']; ?> },
                        success: function(data){
                            if (data.resp == 1) {
                                crear_alerta('success', 'Requisición Finalizada', 'Requisición ha sido Finalizada');
                                $('#btnFinalizar').attr('disabled', 'disabled');
                                $.fancybox.close();
                            }
                            if (data.resp == 0) {
                                crear_alerta('error', 'Error', 'No se pudo Finalizar la Requisición');
                            }              
                        }
                    });
                });
            });
        </script>
        <div class="span1"></div>
    </div>
</div>

<?php }else{ ?>    
</div>
</div>
<?php } ?>