<meta charset="utf-8" />
<?php foreach ($css_files as $file): ?>
    <link type="text/css" rel="stylesheet" href="<?php echo $file; ?>" />
<?php endforeach; ?>
<?php foreach ($js_files as $file): ?>
    <script src="<?php echo $file; ?>"></script>
<?php endforeach; ?>
<style type='text/css'>
    body
    {
        font-family: Arial;
        font-size: 14px;
    }
    a {
        color: blue;
        text-decoration: none;
        font-size: 14px;
    }
    a:hover
    {
        text-decoration: underline;
    }
    .row-fluid .form-label{
        width: 23% !important;
    }
</style>
<form method="post" action="<?php echo base_url('inventario/gestion_productos/autorizar_traslado')?>" id="fitros_grid" name="fitros_grid">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Filtros </span>
                    </h4>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Desde:</label>
                                    <div class="span7 controls labels-info">
                                        <input type="text" id="txtFechaIni" name="txtFechaIni" class="datePicker" placeholder="dd-mm-yyyy" value="<?= formatear_fecha('d-m-Y', $f_ini) ?>" onchange="$('#txtFechaFin_error').html('');"/>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Hasta:</label>
                                    <div class="span7 controls labels-info">
                                        <input type="text" id="txtFechaFin" name="txtFechaFin"  class="datePicker" placeholder="dd-mm-yyyy" value="<?= formatear_fecha('d-m-Y', $f_fin) ?>" onchange="$('#txtFechaFin_error').html('');"/>
                                        <div id="txtFechaFin_error" style="color:red;padding-top:1%;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <div class="row-fluid">
                                        <button type="submit" id="btnConsultar" class="btn btn-success icomoon-icon-search-3">Filtrar</button>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Estado:</label>
                                    <div class="span7 controls labels-info">
                                        <select id="filEstado" name="filEstado" class="nostyle seleccion" placeholder="Seleccione">
                                            <option value=""></option>
                                            <option value="1" <?=($estado == 1) ? 'selected' : ''; ?>>Pendiente</option>
                                            <option value="2" <?=($estado == 2) ? 'selected' : ''; ?>>Autorizado</option>
                                            <option value="0" <?=($estado == 0) ? 'selected' : ''; ?>>Rechazado</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<div>
    <?php echo $output; ?>
</div>
<script>
    $(document).ready(function () {
        $("select").select2();

        $(".imprimir_traslado_temporal").attr('target', '_blank');

        $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });

        $("body").on('change', '.datePicker', function(event) {
            event.preventDefault();
            if ($("#txtFechaIni").val() != "" && $("#txtFechaFin").val() != "") {
                verifica_fecha($("#txtFechaIni").val(), $("#txtFechaFin").val());
            }
        });

        $("#fitros_grid").validate({
            ignore:"",
            rules: {
            }, 
            ignore: ".select2-container",
            errorPlacement: function (error, element) {
                var nombre=$(element).attr("id");
                $('#'+nombre+'_error').text('Campo requerido');
            },
            submitHandler: function(form) {
                if (verifica_fecha($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                    form.submit();    
                }                
            }
        });


    });

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            $("#txtFechaFin_error").text("Verifique las fechas del período");
            return false;
        }else{
            return true;
        }
    }
</script>