<form id="frm_ruta_anular" method="post" name="frm_ruta_anular" action="<?php echo base_url('inventario/gestion_productos/anular_ruta_entrega/' . $id); ?>">
    <input type="hidden" name="rte_id" value="<?php echo $id; ?>">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span class="icon16 icomoon-icon-equalizer-2"></span>
                        <span>Detalles de la Ruta</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>                
                <div class="content"> 
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Fecha Entrega:</label>
                                <div class="span7 controls">
                                    <input type="text" readonly id="txtFecha" class="datePicker" value="<?php echo formatear_fecha('d-m-Y', $detalles[0]['rte_fecha_entrega']); ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Hora Salida:</label>
                                <div class="span7 controls">
                                    <input type="text" id="hora" readonly value="<?php echo formatear_fecha('h:i a', $detalles[0]['rte_hora_salida']); ?>"/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <table class="responsive table table-bordered contenedor" id="datagried" name="datagried" style="font-size: 10pt;">
                                    <thead id="cabecera">
                                        <tr>
                                            <th width="10%">Numero<br>Factura</th>
                                            <th width="15%">Monto</th>
                                            <th width="25%">Cliente</th>
                                            <th width="25%">Dirección</th>
                                            <th width="25%">Comentarios</th>
                                        </tr>
                                    </thead>
                                    <tbody id="contenedor">
                                        <?php foreach ($detalles as $key => $value): ?>
                                            <tr>
                                                <td><?php echo '#' . $value['fac_numero'];?></td>
                                                <td style="text-align: right;"><?php echo '$' . number_format($value['fac_total'],2); ?></td>
                                                <td><?php echo ($value['cli_personeria'] == 1) ? $value['cli_nombre'] . ' ' . $value['cli_apellido'] : $value['cli_apellido']; ?></td>
                                                <td><?php echo $value['cli_direccion']; ?></td>
                                                <td><?php echo $value['dre_descripcion']; ?></td>
                                            </tr>                                
                                        <?php endforeach ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="form-actions" style="text-align: center;">
        <button type="button" class="btn btn-danger icomoon-icon-remove-6 white" id="btn_procesar"> Anular Ruta</button>
        &nbsp;
        <button type="button" class="btn btn-info icomoon-icon-reply white" id="btn_cancelar"> Regresar</button>
    </div>
</form>

<script type="text/javascript">
    $(document).ready(function() {

        $("body").on("click", "#btn_procesar", function() {
            alerta_confirm_ajax(procesar,data,'Confirmar Anulación','Esta ruta se anulará y las facturas podrán ser incluidas en otras rutas. ¿Éstas seguro que desea realizar la acción?');
        });

        function procesar(){    
            $("#frm_ruta_anular").submit();
        };

        $("body").on("click", "#btn_cancelar", function() {
            parent.jQuery.fancybox.close();
        });

        <?php if($this->session->flashdata('registro') > 0) { ?>
            var procesado = <?php echo $this->session->flashdata('registro'); ?>;
            var titulo    = '<?php echo $this->session->flashdata('titulo'); ?>';
            <?php $this->session->keep_flashdata('registro'); ?>
            <?php $this->session->keep_flashdata('titulo'); ?>
            var tipo  = (procesado == 1) ? 'success' : 'error';
            var icono = (procesado == 1) ? 'picon icon16 iconic-icon-check-alt white' : 'picon icon24 typ-icon-cancel white';
            var texto = (procesado == 1) ? 'El registro se ha eliminado correctamente.' : 'Hubo un problema al eliminar el registro.';
            parent.jQuery.pnotify({ 
                type: tipo, 
                title: titulo, 
                text: texto, 
                icon: icono, 
                opacity: 0.95, 
                history: false,
                sticker: false});
            parent.jQuery("#btnConsultar").trigger('click');
            parent.jQuery.fancybox.close();
        <?php } ?> 

    });

</script>