<form id="frm-picking" method="post" name="frm-picking" action="<?php echo base_url('inventario/gestion_productos/anular_picking_list/' . $id); ?>">
    <input type="hidden" name="pick_id" id="pick_id" value="<?php echo (isset($id)) ? $id : '';  ?>">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span class="icon16 icomoon-icon-equalizer-2"></span>
                        <span>Datos del Picking List</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>                
                <div class="content"> 
                    <div class="row-fluid">
                        <div class="span6">
                            <label class="form-label span4">Código:</label>
                            <div class="span7 controls">
                                <input id="code_pick" name="code_pick" type="text" class="tables-input" readonly="readonly" value="<?php echo (isset($detalles[0]['pkl_codigo'])) ? $detalles[0]['pkl_codigo'] : ''; ?>" />
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Fecha:</label>
                                <div class="span7 controls">
                                    <input type="text" name="txtFecha" id="txtFecha" class="datePicker" readonly="readonly" value="<?php echo isset($detalles[0]['pkl_fecha']) ? formatear_fecha('d-m-Y', $detalles[0]['pkl_fecha']) : ''; ?>"/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Cliente:</label>
                                <div class="span7 controls">
                                    <select id="slcCliente" name="slcCliente" class="nostyle">
                                        <option value=""></option>
                                        <?php echo $clientes; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <label class="form-label span4">Sucursal:</label>
                            <div class="span7 controls">
                                <input id="txtSucursal" name="txtSucursal" type="text" class="tables-input" value="<?php echo $info_usuario['suc_nombre']; ?>" readonly="readonly" />
                                <input name="idSucursal" type="hidden" value="<?php echo (isset($info_usuario['suc_id'])) ? $info_usuario['suc_id'] : ''; ?>" />
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Vendedor:</label>
                                <div class="span7 controls">
                                    <select id="slcVendedor" name="slcVendedor" class="nostyle">
                                        <option value=""></option>
                                        <?php echo $vendedores; ?>
                                    </select>
                                </div>
                            </div>
                        </div>                        
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Comentario:</label>
                                <div class="span7 controls">
                                    <textarea id="txtComentario" name="txtComentario" maxlength="450" class="nostyle" style="width: 100%" readonly="readonly"><?php echo (isset($detalles[0]['pkl_descripcion'])) ? $detalles[0]['pkl_descripcion'] : ''; ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row-fluid">
            <div class="span12">
                <div class="box">
                    <div class="title">
                        <h4>
                            <span class="icon16 icomoon-icon-equalizer-2"></span>
                            <span>Datos de Ordenes de Venta</span>
                        </h4>
                        <a href="#" class="maximize">Minimize</a>
                    </div>
                    <div class="content" style="display: none;">
                        <div class="row-fluid">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Orden de Venta:</label>
                                    <div class="span7 controls" id="contenedor_orden">
                                        <select id="slcOrden" name="slcOrden" class="nostyle">
                                            <option value=""></option>
                                            <?php echo $orden; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Bodega:</label>
                                    <div class="span7 controls">
                                        <select id="slcBodega" name="slcBodega" class="nostyle">
                                            <option value=""></option>
                                            <?php echo $bodegas; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="title">
                        <h4><span>Listado de Artículos</span></h4>
                        <a href="#" class="maximize">Minimize</a>
                    </div>
                    <div class="content" style="display: none;">
                        <table class="responsive table table-bordered contenedor" id="datagried" name="datagried">
                            <thead id="cabecera">
                                <tr>
                                    <th>Código</th>
                                    <th>Número Orden</th>
                                    <th>Artículo</th>
                                    <th>U/M</th>
                                    <th>Número de Lote</th>
                                    <th>Cantidad a solicitar</th>
                                </tr>
                            </thead>
                            <tbody id="contenedor">
                                <?php foreach ($detalles as $key => $value): ?>
                                    <tr>
                                        <td><?= $value['pkl_codigo'] ?></td>
                                        <td><?= $value['orv_numero_orden'] ?></td>
                                        <td><?= $value['art_nombre'] ?></td>
                                        <td><?= $value['medida'] ?></td>
                                        <?php if ($value['ldp_id_lop'] != ''): ?>
                                            <td><?= $value['lotes'] ?></td>                                        
                                        <?php else: ?>
                                            <td>Sin Existencias</td>
                                        <?php endif ?>
                                        <td><?= $value['dxk_cantidad_solicita'] ?></td>
                                    </tr>                                
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="row-fluid">
            <div class="span6 offset3">
                <label class="span5">Motivo de Anulación:<span class="required" style="color:red">&nbsp;*</span></label>
                <div class="span7 controls" id="div_observaciones">
                    <textarea rows="2" name="motivo_anulacion" id="motivo_anulacion" class="nostyle" maxlength="450"></textarea>
                    <div id="motivo_anulacion_error" style="color:red;margin-top: -10;position: absolute;"></div>
                </div>                      
            </div>
        </div>
    </div>
    <div class="form-actions" style="text-align: center;">
        <button type="button" class="btn btn-success icomoon-icon-cancel-2 white" id="btn_procesar"> Anular</button>
        <button type="button" class="btn btn-danger icomoon-icon-undo-2 white" id="btn_cancelar"> Cancelar</button>
        <div align="center">
            <br> 
            <span>Campos con asterisco en <font color='FE2E2E'>rojo</font> son requeridos</span>
        </div>
    </div>
</form>

<script type="text/javascript">
  $(document).ready(function() {
    $('select').select2();
        $('#slcCliente').select2('disable');
        $('#slcOrden').select2('disable');
        $('#slcBodega').select2('disable');
        $('#slcVendedor').select2('disable');

        $("#frm-picking").validate({
            ignore: "",
            rules: {
                'motivo_anulacion'        : {required: true}
            },
            // ignore: ".select2-container",
            errorPlacement: function (error, element) {
                var nombre = $(element).attr("id");
                $('#' + nombre + '_error').text('Campo requerido');
            },
            submitHandler: function (form) {
                form.submit();
            }
        });

        $("body").on("click", "#btn_procesar", function() {
            alerta_confirm_ajax(procesar,data,'Confirmar Anulación','Este Picking List se anulará y los artículos reservados seran liberados. ¿Éstas seguro que desea realizar la acción?');
        });

        function procesar(){    
            $("#frm-picking").submit();
        };

        $("body").on("click", "#btn_cancelar", function() {
            parent.jQuery.fancybox.close();
        });


        <?php if($this->session->flashdata('registro') > 0) { ?>
            var procesado = <?php echo $this->session->flashdata('registro'); ?>;
            var titulo    = '<?php echo $this->session->flashdata('titulo'); ?>';
            <?php $this->session->keep_flashdata('registro'); ?>
            <?php $this->session->keep_flashdata('titulo'); ?>
            var tipo  = (procesado == 1) ? 'success' : 'error';
            var icono = (procesado == 1) ? 'picon icon16 iconic-icon-check-alt white' : 'picon icon24 typ-icon-cancel white';
            var texto = (procesado == 1) ? 'El Picking List se ha anulado correctamente.' : 'El Picking List No se ha anulado correctamente.';
            parent.jQuery.pnotify({ 
                type: tipo, 
                title: titulo, 
                text: texto, 
                icon: icono, 
                opacity: 0.95, 
                history: false,
                sticker: false});
            parent.jQuery("#btnConsultar").trigger('click');
            parent.jQuery.fancybox.close();
        <?php } ?> 

    });
</script>