<?php 
if(isset($excel)){
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<style type="text/css">
    .tabla{
        font-weight: normal !important;
        font-family: 'Arial';
        border:1px solid black;
    }
    .tabla th{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .tabla td{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .num {
        mso-number-format:General;
    }
    .text{
        mso-number-format:"\@";
    }
</style>
<?php
if($excel != 1){
   echo $header;
   $size='10px';
}else{
    $size='10px';
    ?>
    <table style="font-size:14px; text-align:center;" >
        <tr><td colspan="6" style="font-weight:bold;text-align:center;"><?php echo $titulo; ?></td></tr>
    </table>
    <br>
    <?php
    }
?>
<br>
<table class="responsive table table-bordered" border="1" cellpadding="1" style="font-size:<?=$size?>" >
    <thead>
        <tr>
            <th width="4%" style="font-weight:bold;">N°</th>
            <th width="11%" style="font-weight:bold;">Código</th>
            <th width="25%" style="font-weight:bold;">Nombre</th>
            <th width="15%" style="font-weight:bold;">Tipo lista</th>
            <th width="15%" style="font-weight:bold;">Máximo descuento</th>
            <th width="15%" style="font-weight:bold;">Precio sin descuento</th>
            <th width="15%" style="font-weight:bold;">Precio con descuento</th>    
        </tr>
    </thead>
    <tbody>
        <?php 
        if(count($registros)>0) {
            $i=1;
            foreach ($registros as $fila) {
                $descuentos = "";
                if ($fila['lip_descuento_max'] != "") {
                    $descuentos = number_format($fila['lip_descuento_max'], 2) . '%';
                }
                ?>
                <tr nobr="true">
                    <td width="4%"><?php echo $i; ?></td>
                    <td width="11%" class="text"><?php echo $fila['art_codigo']; ?></td>
                    <td width="25%"><?php echo $fila['art_nombre']; ?></td>
                    <td width="15%"><?php echo $fila['tlp_nombre']; ?></td>
                    <td width="15%" style="text-align:right;"><?php echo $descuentos; ?></td>
                    <td width="10%" style="text-align:right;"><?php echo number_format($fila['art_precio_sugerido'], 4); ?></td>
                    <td width="10%" style="text-align:right;"><?php echo number_format($fila['lip_precio'], 4); ?></td>
                </tr>
                <?php
                $i++;
            }
        }else{
        ?>
        <tr>
            <td colspan="7" style="text-align:center">No se encontraron resultados</td>
        </tr>
        <?php
        }
        ?>
    </tbody>
</table>