<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

$mes_1      = date('m',strtotime($fecha_inicio)) - 1;
$dias_1     = date('d',strtotime($fecha_inicio));
$year_1     = date('Y',strtotime($fecha_inicio));

$mes_2      = date('m',strtotime($fecha_fin)) - 1;
$dias_2     = date('d',strtotime($fecha_fin));
$year_2     = date('Y',strtotime($fecha_fin));

$meses_fecha= array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
$meses      = array("Ene.","Feb.","Mar.","Abr.","May.","Jun.","Jul.","Ago.","Sep.","Oct.","Nov.","Dic.");
?>
<input type="hidden" id="titulo_grafico" value='Reporte comparativo de clientes'>
<?php if ($tipo_reporte == 'excel') { 
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte comparativo de clientes
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php 
} ?>
<style type="text/css">
    .totales{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;

    }
    .titulo{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;

    }
</style>
<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td{
            vertical-align: middle;
            text-align: center;
        }
        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight:bold;
            font-size:9;
        }
    </style>
<?php } ?>
<!-- Encabezado -->
<?php if ($tipo_reporte != '') { ?>
    <table>
        <tr>
            <td><b>Período: </b><?php echo ($meses_fecha[$mes_1] . " " . $year_1 . " Hasta " .  $meses_fecha[$mes_2] . " " . $year_1 ); ?></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
    </table>
<?php } ?>


<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead class="principal">
            <tr>
                <?php 
                $html           = "";
                $mes_evaluado   = intval($mes_1);
                $porcentaje     = floatval(80/( intval($meses_direrencia)+1));
                $html           .= '<th width="20%">Clientes</th>'; 

                for ($i=0; $i <= $meses_direrencia ; $i++) { 
                    $html .= '<th width="'.$porcentaje.'%">'.$meses[$mes_evaluado].' ($)</th>';    
                    $mes_evaluado++;          
                    //Se verifica si el mes sobrepasa a diciembre (11 en el arreglo de meses).
                    $mes_evaluado = ($mes_evaluado > 11) ? 0 : $mes_evaluado;
                }          
                echo $html;
                ?>
            </tr>
        </thead>
        <tbody id="tbl_contenedor_clientes">
            <?php 
            $html           = "";    
            $columan_clave  = array_column($comparativo, 'clave') ;   
            $columan_clave2  = array_column($comparativo, 'suma', 'clave') ;   
            foreach ($clientes as $key => $cliente) {
                $html          .= "<tr>"; 
                $mes_evaluado   = $mes_1+1;
                    $td_cliente     = '<td style="text-align: left;" width="20%">'.$nombres_clientes[$key].'</td>';//$key.'/'.
                    $td_meses       = '';
                    for ($i=0; $i <= $meses_direrencia ; $i++) {
                        $clave = $cliente."_".str_pad($mes_evaluado, 2, "0", STR_PAD_LEFT);
                        $llave = array_search($clave, $columan_clave);
                        if ( isset($columan_clave2[$clave]) ) {
                            //creo celda
                            if ($tipo_reporte != '') {
                                $td_meses  .= '<td style="text-align: right;" width="'.$porcentaje.'%">$' . number_format($columan_clave2[$clave], 2) . '</td>';
                            } else {
                                $td_meses  .= '<td style="text-align: right;" width="'.$porcentaje.'%">' . $columan_clave2[$clave] . '</td>';
                            }                            
                        } else {
                            //creo celda vacia con 0
                            if ($tipo_reporte != '') {
                                $td_meses  .= '<td style="text-align: right;" width="'.$porcentaje.'%">$0.00</td>';
                            } else {
                                $td_meses  .= '<td style="text-align: right;" width="'.$porcentaje.'%">0</td>';
                            }                            
                        }

                        $mes_evaluado++;          
                        //Se verifica si el mes sobrepasa a diciembre (11 en el arreglo de meses).
                        $mes_evaluado = ($mes_evaluado > 12) ? 0 : $mes_evaluado;

                    }
                    $html   .= $td_cliente.$td_meses."</tr>";
                }
                echo $html;
                // die();
                ?>
            </tbody> 
        </table>
        <table style="display: none;" id="grafico" name="grafico">

        </table>

        <br />

        <div  id="contenedor_grafico" style="width: 90%;">

        </div>
        <?php if ($tipo_reporte != 'pdf') { ?>
            <script src="<?php echo base_url(); ?>scripts/Highcharts-4.0.4/js/highcharts.js"></script>
            <script src="<?php echo base_url(); ?>scripts/Highcharts-4.0.4/js/modules/data.js"></script>
            <script src="<?php echo base_url(); ?>scripts/Highcharts-4.0.4/js/modules/exporting.js"></script>
            <script  type="text/javascript">
                if($(".principal").length != 0){
                    $(function () {
                        var tabla1 = $("#tbl_facturas").html();
                        $("#grafico").html(tabla1);
                        $('#grafico td').each(function(index, row){
                            var client = $(this).text();
                            var cad = client.split('-');
                            if(cad.length>1){
                                var newClient = cad[0];
                                var temp = '';
                                temp = newClient.toString();
                                temp = temp.trim();

                                $(this).text('CLI('+newClient+')');

                            }else{
                                var cad = client.split(' ');
                                if(cad.length>1){
                                    if(cad[0]!=='$'){
                                        var newClient = cad[0];
                                        var temp = '';
                                        temp = newClient.toString();
                                        temp = temp.trim();

                                        $(this).text('CLI('+newClient+')');   
                                    }else{
                                        var cant = $(this).text();

                                        $(this).text(cant.replace('$ ',''));
                                    }
                                }
                            }


                        });

                        var titulo_grafico = $("#titulo_grafico").val();
                        setTimeout(function(){
                           $('#contenedor_grafico').highcharts({
                            data: {
                            table: 'grafico'//ID de la tabla con los valores a graficar
                        },
                        chart: {
                            type: 'column'
                        },
                        title: {
                            text: titulo_grafico
                        },
                        yAxis: {
                            allowDecimals: false,
                            title: {
                                text: 'Reporte comparativo de clientes'
                            }
                        },
                        tooltip: {
                            formatter: function () {

                                return '<b>' + this.series.name + '</b><br/>' +
                                this.point.y + ' ' + this.point.name.toLowerCase();
                            }
                        }
                    });
                       }, 200);
                    });
                }
            </script>
            <?php } ?>