<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                       Reporte de anticipos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>



<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
    ?>
    <table class="">
        <tr><td colspan="4"></td></tr>
        <tr>
            <td style="width: 6%; text-align: left;"><b>Desde:</b></td>
            <td style="text-align: left;"><?php echo $fecha_inicio;?></td> 
            <td style="width: 6%; text-align: left;"><b>Hasta:</b></td>
            <td style="text-align: left;"><?php echo $fecha_fin;?></td>           
        </tr>
        <tr>
            <td style="width: 6%; text-align: left;"><b>Cliente:</b></td>
            <td style="text-align: left;"><?php echo $cliente_nombre;?></td> 
            <td style="width: 6%; text-align: left;"><b>Estado:</b></td>
            <td style="text-align: left;"><?php echo $estado_nombre;?></td>           
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th>Correlativo</th>
                <th>Cod. cliente</th>
                <th>Cliente</th>
                <th>F. anticipo</th>
                <th>No. comprobante</th>
                <th>Concepto</th>
                <th>Monto</th>
                <th>Aplicado</th>
                <th>Saldo</th>
                <th>F. vencimiento</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i = 0;
        $total_monto    = 0;
        $total_aplicado = 0;
        $total_saldo    = 0;
        foreach ($reporte as $row):
            $i++;
            $total_monto    = $total_monto + $row['anl_monto'];  
            $total_aplicado = $total_aplicado + ($row['anl_monto'] - $row['anl_saldo'] );
            $total_saldo    = $total_saldo + $row['anl_saldo'];
        ?>
            <tr class="dato">
                <td><?php echo $i; ?></td>
                <td><?php echo $row['cli_codigo']; ?></td>
                <td><?php echo $row['cliente']; ?></td>
                <td><?php echo formatear_fecha('d-m-Y',$row['anl_fecha']); ?></td>
                <td><?php echo $row['anl_comprobante']; ?></td>
                <td><?php echo $row['anl_descripcion']; ?></td>
                <td><?php echo number_format($row['anl_monto'],$cantidad_decimales); ?></td>
                <td><?php echo number_format( ($row['anl_monto'] - $row['anl_saldo'] ) ,$cantidad_decimales); ?></td>
                <td><?php echo number_format($row['anl_saldo'],$cantidad_decimales); ?></td>
                <td><?php echo formatear_fecha('d-m-Y',$row['anl_fecha_vencimiento']); ?></td>
                <td><?php echo $row['estado']; ?></td>
            </tr>
            <?php
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
            ?>
        </tbody> 
        <tfoot>
            <tr>
                <td colspan="6"><b>Total</b></td>
                <td><b><?php echo number_format($total_monto,$cantidad_decimales); ?></b></td>
                <td><b><?php echo number_format($total_aplicado,$cantidad_decimales); ?></b></td>
                <td><b><?php echo number_format($total_saldo,$cantidad_decimales); ?></b></td>
                <td colspan="2"></td>
            </tr>
        </tfoot>
    </table>
    <table>
        <tbody>
            <tr>
                <td style="height: 30px" colspan="12"></td>
            </tr>
            <tr style="border:0">
                <td colspan="2" style="text-align: right;">Recibe:</td>
                <td colspan="4">_________________________________</td>
                <td colspan="2" style="text-align: right;">Entrega:</td>
                <td colspan="4">_________________________________</td>
            </tr>
        </tbody>
    </table>
<?php } ?>

