<?php
if(isset($excel) && $excel==1){
    header("Content-type: application/vnd.ms-excel; name='Reporte_ventas_hora'");
    header("Content-Disposition: filename=Reporte_ventas_hora.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <table>
        <tr>
            <td colspan="5">
                <center><h4>Reporte de ventas por hora</h4></center>
            </td>
        </tr>
        <tr>
            <td colspan="5">&nbsp;
            </td>
        </tr>
    </table>
<?php } ?>

<style type="text/css">
    .tabla {     
        width: 100%;
        margin-left: auto;
        margin-right: auto;
    }

    td { 
        text-align: left;
        font-family: arial;       
    }
</style>

<?php 
    // Obtener los registros unicos
$suc_ids = array_unique(array_column($detalles, 'suc_id'));
$suc_nombres = array_unique(array_column($detalles, 'suc_nombre')); 
?>
<table class="responsive table table-bordered" border="1">
    <thead>
        <tr style="font-weight: bold;">
            <th colspan="3">Sucursal</th>
        </tr>
        <tr style="font-weight: bold;">
            <th>Caja</th>
            <th>Transacción</th>
            <th>Monto</th>  
        </tr>
    </thead>
    <tbody>
        <?php 
        $venta_total = 0;
        $trans_total = 0;
        if (!empty($suc_ids)) {
            foreach ($suc_ids as $llave => $id) {
                $total_por_caja = 0;
                $total_trans    = 0;
                ?>
                <tr>
                    <td colspan="3" style="font-weight: bold;" >
                        <?=$suc_nombres[$llave]?>
                    </td>
                </tr>
                <?php 
                foreach ($detalles as $key => $value) {
                    if ($value['suc_id'] == $id) { 
                        $total_trans += $value['transacciones'];
                        $total_por_caja += $value['monto'];
                        ?>
                        <tr>
                            <td><?=$value['caj_nombre']?></td>
                            <td style="text-align: right;"><?php echo $value['transacciones']; ?></td>
                            <td style="text-align: right;"><?php echo '$'.number_format($value['monto'], 2); ?></td>
                        </tr>
                        <?php 
                    }
                }
                // Resultados totales
                $venta_total += $total_por_caja;
                $trans_total += $total_trans;
                ?>
                <tr style="font-weight: bold;">
                    <td>Subtotal</td>
                    <td style="text-align: right;"><?=$total_trans?></td>
                    <td style="text-align: right;"><?='$'.number_format($total_por_caja, 2)?></td>
                </tr>
                <tr>
                    <td colspan="3"></td>
                </tr>
                <?php  
            }
        }else {
            ?>
            <tr>
                <td colspan="11" style="text-align:center;">No se encontraron registros</td>
            </tr>
            <?php    
        }
        ?>         
    </tbody>
    <tfoot>
        <tr style="font-weight: bold;">
            <td>Venta Total</td>
            <td style="text-align: right;"><?=$trans_total?></td>
            <td style="text-align: right;"><?='$'.number_format($venta_total, 2)?></td>
        </tr>
    </tfoot>
</table>