<?php 
if($tipo_reporte == 'excel'){
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}

$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if($tipo_reporte != 'grid'){
    $contador = 1;
    $contador2 = 1;
    $subtotal = 0;
    $descuento = 0;
    $exento = 0;
    $impuesto = 0;
    $total = 0;
    ?>
    <style type="text/css">
        .tabla
        {			
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }
        td
        {	
            text-align: center;
            font-family: arial;				
        }
        .impar
        {
            background-color: #D7E5F7;
        }
        .par
        {
            background-color: #B9D5F7;	
        }
        .fuente_titulo{
            font-family: <?php echo $tipo_fuente; ?>;
        }

        table#quedan {
            width: 90%;    
            margin: auto;
        }

        td#firma {
            background-color: black;   
            color: white;
        }
    </style>
    <?php if($tipo_reporte == 'excel'){ ?>
        <table>
            <thead>
                <tr>
                    <th colspan="6">Reporte de totales por caja</th>
                </tr>
                <tr>
                    <th colspan="1" width="12%">Fecha:</th>
                    <th colspan="2" width="38%"><?=$fecha_ini?> - <?=$fecha_fin?></th>
                    <th colspan="3">Rango de correlativos:</th>
                </tr>
                <tr>
                    <th colspan="1" width="12%">Caja:</th>
                    <th colspan="2" width="38%"><?=$caja_text?></th>
                    <th colspan="3" rowspan="3" style="vertical-align: top;" width="50%"><?=$rangos_corr_caja?></th>
                </tr>
                <tr>
                    <th colspan="1" width="12%">Cajero:</th>
                    <th colspan="2" width="38%"><?=$usuarios_caja?></th>
                </tr>
                <!-- EXCEL -->
                <tr>
                    <th colspan="1" width="12%">Sucursal:</th>
                    <th colspan="2" width="38%"><?=(isset($sucursal[0]['suc_nombre']))?$sucursal[0]['suc_codigo'].' - '.$sucursal[0]['suc_nombre']:''?></th>
                </tr>
            </thead>
        </table>
    <?php } else{ ?>
        <table>
            <thead>
                <tr>
                    <th colspan="1" width="12%">Fecha:</th>
                    <th colspan="5" width="38%"><?=$fecha_ini?> - <?=$fecha_fin?></th>
                    <th colspan="5">Rango de correlativos:</th>
                </tr>
                <tr>
                    <th colspan="1" width="12%">Caja:</th>
                    <th colspan="5" width="38%"><?=$caja_text?></th>
                    <th colspan="5" rowspan="3" style="vertical-align: top;" width="50%"><?=$rangos_corr_caja?></th>
                </tr>
                <tr>
                    <th colspan="1" width="12%">Cajero:</th>
                    <th colspan="5" width="38%"><?=$usuarios_caja?></th>
                </tr>
                <!-- PDF -->
                <tr>
                    <th colspan="1" width="12%">Sucursal:</th>
                    <th colspan="5" width="38%"><?=(isset($sucursal[0]['suc_nombre']))?$sucursal[0]['suc_codigo'].' - '.$sucursal[0]['suc_nombre']:''?></th>
                </tr>
            </thead>
        </table>
        <br>
    <?php } ?>
    <br>

    <table border="1" width="100%">
        <thead>
            <tr>
                <th>Descripción</th>
                <th>Descuentos</th>
                <th>Subtotal</th>
                <th>Exentos</th>
                <th>Impuestos</th>
                <th>Total (Menos Retenciones)</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $arreglo_tip_pagos = array();
            $total_pag_abono = 0;
            foreach ($registros_facturaxcaja as $key) {
                $subtotal += $key['fac_subtotal'];
                $descuento += $key['fac_descuento'];
                $exento += $key['exento'];
                $impuesto += $key['fac_impuesto'];
                $total += ($key['fac_subtotal'] + $key['fac_impuesto'] - $key['fac_total_retencion']); //suma del subtotal mas el impuesto menos las retenciones
                $abonos_array = array();
                $columnas = 1;
                if( trim($key['abonos']) != ""){ //verificamos si el abono no esta vacio, en el caso q si, no muestra nada
                    $columnas = 1;
                    $abonos_temp = explode(',', $key['abonos']); //separamos la columna abonos format(n, abf_monto, tpg_id, tpg_nombre, dab_monto) donde n es 0 pero si el tpg id es 0 nos agrupa el abono por el numero 1 y si no nos crea detalles por el tpg
                    foreach ($abonos_temp as $key2) {
                        $abono_detalle = explode('-', $key2); //separamos todos los registros que separamos en la columna abonos
                        if($abono_detalle[2] == 0){ // verificamos si el abono no se hizo por detalle en la de pagos
                            if(!isset($abonos_array[$key['tpg_id']])){ //verificamos si el arreglo existe
                            //si no existe el abono lo creamos y le asignamos el indice del id tpg y el nombre q trae la factura y el monto sera el que nos devuelve la cadena de abonos
                                $abonos_array[$key['tpg_id']] = array("tip_pago" => $key['tpg_nombre'], "abono" => $abono_detalle[1], "id"=>$key['tpg_id']);
                            } else{
                                $abonos_array[$key['tpg_id']]['abono'] += $abono_detalle[1];
                            }
                        } else{
                            if(!isset($abonos_array[$abono_detalle[2]])){
                                //si tiene un detalle el abono creamos el indice con el tpg que nos trae el detalle de abono en el caso de que exista el tpg solo sumamos el monto del tpg para sumar en los detalles individuales del abono
                                $abonos_array[$abono_detalle[2]] = array("tip_pago" => $abono_detalle[3], "abono" => $abono_detalle[4], "id"=>$abono_detalle[2]);
                            } else{
                                $abonos_array[$abono_detalle[2]]['abono'] += $abono_detalle[4];
                            }
                        }
                    }
                }
                
                foreach ($abonos_array as $key3) { 
                    //si tiene abono recorremos el arreglo que creamos
                    if(!(isset($arreglo_tip_pagos[$key3['id']]))){
                        $arreglo_tip_pagos[$key3['id']] = array('tip_pago'=>$key3['tip_pago'], 'abono'=>$key3['abono']);
                    } else{
                        $arreglo_tip_pagos[$key3['id']]['abono'] += $key3['abono'];
                    }
                }
            }
            ?>
            <tr>
                <td colspan="1" style="text-align: right">Total</td>
                <td style="text-align: right;">$<?=number_format($descuento,2)?></td>
                <td style="text-align: right;">$<?=number_format($subtotal,2)?></td>
                <td style="text-align: right;">$<?=number_format($exento,2)?></td>
                <td style="text-align: right;">$<?=number_format($impuesto,2)?></td>
                <td style="text-align: right;">$<?=number_format($total,2)?></td>
            </tr>
            <?php foreach ($arreglo_tip_pagos as $key) { //recorremos los tipos de pagos 
                $total_pag_abono += $key['abono'];
                ?>
                <tr>
                    <td colspan="5" style="text-align: right"><?=$key['tip_pago']?></td>
                    <td style="text-align: right;">$<?=number_format($key['abono'],2)?></td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="5" style="text-align: right">Total efectivo a remesar</td>
                <td style="text-align: right;">$<?=number_format($total_pag_abono,2)?></td>
            </tr>
        </tbody>
    </table>
<?php } else{ 
    $contador = 1;
    $subtotal = 0;
    $descuento = 0;
    $exento = 0;
    $impuesto = 0;
    $total = 0;
    ?>
    <table class="tabla" align="center" cellpadding="0" border="0" style="margin-left:auto;margin-right:auto">
        <thead>
            <tr>
                <th>
                    <table border="1" width="100%">
                        <thead>
                            <tr>
                                <th colspan="1">Fecha:</th>
                                <th colspan="2"><?=$fecha_ini?> - <?=$fecha_fin?></th>
                                <th colspan="3">Rango de correlativos:</th>
                            </tr>
                            <tr>
                                <th colspan="1">Caja:</th>
                                <th colspan="2"><?=$caja_text?></th>
                                <th colspan="3" rowspan="3" style="vertical-align: top;" width="50%"><?=$rangos_corr_caja?></th>
                            </tr>
                            <tr>
                                <th colspan="1" width="12%">Cajero:</th>
                                <th colspan="2" width="38%"><?=$usuarios_caja?></th>
                            </tr>
                            <tr>
                                <th colspan="1" width="12%">Sucursal:</th>
                                <th colspan="2" width="38%"><?=(isset($sucursal[0]['suc_nombre']))?$sucursal[0]['suc_codigo'].' - '.$sucursal[0]['suc_nombre']:''?></th>
                            </tr>                        
                            <tr>
                                <th>Descripción</th>
                                <th>Descuentos</th>
                                <th>Subtotal</th>
                                <th>Exentos</th>
                                <th>Impuestos</th>
                                <th>Total (Menos Retenciones)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $arreglo_tip_pagos = array();
                            $total_pag_abono = 0;
                            foreach ($registros_facturaxcaja as $key) {
                                $subtotal += $key['fac_subtotal'];
                                $descuento += $key['fac_descuento'];
                                $exento += $key['exento'];
                                $impuesto += $key['fac_impuesto'];
                                $total += ($key['fac_subtotal'] + $key['fac_impuesto'] - $key['fac_total_retencion']); //suma del subtotal mas el impuesto menos las retenciones
                                $abonos_array = array();
                                $columnas = 1;
                                if( trim($key['abonos']) != ""){ 
                                    //verificamos si el abono no esta vacio, en el caso q si, no muestra nada
                                    $columnas = 0;
                                    $abonos_temp = explode(',', $key['abonos']);
                                    //separamos la columna abonos format(n, abf_monto, tpg_id, tpg_nombre, dab_monto) donde n es 0 pero si el tpg id es 0 nos agrupa el abono por el numero 1 y si no nos crea detalles por el tpg
                                    foreach ($abonos_temp as $key2) {
                                        $abono_detalle = explode('-', $key2); 
                                        //separamos todos los registros que separamos en la columna abonos
                                        if($abono_detalle[2] == 0){ 
                                            // verificamos si el abono no se hizo por detalle en la de pagos
                                            if(!isset($abonos_array[$key['tpg_id']])){
                                                //verificamos si el arreglo existe,  si no existe el abono lo creamos y le asignamos el indice del id tpg y el nombre q trae la factura y el monto sera el que nos devuelve la cadena de abonos
                                                $abonos_array[$key['tpg_id']] = array("tip_pago" => $key['tpg_nombre'], "abono" => $abono_detalle[1], "id"=>$key['tpg_id']);
                                            } else{
                                                $abonos_array[$key['tpg_id']]['abono'] += $abono_detalle[1];
                                            }
                                        } else{
                                            if(!isset($abonos_array[$abono_detalle[2]])){
                                            //si tiene un detalle el abono creamos el indice con el tpg que nos trae el detalle de abono en el caso de que exista el tpg solo sumamos el monto del tpg para sumar en los detalles individuales del abono
                                                $abonos_array[$abono_detalle[2]] = array("tip_pago" => $abono_detalle[3], "abono" => $abono_detalle[4], "id"=>$abono_detalle[2]);
                                            } else{
                                                $abonos_array[$abono_detalle[2]]['abono'] += $abono_detalle[4];
                                            }
                                        }
                                    }
                                    //print_r($abonos_array);
                                    $columnas = count($abonos_array)+1; 
                                    //esto nos dice cuantos abono por factura individual hay para combinar los rowspan de los td
                                }
                                
                                foreach ($abonos_array as $key3) { 
                                    //si tiene abono recorremos el arreglo que creamos
                                    if(!(isset($arreglo_tip_pagos[$key3['id']]))){
                                        $arreglo_tip_pagos[$key3['id']] = array('tip_pago'=>$key3['tip_pago'], 'abono'=>$key3['abono']);
                                    } else{
                                        $arreglo_tip_pagos[$key3['id']]['abono'] += $key3['abono'];
                                    }
                                }
                                $contador++; 
                            }
                            ?>
                            <tr>
                                <td colspan="1" style="text-align: right">Total</td>
                                <td style="text-align: right;">$<?=number_format($descuento,2)?></td>
                                <td style="text-align: right;">$<?=number_format($subtotal,2)?></td>
                                <td style="text-align: right;">$<?=number_format($exento,2)?></td>
                                <td style="text-align: right;">$<?=number_format($impuesto,2)?></td>
                                <td style="text-align: right;">$<?=number_format($total,2)?></td>
                            </tr>
                            <?php foreach ($arreglo_tip_pagos as $key) { 
                                //recorremos los tipos de pagos 
                                $total_pag_abono += $key['abono'];
                                ?>
                                <tr>
                                    <td colspan="5" style="text-align: right"><?=$key['tip_pago']?></td>
                                    <td style="text-align: right;">$<?=number_format($key['abono'],2)?></td>
                                </tr>
                            <?php } ?>
                            <tr>
                                <td colspan="5" style="text-align: right">Total efectivo a remesar</td>
                                <td style="text-align: right;">$<?=number_format($total_pag_abono,2)?></td>
                            </tr>
                        </tbody>
                    </table>
                </th>
            </tr>
        </thead>
    </table>
    <?php 
}?>